/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.collect.CollectionEnclosedIterable;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class CollectionBuilder<T> {
    private final List<T> elements = new LinkedList<T>();

    public static <T> CollectionBuilder<T> newBuilder() {
        return new CollectionBuilder(Collections.emptyList());
    }

    public static <T> CollectionBuilder<T> newBuilder(T ... elements) {
        return new CollectionBuilder<T>(Arrays.asList(elements));
    }

    CollectionBuilder(Collection<? extends T> initialElements) {
        this.elements.addAll(initialElements);
    }

    public CollectionBuilder<T> add(T element) {
        this.elements.add(element);
        return this;
    }

    public <E extends T> CollectionBuilder<T> addAll(E ... elements) {
        this.elements.addAll(Arrays.asList(Assertions.notNull("elements", elements)));
        return this;
    }

    public CollectionBuilder<T> addAll(Collection<? extends T> elements) {
        this.elements.addAll(Assertions.notNull("elements", elements));
        return this;
    }

    public Collection<T> asCollection() {
        return this.asList();
    }

    public Collection<T> asMutableCollection() {
        return this.asMutableList();
    }

    public List<T> asArrayList() {
        return new ArrayList<T>(this.elements);
    }

    public List<T> asLinkedList() {
        return new LinkedList<T>(this.elements);
    }

    public List<T> asList() {
        return Collections.unmodifiableList(new ArrayList<T>(this.elements));
    }

    public List<T> asMutableList() {
        return this.asArrayList();
    }

    public Set<T> asHashSet() {
        return new HashSet<T>(this.elements);
    }

    public Set<T> asListOrderedSet() {
        return new LinkedHashSet<T>(this.elements);
    }

    public Set<T> asImmutableListOrderedSet() {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(this.elements));
    }

    public Set<T> asSet() {
        return Collections.unmodifiableSet(new HashSet<T>(this.elements));
    }

    public Set<T> asMutableSet() {
        return this.asHashSet();
    }

    public SortedSet<T> asTreeSet() {
        return new TreeSet<T>(this.elements);
    }

    public SortedSet<T> asSortedSet() {
        return Collections.unmodifiableSortedSet(new TreeSet<T>(this.elements));
    }

    public SortedSet<T> asMutableSortedSet() {
        return this.asTreeSet();
    }

    public EnclosedIterable<T> asEnclosedIterable() {
        return CollectionEnclosedIterable.copy(this.elements);
    }
}

