/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util.env;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.NavigationImpl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.WebTable;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sourceforge.jwebunit.WebTester;
import org.xml.sax.SAXException;

public class EnvironmentUtils
extends AbstractFuncTestUtil {
    private static final String INFO_OS = "Operating System";
    private static final String OS_WINDOWS = "WINDOWS";
    public static final float JDK_1_5_VERSION = 1.5f;
    private final Navigation navigation;

    public EnvironmentUtils(WebTester tester, JIRAEnvironmentData environmentData) {
        this(tester, environmentData, new NavigationImpl(tester, environmentData));
    }

    public EnvironmentUtils(WebTester tester, JIRAEnvironmentData environmentData, Navigation navigation) {
        super(tester, environmentData, 2);
        this.navigation = navigation;
    }

    public boolean isOnWindows() {
        return this.isOnOperatingSystem(OS_WINDOWS);
    }

    private boolean isOnOperatingSystem(String os) {
        this.navigation.login("admin", "admin");
        this.navigation.gotoAdminSection("system_info");
        try {
            WebTable systemInfoTable = this.tester.getDialog().getResponse().getTableWithID("system_info_table");
            for (int i = 0; i < systemInfoTable.getRowCount(); ++i) {
                String key = systemInfoTable.getCellAsText(i, 0);
                if (key == null || key.indexOf(INFO_OS) < 0) continue;
                String value = systemInfoTable.getCellAsText(i, 1);
                if (value == null) break;
                return value.toUpperCase().indexOf(os.toUpperCase()) >= 0;
            }
            throw new RuntimeException("System Info page does not contain 'Operating System' information!");
        }
        catch (SAXException e) {
            throw new RuntimeException("Error parsing the System Infor page", e);
        }
    }

    public float getJiraJavaVersion() {
        String JVM__HTML_TABLE_TD;
        this.navigation.gotoAdminSection("system_info");
        String responseText = this.tester.getDialog().getResponseText();
        int idx = responseText.indexOf("<b>Java Version</b>");
        if (idx != -1 && (idx = responseText.indexOf(JVM__HTML_TABLE_TD = "<td valign=\"top\" width=\"60%\">", idx)) != -1) {
            int lastDecimalIdx;
            int firstDecimalIdx;
            String jvmVersion;
            if ((jvmVersion = responseText.substring(idx += JVM__HTML_TABLE_TD.length(), responseText.indexOf("</td>", idx))).indexOf("_") != -1) {
                jvmVersion = jvmVersion.substring(0, jvmVersion.indexOf("_"));
            }
            if ((firstDecimalIdx = jvmVersion.indexOf(".")) != (lastDecimalIdx = jvmVersion.lastIndexOf("."))) {
                jvmVersion = jvmVersion.substring(0, lastDecimalIdx);
            }
            try {
                return Float.parseFloat(jvmVersion);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    public boolean isSunJVM() {
        String jvmVendor = this.getSystemInfoProperty("Java VM");
        return jvmVendor != null && jvmVendor.contains("HotSpot");
    }

    public boolean isJavaBeforeJdk15() {
        return this.getJiraJavaVersion() < 1.5f;
    }

    public static String getMavenAwareOutputDir() {
        File outputDir;
        File targetDir = new File("target");
        if (targetDir.exists() && targetDir.isDirectory() && targetDir.canWrite()) {
            outputDir = new File(targetDir, "test-reports");
        } else {
            try {
                File tmpFile = File.createTempFile("jirafunctests_", "dir");
                if (!tmpFile.delete()) {
                    throw new RuntimeException(String.format("Could not delete temp file '%s'", tmpFile.getAbsolutePath()));
                }
                outputDir = tmpFile;
            }
            catch (IOException e) {
                String tmpDirName = System.getProperty("java.io.tmpdir");
                String yymmdd = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
                outputDir = new File(tmpDirName + File.separator + "jirafunctests_" + yymmdd);
            }
        }
        if (!outputDir.exists() && !outputDir.mkdir()) {
            throw new RuntimeException(String.format("Could not create output directory '%s'", outputDir.getAbsolutePath()));
        }
        return outputDir.getAbsolutePath();
    }

    private boolean isAppServerEqualTo(String appserver) {
        String server = this.getSystemInfoProperty("Application Server Container");
        if (server == null) {
            server = this.getSystemInfoProperty("Application Server");
        }
        return server != null && server.toLowerCase().indexOf(appserver.toLowerCase()) >= 0;
    }

    public boolean isOracle() {
        return this.isDatabaseEqualTo("oracle");
    }

    private boolean isDatabaseEqualTo(String database) {
        String databaseType = this.getSystemInfoProperty("Database type");
        return databaseType != null && databaseType.toLowerCase().indexOf(database.toLowerCase()) >= 0;
    }

    public String getSystemInfoProperty(String propertyLabel) {
        this.navigation.gotoAdminSection("system_info");
        WebTable table = this.tester.getDialog().getWebTableBySummaryOrId("system_info_table");
        for (int i = 0; i < table.getRowCount(); ++i) {
            if (table.getTableCell(i, 0).asText().indexOf(propertyLabel) < 0) continue;
            return table.getTableCell(i, 1).asText();
        }
        return null;
    }
}

