/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;

public class AsynchronousTasks
extends AbstractFuncTestUtil {
    public AsynchronousTasks(WebTester tester, JIRAEnvironmentData environmentData, int logIndentLevel) {
        super(tester, environmentData, logIndentLevel);
    }

    public void waitForSuccessfulCompletion(long sleepTime, int retryCount, String operationName) {
        for (int i = 0; i < retryCount; ++i) {
            if (this.tester.getDialog().hasSubmitButton("Refresh")) {
                this.tester.submit("Refresh");
            } else {
                if (this.tester.getDialog().hasSubmitButton("Acknowledge")) {
                    this.tester.submit("Acknowledge");
                    return;
                }
                Assert.fail((String)"Unexpected button on progress screen.");
            }
            try {
                Thread.sleep(sleepTime);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        Assert.fail((String)(operationName + " operation did not complete after " + (double)(sleepTime * (long)retryCount) / 1000.0 + " sec."));
    }
}

