/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.sharing;

import com.atlassian.jira.functest.framework.sharing.GlobalTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.GroupTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.ProjectTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.SimpleTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermission;
import com.atlassian.jira.functest.framework.util.json.TestJSONArray;
import com.atlassian.jira.functest.framework.util.json.TestJSONException;
import com.atlassian.jira.functest.framework.util.json.TestJSONObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class TestSharingPermissionUtils {
    public static Set<TestSharingPermission> parsePermissions(String json) throws TestJSONException {
        if (StringUtils.isBlank((String)json)) {
            return null;
        }
        TestJSONArray array = new TestJSONArray(json);
        HashSet<GlobalTestSharingPermission> returnSet = new HashSet<GlobalTestSharingPermission>();
        for (int i = 0; i < array.length(); ++i) {
            TestJSONObject object = array.getJSONObject(i);
            TestSharingPermission permission = GlobalTestSharingPermission.parseJson(object);
            if (permission == null) {
                permission = GroupTestSharingPermission.parseJson(object);
            }
            if (permission == null) {
                permission = ProjectTestSharingPermission.parseJson(object);
            }
            if (permission == null) {
                permission = SimpleTestSharingPermission.parseJson(object);
            }
            if (permission == null) {
                throw new TestJSONException("JSON does not contain valid share permissions.");
            }
            returnSet.add((GlobalTestSharingPermission)permission);
        }
        return Collections.unmodifiableSet(returnSet);
    }

    public static String createJsonString(Set<? extends TestSharingPermission> permissions) {
        TestJSONArray array = new TestJSONArray();
        for (TestSharingPermission testSharingPermission : permissions) {
            array.put(testSharingPermission.toJson());
        }
        return array.toString();
    }

    public static Set<TestSharingPermission> createPublicPermissions() {
        return Collections.singleton(GlobalTestSharingPermission.GLOBAL_PERMISSION);
    }

    public static Set<TestSharingPermission> createGroupPermissions(String group) {
        return Collections.singleton(new GroupTestSharingPermission(group));
    }

    public static Set<TestSharingPermission> createProjectPermissions(long projId, long roleId, String projectName, String roleName) {
        return Collections.singleton(new ProjectTestSharingPermission(projId, roleId, projectName, roleName));
    }

    public static Set<TestSharingPermission> createPrivatePermissions() {
        return Collections.emptySet();
    }
}

