/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.sharing;

import com.atlassian.jira.functest.framework.sharing.SimpleTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermission;
import com.atlassian.jira.functest.framework.util.json.TestJSONException;
import com.atlassian.jira.functest.framework.util.json.TestJSONObject;
import org.apache.commons.lang.StringUtils;

public class ProjectTestSharingPermission
implements TestSharingPermission {
    public static final String TYPE = "project";
    private final long projectId;
    private final long roleId;
    private final String projectName;
    private final String roleName;

    public ProjectTestSharingPermission(SimpleTestSharingPermission permission) {
        if (!TYPE.equals(permission.getType())) {
            throw new IllegalArgumentException();
        }
        this.projectId = permission.getPerm1() == null ? Long.parseLong(permission.getPerm1()) : Long.MIN_VALUE;
        this.roleId = permission.getPerm2() == null ? Long.parseLong(permission.getPerm1()) : Long.MIN_VALUE;
        this.projectName = null;
        this.roleName = null;
    }

    public ProjectTestSharingPermission(long projectId) {
        this(projectId, -1L);
    }

    public ProjectTestSharingPermission(long projectId, String projectName) {
        this(projectId, -1L, projectName, null);
    }

    public ProjectTestSharingPermission(long projectId, long roleId) {
        this(projectId, roleId, null, null);
    }

    public ProjectTestSharingPermission(long projectId, long roleId, String projectName, String roleName) {
        this.roleId = roleId < 0L ? Long.MIN_VALUE : roleId;
        this.projectId = projectId < 0L ? Long.MIN_VALUE : projectId;
        this.projectName = projectName;
        this.roleName = roleName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public boolean isProjectIdSet() {
        return this.projectId >= 0L;
    }

    public boolean isRoleIdSet() {
        return this.roleId >= 0L;
    }

    public long getProjectId() {
        return this.projectId;
    }

    public long getRoleId() {
        return this.roleId;
    }

    public String getRole() {
        return this.isRoleIdSet() ? String.valueOf(this.roleId) : "<Not Set>";
    }

    private String getProject() {
        return this.isProjectIdSet() ? String.valueOf(this.projectId) : "<Not Set>";
    }

    public String toString() {
        return "Project Share: [Project: " + this.getProject() + ", Role: " + this.getRole() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectTestSharingPermission that = (ProjectTestSharingPermission)o;
        if (this.projectId != that.projectId) {
            return false;
        }
        return this.roleId == that.roleId;
    }

    public int hashCode() {
        int result = (int)(this.projectId ^ this.projectId >>> 32);
        result = 31 * result + (int)(this.roleId ^ this.roleId >>> 32);
        return result;
    }

    @Override
    public TestJSONObject toJson() {
        try {
            TestJSONObject object = new TestJSONObject();
            object.put("type", TYPE);
            if (this.isProjectIdSet()) {
                object.put("param1", String.valueOf(this.projectId));
            }
            if (this.isRoleIdSet()) {
                object.put("param2", String.valueOf(this.roleId));
            }
            return object;
        }
        catch (TestJSONException e) {
            throw new RuntimeException(e);
        }
    }

    public static ProjectTestSharingPermission parseJson(TestJSONObject json) throws TestJSONException {
        String type;
        if (json.has("type") && TYPE.equals(type = (String)json.get("type"))) {
            try {
                long projectId = -1L;
                if (json.has("param1")) {
                    projectId = Long.parseLong((String)json.get("param1"));
                }
                long roleId = -1L;
                if (json.has("param2")) {
                    roleId = Long.parseLong((String)json.get("param2"));
                }
                return new ProjectTestSharingPermission(projectId, roleId);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String toDisplayFormat() {
        StringBuffer sb = new StringBuffer("Project: ").append(this.getProjectName());
        if (!StringUtils.isEmpty((String)this.getRoleName())) {
            sb.append(" Role: ").append(this.getRoleName());
        }
        return sb.toString();
    }
}

