/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigator;

import com.atlassian.jira.functest.framework.navigator.NavigatorCondition;
import com.meterware.httpunit.WebForm;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;

public class QuerySearchCondition
implements NavigatorCondition {
    private static final String QUERY_ELEMENT = "query";
    private String queryString = "";
    private Set<QueryField> fields = new HashSet<QueryField>();

    public QuerySearchCondition() {
        this("");
    }

    public QuerySearchCondition(String queryString) {
        this(queryString, Collections.emptySet());
    }

    public QuerySearchCondition(String queryString, Collection<? extends QueryField> fields) {
        this.setQueryString(queryString);
        this.setFields(fields);
    }

    public QuerySearchCondition(QuerySearchCondition condition) {
        this(condition.queryString, condition.fields);
    }

    public void setQueryString(String queryString) {
        this.queryString = StringUtils.isBlank((String)queryString) ? "" : queryString;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setFields(Collection<? extends QueryField> fields) {
        this.fields = fields == null ? new HashSet<QueryField>() : new HashSet<QueryField>(fields);
    }

    public boolean addField(QueryField field) {
        return field != null && this.fields.add(field);
    }

    public boolean removeField(QueryField field) {
        return field != null && this.fields.remove(field);
    }

    public void clearFields() {
        this.fields.clear();
    }

    @Override
    public void setForm(WebTester tester) {
        if (!StringUtils.isBlank((String)this.queryString) && !this.fields.isEmpty()) {
            tester.setFormElement(QUERY_ELEMENT, this.queryString);
            for (QueryField queryField : QueryField.DEFAULT_FIELDS) {
                tester.uncheckCheckbox(queryField.getField());
            }
            for (QueryField queryField : this.fields) {
                tester.setFormElement(queryField.getField(), "true");
            }
        }
    }

    @Override
    public void parseCondition(WebTester tester) {
        WebForm form = tester.getDialog().getForm();
        this.setQueryString(form.getParameterValue(QUERY_ELEMENT));
        this.clearFields();
        for (QueryField field : QueryField.DEFAULT_FIELDS) {
            String parameterValue = form.getParameterValue(field.getField());
            if (!StringUtils.isNotBlank((String)parameterValue) || !Boolean.valueOf(parameterValue).booleanValue()) continue;
            this.addField(field);
        }
    }

    @Override
    public void assertSettings(WebTester tester) {
        tester.assertFormElementEquals(QUERY_ELEMENT, this.queryString);
        for (QueryField field : this.fields) {
            tester.assertFormElementPresent(field.getField());
            Assert.assertTrue((String)("Query for field '" + field.getField() + "' should be set."), (boolean)this.parseBoolean(tester.getDialog().getFormParameterValue(field.getField())));
        }
        HashSet<QueryField> disabledFields = new HashSet<QueryField>(QueryField.DEFAULT_FIELDS);
        disabledFields.removeAll(this.fields);
        for (QueryField field : disabledFields) {
            tester.assertFormElementPresent(field.getField());
            Assert.assertFalse((String)("Query for field '" + field.getField() + "' should not be set."), (boolean)this.parseBoolean(tester.getDialog().getFormParameterValue(field.getField())));
        }
    }

    @Override
    public NavigatorCondition copyCondition() {
        return new QuerySearchCondition(this);
    }

    @Override
    public NavigatorCondition copyConditionForParse() {
        return new QuerySearchCondition();
    }

    public String toString() {
        return "Query Search: '" + this.queryString + "' on fields: " + this.fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuerySearchCondition that = (QuerySearchCondition)o;
        if (this.fields != null ? !((Object)this.fields).equals(that.fields) : that.fields != null) {
            return false;
        }
        return !(this.queryString != null ? !this.queryString.equals(that.queryString) : that.queryString != null);
    }

    public int hashCode() {
        int result = this.queryString != null ? this.queryString.hashCode() : 0;
        result = 31 * result + (this.fields != null ? ((Object)this.fields).hashCode() : 0);
        return result;
    }

    private boolean parseBoolean(String bool) {
        return !StringUtils.isBlank((String)bool) && Boolean.valueOf(bool) != false;
    }

    public static class QueryField {
        public static final QueryField SUMMARY = new QueryField("summary");
        public static final QueryField DESCRIPTION = new QueryField("description");
        public static final QueryField COMMENTS = new QueryField("body");
        public static final QueryField ENVIRONMENT = new QueryField("environment");
        public static final Set<QueryField> DEFAULT_FIELDS;
        private final String field;

        private QueryField(String field) {
            this.field = field;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.getField();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryField that = (QueryField)o;
            return this.field.equals(that.field);
        }

        public int hashCode() {
            return this.field.hashCode();
        }

        static {
            HashSet<QueryField> fields = new HashSet<QueryField>();
            fields.add(COMMENTS);
            fields.add(DESCRIPTION);
            fields.add(ENVIRONMENT);
            fields.add(SUMMARY);
            DEFAULT_FIELDS = Collections.unmodifiableSet(fields);
        }
    }
}

