/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigation.issue;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.log.FuncTestLogger;
import com.atlassian.jira.functest.framework.navigation.issue.ImageAttachmentsGallery;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jwebunit.WebTester;
import org.w3c.dom.Node;

public class DefaultImageAttachmentsGallery
implements ImageAttachmentsGallery {
    private WebTester tester;
    private static final String ISSUE_KEY_ID = "key-val";
    private FuncTestLogger logger;

    public DefaultImageAttachmentsGallery(WebTester tester, FuncTestLogger logger) {
        this.tester = tester;
        this.logger = logger;
    }

    @Override
    public List<ImageAttachmentsGallery.ImageAttachmentItem> get() {
        this.tester.assertElementPresent(ISSUE_KEY_ID);
        IdLocator issueKeyLocator = new IdLocator(this.tester, ISSUE_KEY_ID);
        this.logger.log("Beginning to retrieve image attachments for the issue: " + issueKeyLocator.getText());
        ArrayList<ImageAttachmentsGallery.ImageAttachmentItem> attachments = new ArrayList<ImageAttachmentsGallery.ImageAttachmentItem>();
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//*[@id='attachment_thumbnails']/li[contains(concat(' ', normalize-space(@class), ' '), ' attachment-content ')]");
        for (int i = 0; i < xPathLocator.getNodes().length; ++i) {
            Node node = xPathLocator.getNodes()[i];
            XPathLocator nameLocator = new XPathLocator(node, "./dl/dt/a[@class='attachment-title']");
            XPathLocator sizeLocator = new XPathLocator(node, "./dl/dd[@class='attachment-size']");
            attachments.add(new ImageAttachmentsGallery.ImageAttachmentItem(nameLocator.getText(), sizeLocator.getText()));
        }
        this.logger.log("Finished retrieving image attachments for the issue: " + issueKeyLocator.getText());
        return attachments;
    }
}

