/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigation.issue;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.log.FuncTestLogger;
import com.atlassian.jira.functest.framework.navigation.issue.AttachmentManagement;
import com.atlassian.jira.functest.framework.navigation.issue.AttachmentsBlock;
import com.atlassian.jira.functest.framework.navigation.issue.FileAttachmentsList;
import com.atlassian.jira.functest.framework.navigation.issue.ImageAttachmentsGallery;
import net.sourceforge.jwebunit.WebTester;

public class DefaultAttachmentsBlock
implements AttachmentsBlock {
    private WebTester tester;
    private static final String ISSUE_KEY_ID = "key-val";
    private FuncTestLogger logger;
    private AttachmentManagement attachmentManagement;
    private static final String MANAGE_ATTACHMENTS_LINK_ID = "manage-attachment-link";
    private ImageAttachmentsGallery imageAttachmentsGallery;
    private FileAttachmentsList fileAttachmentsList;

    public DefaultAttachmentsBlock(WebTester tester, FuncTestLogger logger, FileAttachmentsList fileAttachmentsList, ImageAttachmentsGallery imageAttachmentsGallery, AttachmentManagement attachmentManagement) {
        this.tester = tester;
        this.logger = logger;
        this.attachmentManagement = attachmentManagement;
        this.imageAttachmentsGallery = imageAttachmentsGallery;
        this.fileAttachmentsList = fileAttachmentsList;
    }

    @Override
    public void sort(AttachmentsBlock.Sort.Key key, AttachmentsBlock.Sort.Direction direction) {
        this.tester.assertElementPresent(ISSUE_KEY_ID);
        IdLocator issueKeyLocator = new IdLocator(this.tester, ISSUE_KEY_ID);
        this.logger.log("Beginning to sort attachments by " + (Object)((Object)key) + " in " + (Object)((Object)direction) + " order, " + "for the issue: " + issueKeyLocator.getText());
        this.tester.clickLink(key.getLinkId());
        this.tester.clickLink(direction.getLinkId());
        this.logger.log("Finished sorting attachments by " + (Object)((Object)key) + " in " + (Object)((Object)direction) + " order, " + "for the issue: " + issueKeyLocator.getText());
    }

    @Override
    public AttachmentManagement manage() {
        this.tester.assertElementPresent(ISSUE_KEY_ID);
        this.tester.clickLink(MANAGE_ATTACHMENTS_LINK_ID);
        return this.attachmentManagement;
    }

    @Override
    public ImageAttachmentsGallery gallery() {
        return this.imageAttachmentsGallery;
    }

    @Override
    public FileAttachmentsList list() {
        return this.fileAttachmentsList;
    }
}

