/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigation;

import com.atlassian.jira.functest.framework.AbstractNavigationUtil;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigation;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigationImpl;
import com.atlassian.jira.functest.framework.navigation.issue.AttachmentsBlock;
import com.atlassian.jira.functest.framework.navigation.issue.DefaultAttachmentManagement;
import com.atlassian.jira.functest.framework.navigation.issue.DefaultAttachmentsBlock;
import com.atlassian.jira.functest.framework.navigation.issue.DefaultFileAttachmentsList;
import com.atlassian.jira.functest.framework.navigation.issue.DefaultImageAttachmentsGallery;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.io.IOException;
import java.util.Map;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;
import org.w3c.dom.Node;

public class IssueNavigationImpl
extends AbstractNavigationUtil
implements IssueNavigation {
    private static final String WORKFLOW_ACTION_RESOLVE_ISSUE = "action_id_5";
    private static final String WORKFLOW_ACTION_REOPEN_ISSUE = "action_id_3";
    private static final String WORKFLOW_ACTION_CLOSE_ISSUE = "action_id_2";
    private static final String ISSUE_PERMISSION_XPATH = "//div[contains(@class, 'jira-error')][contains(.,'You have successfully created the issue ') and contains(.,' however you do not have the permission to view the created issue.')]";

    public IssueNavigationImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData);
    }

    @Override
    public void viewIssue(String issueKey) {
        this.tester.gotoPage("/browse/" + issueKey);
    }

    @Override
    public void viewPrintable(String issueKey) {
        this.tester.gotoPage("/si/jira.issueviews:issue-html/" + issueKey + "/" + issueKey + ".html");
    }

    @Override
    public void gotoEditIssue(String issueKey) {
        this.tester.gotoPage("/browse/" + issueKey);
        this.tester.clickLink("editIssue");
    }

    @Override
    public void deleteIssue(String issueKey) {
        this.viewIssue(issueKey);
        this.tester.clickLink("delete-issue");
        this.tester.submit("Delete");
    }

    @Override
    public void gotoIssue(String issueKey) {
        if (issueKey == null) {
            throw new IllegalArgumentException("IssueKey should not be null.");
        }
        this.tester.beginAt("/browse/" + issueKey);
    }

    @Override
    public void gotoIssueChangeHistory(String issueKey) {
        if (issueKey == null) {
            throw new IllegalArgumentException("IssueKey should not be null.");
        }
        this.tester.beginAt("/browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:changehistory-tabpanel");
    }

    @Override
    public void gotoIssueWorkLog(String issueKey) {
        this.tester.beginAt("/browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:worklog-tabpanel");
    }

    @Override
    public String createIssue(String projectName, String issueType, String summary) {
        this.goToCreateIssueForm(projectName, issueType);
        return this.createIssueDetails(summary, null);
    }

    @Override
    public String createIssue(String projectName, String issueType, String summary, Map<String, String[]> params) {
        this.goToCreateIssueForm(projectName, issueType);
        return this.createIssueDetails(summary, null, params);
    }

    @Override
    public String createSubTask(String parentIssueKey, String subTaskType, String subTaskSummary, String subTaskDescription) {
        this.createSubTaskStep1(parentIssueKey, subTaskType);
        return this.createIssueDetails(subTaskSummary, subTaskDescription);
    }

    private String createIssueDetails(String summary, String description) {
        String issueKey = null;
        this.tester.setFormElement("summary", summary);
        if (description != null) {
            this.tester.setFormElement("description", description);
        }
        this.tester.submit("Create");
        IdLocator idLocator = new IdLocator(this.tester, "key-val");
        issueKey = this.getIssueKey(idLocator);
        if (issueKey == null) {
            XPathLocator xPathLocator = new XPathLocator(this.tester, ISSUE_PERMISSION_XPATH);
            issueKey = this.getNoPermissionError(xPathLocator);
        }
        return issueKey;
    }

    private String getIssueKey(Locator keyLocator) {
        String issueKey = null;
        Node[] tds = keyLocator.getNodes();
        if (tds.length > 0) {
            issueKey = keyLocator.getRawText();
            Assert.assertNotNull((Object)issueKey);
        }
        return issueKey;
    }

    private String getNoPermissionError(Locator xPathLocator) {
        Node[] tds = xPathLocator.getNodes();
        if (tds.length >= 1) {
            String fullMessage = xPathLocator.getText(tds[0]);
            Assert.assertNotNull((Object)fullMessage);
            return fullMessage.substring(fullMessage.indexOf(40) + 1, fullMessage.indexOf(41));
        }
        Assert.fail((String)"Could not find issue key for newly created issue");
        return null;
    }

    private String createIssueDetails(String summary, String description, Map<String, String[]> params) {
        if (params == null) {
            return this.createIssueDetails(summary, description);
        }
        FormParameterUtil formParamHelper = new FormParameterUtil(this.tester, "issue-create", "Create");
        formParamHelper.setFormElement("summary", summary);
        if (description != null) {
            formParamHelper.setFormElement("description", description);
        }
        formParamHelper.setParameters(params);
        Node createdIssueNode = formParamHelper.submitForm();
        XPathLocator issueLocator = new XPathLocator(createdIssueNode, "//*[@id='key-val']");
        String issueKey = this.getIssueKey(issueLocator);
        if (issueKey == null) {
            XPathLocator xPathLocator = new XPathLocator(createdIssueNode, ISSUE_PERMISSION_XPATH);
            issueKey = this.getNoPermissionError(xPathLocator);
        }
        return issueKey;
    }

    @Override
    public void goToCreateIssueForm(String projectName, String issueType) {
        this.tester.clickLink("create_link");
        if (this.tester.getDialog().getElement("issuetype") != null) {
            if (projectName != null) {
                this.tester.selectOption("pid", projectName);
            }
            if (issueType != null) {
                this.tester.selectOption("issuetype", issueType);
            }
            this.tester.setWorkingForm("issue-create");
            this.tester.submit();
        }
        this.tester.assertTextPresent("CreateIssueDetails.jspa");
        if (issueType != null) {
            this.tester.assertTextPresent(issueType);
        }
    }

    private void createSubTaskStep1(String issueKey, String task_type) {
        this.getAdministration().subtasks().enable();
        this.viewIssue(issueKey);
        this.tester.clickLink("create-subtask");
        this.tester.assertTextPresent("Create Sub-Task");
        if (this.tester.getDialog().getElement("issuetype") == null) {
            this.log("Bypassing step 1 of sub task creation");
        } else {
            this.tester.setWorkingForm("subtask-create-start");
            this.tester.selectOption("issuetype", task_type);
            this.tester.submit("Create");
        }
        this.tester.assertElementPresent("subtask-create-details");
    }

    @Override
    public void setPriority(String issueKey, String priority) {
        this.viewIssue(issueKey);
        this.tester.clickLink("editIssue");
        this.tester.setWorkingForm("issue-edit");
        this.tester.selectOption("priority", priority);
        this.tester.submit("Update");
    }

    @Override
    public void setEnvironment(String issueKey, String environment) {
        this.setSingleIssueField(issueKey, "environment", environment);
    }

    @Override
    public void setDescription(String issueKey, String description) {
        this.setSingleIssueField(issueKey, "description", description);
    }

    @Override
    public void setFreeTextCustomField(String issueKey, String customFieldId, String text) {
        this.setSingleIssueField(issueKey, customFieldId, text);
    }

    private void setSingleIssueField(String issueKey, String formElementName, String value) {
        this.viewIssue(issueKey);
        this.tester.clickLink("editIssue");
        this.tester.setWorkingForm("issue-edit");
        this.tester.setFormElement(formElementName, value);
        this.tester.submit("Update");
    }

    @Override
    public void assignIssue(String issueKey, String comment, String userFullName) {
        this.viewIssue(issueKey);
        this.tester.clickLink("assign-issue");
        this.tester.selectOption("assignee", userFullName);
        if (comment != null) {
            this.tester.setFormElement("comment", comment);
        }
        this.tester.submit("Assign");
        this.tester.assertTextPresent(userFullName);
        if (comment != null) {
            this.tester.assertTextPresent(comment);
        }
    }

    @Override
    public void assignIssue(String issueKey, String userFullName, String comment, String commentLevel) {
        this.viewIssue(issueKey);
        this.tester.clickLink("assign-issue");
        this.tester.setWorkingForm("assign-issue");
        this.tester.selectOption("assignee", userFullName);
        if (comment != null) {
            this.tester.setFormElement("comment", comment);
            if (commentLevel != null) {
                this.tester.selectOption("commentLevel", commentLevel);
            }
        }
        this.tester.submit("Assign");
    }

    @Override
    public void unassignIssue(String issueKey, String comment) {
        this.assignIssue(issueKey, comment, "Unassigned");
    }

    @Override
    public void unassignIssue(String issueKey, String comment, String commentLevel) {
        this.assignIssue(issueKey, "Unassigned", comment, commentLevel);
    }

    @Override
    public void resolveIssue(String issueKey, String resolution, String comment) {
        this.viewIssue(issueKey);
        this.tester.clickLink(WORKFLOW_ACTION_RESOLVE_ISSUE);
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.selectOption("resolution", resolution);
        this.tester.setFormElement("comment", comment);
        this.tester.submit("Transition");
    }

    @Override
    public void closeIssue(String issueKey, String resolution, String comment) {
        this.viewIssue(issueKey);
        this.tester.clickLink(WORKFLOW_ACTION_CLOSE_ISSUE);
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.selectOption("resolution", resolution);
        this.tester.setFormElement("comment", comment);
        this.tester.submit("Transition");
    }

    @Override
    public AttachmentsBlock attachments(String issueKey) {
        this.viewIssue(issueKey);
        return new DefaultAttachmentsBlock(this.tester, this.logger, new DefaultFileAttachmentsList(this.tester, this.logger), new DefaultImageAttachmentsGallery(this.tester, this.logger), new DefaultAttachmentManagement(this.tester, this.logger));
    }

    @Override
    public void resolveIssue(String issueKey, String resolution, String comment, String originalEstimate, String remainingEstimate) {
        String originalEstimateFieldId = this.getOriginalEstimateFieldId();
        String remainingEstimateFieldId = this.getRemainingEstimateFieldId();
        this.viewIssue(issueKey);
        this.tester.clickLink(WORKFLOW_ACTION_RESOLVE_ISSUE);
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.selectOption("resolution", resolution);
        this.tester.setFormElement("comment", comment);
        if (originalEstimate != null) {
            this.tester.setFormElement(originalEstimateFieldId, originalEstimate);
        }
        if (remainingEstimate != null) {
            this.tester.setFormElement(remainingEstimateFieldId, remainingEstimate);
        }
        this.tester.submit("Transition");
    }

    @Override
    public void logWork(String issueKey, String timeLogged) {
        this.viewIssue(issueKey);
        this.tester.clickLink("log-work");
        this.tester.setFormElement("timeLogged", timeLogged);
        this.tester.submit("Log");
    }

    @Override
    public void logWork(String issueKey, String timeLogged, String newEstimate) {
        this.gotoIssue(issueKey);
        this.tester.clickLink("log-work");
        this.tester.setFormElement("timeLogged", timeLogged);
        this.tester.checkCheckbox("adjustEstimate", "new");
        this.tester.setFormElement("newEstimate", newEstimate);
        this.tester.submit("Log");
    }

    @Override
    public void reopenIssue(String issueKey) {
        this.viewIssue(issueKey);
        this.tester.clickLink(WORKFLOW_ACTION_REOPEN_ISSUE);
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
    }

    @Override
    public void unwatchIssue(String issueKey) {
        this.viewIssue(issueKey);
        if (this.tester.getDialog().getResponseText().contains("icon-watch-on")) {
            this.tester.clickLink("toggle-watch-issue");
        }
    }

    @Override
    public void watchIssue(String issueKey) {
        this.viewIssue(issueKey);
        if (this.tester.getDialog().getResponseText().contains("icon-watch-off")) {
            this.tester.clickLink("toggle-watch-issue");
        }
    }

    @Override
    public void unvoteIssue(String issueKey) {
        this.viewIssue(issueKey);
        if (!this.tester.getDialog().getResponseText().contains("icon-vote-on")) {
            throw new RuntimeException("Could not unvote on issue");
        }
        this.tester.clickLink("toggle-vote-issue");
    }

    @Override
    public void voteIssue(String issueKey) {
        this.viewIssue(issueKey);
        if (!this.tester.getDialog().getResponseText().contains("icon-vote-off")) {
            throw new RuntimeException("Could no vote on issue");
        }
        this.tester.clickLink("toggle-vote-issue");
    }

    @Override
    public void addComment(String issueKey, String comment) {
        this.addComment(issueKey, comment, null);
    }

    @Override
    public void addComment(String issueKey, String comment, String roleLevel) {
        this.viewIssue(issueKey);
        this.tester.clickLink("comment-issue");
        this.tester.setFormElement("comment", comment);
        if (roleLevel != null) {
            this.tester.selectOption("commentLevel", roleLevel);
        }
        this.tester.submit();
    }

    @Override
    public void setFixVersions(String issueKey, String ... fixVersions) {
        this.setIssueMultiSelectField(issueKey, "fixVersions", fixVersions);
    }

    @Override
    public void setAffectsVersions(String issueKey, String ... affectsVersions) {
        this.setIssueMultiSelectField(issueKey, "versions", affectsVersions);
    }

    @Override
    public void setComponents(String issueKey, String ... components) {
        this.setIssueMultiSelectField(issueKey, "components", components);
    }

    @Override
    public void setDueDate(String issueKey, String dateString) {
        this.setSingleIssueField(issueKey, "duedate", dateString);
    }

    @Override
    public void setIssueMultiSelectField(String issueKey, String selectName, String ... options) {
        this.viewIssue(issueKey);
        this.tester.clickLink("editIssue");
        this.tester.setWorkingForm("issue-edit");
        for (String option : options) {
            String value = this.tester.getDialog().getValueForOption(selectName, option);
            this.tester.checkCheckbox(selectName, value);
        }
        this.tester.submit("Update");
    }

    @Override
    public void setEstimates(String issueKey, String originalEstimate, String remainingEstimate) {
        String originalEstimateFieldId = this.getOriginalEstimateFieldId();
        String remainingEstimateFieldId = this.getRemainingEstimateFieldId();
        this.viewIssue(issueKey);
        this.tester.clickLink("editIssue");
        this.tester.assertFormElementPresent(originalEstimateFieldId);
        this.tester.setFormElement(originalEstimateFieldId, originalEstimate);
        this.tester.assertFormElementPresent(remainingEstimateFieldId);
        this.tester.setFormElement(remainingEstimateFieldId, remainingEstimate);
        this.tester.submit();
    }

    @Override
    public void setOriginalEstimate(String issueKey, String newValue) {
        String estimateFieldId = this.getOriginalEstimateFieldId();
        this.viewIssue(issueKey);
        this.tester.clickLink("editIssue");
        this.tester.assertFormElementPresent(estimateFieldId);
        this.tester.setFormElement(estimateFieldId, newValue);
        this.tester.submit();
    }

    @Override
    public void setRemainingEstimate(String issueKey, String newValue) {
        String remainingEstimateFieldId = this.getRemainingEstimateFieldId();
        this.viewIssue(issueKey);
        this.tester.clickLink("editIssue");
        this.tester.assertFormElementPresent(remainingEstimateFieldId);
        this.tester.setFormElement(remainingEstimateFieldId, newValue);
        this.tester.submit();
    }

    @Override
    public IssueNavigation editLabels(int issueId) {
        this.tester.clickLink("edit-labels-" + issueId + "-labels");
        return this;
    }

    @Override
    public IssueNavigation editCustomLabels(int issueId, int customFieldId) {
        this.tester.clickLink("edit-labels-" + issueId + "-customfield_" + customFieldId);
        return this;
    }

    @Override
    public IssueNavigatorNavigation returnToSearch() {
        this.tester.clickLink("return-to-search");
        return new IssueNavigatorNavigationImpl(this.tester, this.getEnvironmentData());
    }

    @Override
    public String getId(String issueKey) {
        this.gotoIssue(issueKey);
        String issueId = "";
        try {
            String text = this.tester.getDialog().getResponse().getText();
            String paramName = "ViewVoters!default.jspa?id=";
            int issueIdLocation = text.indexOf(paramName) + paramName.length();
            issueId = text.substring(issueIdLocation, issueIdLocation + 5);
        }
        catch (IOException e) {
            this.log("Unable to retrieve issue id" + e.getMessage());
            Assert.fail((String)String.format("No issue id could be found using issue key:'%s'. IOException caught: '%s'", issueKey, e.getMessage()));
        }
        return issueId;
    }

    private String getOriginalEstimateFieldId() {
        if (this.getAdministration().timeTracking().isIn(TimeTracking.Mode.LEGACY)) {
            return "timetracking";
        }
        return "timetracking_originalestimate";
    }

    private String getRemainingEstimateFieldId() {
        if (this.getAdministration().timeTracking().isIn(TimeTracking.Mode.LEGACY)) {
            return "timetracking";
        }
        return "timetracking_remainingestimate";
    }

    protected Administration getAdministration() {
        return this.getFuncTestHelperFactory().getAdministration();
    }
}

