/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.locator;

import com.atlassian.jira.functest.framework.locator.AbstractLocator;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.util.dom.DomKit;
import java.util.List;
import net.sourceforge.jwebunit.WebTester;
import org.jaxen.XPath;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPathLocator
extends AbstractLocator
implements Locator {
    private final XPath xpath;
    private final String xPathExpressionStr;
    private Node startNode;
    private final boolean constructedViaTester;

    public XPathLocator(WebTester tester, String xPathExpressionStr) {
        super(tester);
        if (tester == null) {
            throw new IllegalArgumentException("The WebTester must not be null");
        }
        if (xPathExpressionStr == null) {
            throw new IllegalArgumentException("The xPathExpressionStr must not be null");
        }
        this.constructedViaTester = true;
        this.startNode = null;
        this.xPathExpressionStr = xPathExpressionStr;
        try {
            this.xpath = this.getXpathExpression(xPathExpressionStr);
        }
        catch (Exception e) {
            throw new RuntimeException("The XPath provided could not be complied : '" + xPathExpressionStr + "'", e);
        }
        this.checkStateOrInit();
    }

    public XPathLocator(Node startNode, String xPathExpressionStr) {
        this.constructedViaTester = false;
        if (startNode == null) {
            throw new IllegalArgumentException("You must provide a startNode");
        }
        if (xPathExpressionStr == null) {
            throw new IllegalArgumentException("The xPathExpressionStr must not be null");
        }
        this.startNode = startNode;
        this.xPathExpressionStr = xPathExpressionStr;
        try {
            this.xpath = this.getXpathExpression(xPathExpressionStr);
        }
        catch (Exception e) {
            throw new RuntimeException("The XPath provided could not be complied : '" + xPathExpressionStr + "'", e);
        }
        this.checkStateOrInit();
    }

    private synchronized void checkStateOrInit() {
        if (this.nodes == null) {
            if (this.constructedViaTester) {
                this.originalWebResponse = this.getWebResponse(this.tester);
                Document document = this.getDOM(this.tester);
                this.startNode = document;
            }
            try {
                this.nodes = new Node[0];
                List nodes = this.xpath.selectNodes((Object)this.startNode);
                if (nodes != null) {
                    this.nodes = this.makeArr(nodes);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Node[] getNodes() {
        this.checkStateOrInit();
        return this.nodes;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("XPathLocator : ");
        sb.append(this.xPathExpressionStr);
        return this.toStringImpl(sb.toString());
    }

    private Node[] makeArr(List nodeList) {
        Node[] nodes = new Node[nodeList.size()];
        for (int i = 0; i < nodeList.size(); ++i) {
            Node node = (Node)nodeList.get(i);
            nodes[i] = DomKit.betterNode(node);
        }
        return nodes;
    }

    private XPath getXpathExpression(String xpathExpressionStr) throws Exception {
        return new DOMXPath(xpathExpressionStr);
    }
}

