/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import net.sourceforge.jwebunit.WebTester;

public class UserAssertions
extends AbstractFuncTestUtil {
    private final Assertions assertions;

    public UserAssertions(WebTester tester, JIRAEnvironmentData environmentData, Assertions assertions) {
        super(tester, environmentData, 2);
        this.assertions = assertions;
    }

    public boolean userExists(String username) {
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=" + username);
        this.navigation().checkWebSudoWithLastPassword();
        return !this.tester.getDialog().getResponseText().contains("This user does not exist");
    }

    public void assertUserExists(String username) {
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=" + username);
        this.navigation().checkWebSudoWithLastPassword();
        this.tester.assertTextNotPresent("This user does not exist");
    }

    public void assertUserDoesNotExist(String username) {
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=" + username);
        this.navigation().checkWebSudoWithLastPassword();
        this.tester.assertTextPresent("This user does not exist");
    }

    public void assertUserDetails(String username, String displayName, String emailAddress, String directoryName) {
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=" + username);
        this.navigation().checkWebSudoWithLastPassword();
        this.tester.assertTextNotPresent("This user does not exist");
        this.assertions.assertNodeByIdEquals("username", username);
        this.assertions.assertNodeByIdEquals("displayName", displayName);
        this.tester.assertTextPresent("href=\"mailto:" + emailAddress + '\"');
        this.assertions.assertNodeByIdEquals("directory", directoryName);
    }

    public void assertGroupExists(String name) {
        this.tester.gotoPage("/secure/admin/user/ViewGroup.jspa?name=" + name);
        this.navigation().checkWebSudoWithLastPassword();
        this.tester.assertTextNotPresent("The group does not exist");
    }

    public void assertGroupDoesNotExist(String name) {
        this.tester.gotoPage("/secure/admin/user/ViewGroup.jspa?name=" + name);
        this.navigation().checkWebSudoWithLastPassword();
        this.tester.assertTextPresent("The group does not exist");
    }

    public void assertUserBelongsToGroup(String username, String groupname) {
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=" + username);
        this.navigation().checkWebSudoWithLastPassword();
        this.assertions.assertNodeByIdHasText("groups", groupname);
    }

    public void assertUserDoesNotBelongToGroup(String username, String groupname) {
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=" + username);
        this.navigation().checkWebSudoWithLastPassword();
        this.assertions.assertNodeByIdDoesNotHaveText("groups", groupname);
    }
}

