/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.admin.WorkflowTransition;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.util.Map;
import net.sourceforge.jwebunit.WebTester;

public class WorkflowTransitionImpl
extends AbstractFuncTestUtil
implements WorkflowTransition {
    private static final String ADD_POST_FUNCTION_LINK_ID = "add_post_func";
    private static final String ADD_CONDITION_LINK_ID = "add_new_condition";
    private static final String ADD_VALIDATOR_LINK_ID = "add_new_validator";
    private static final String RADIO_TYPE_NAME = "type";
    private static final String ADD_BUTTON_NAME = "Add";

    public WorkflowTransitionImpl(WebTester tester, JIRAEnvironmentData environmentData, int logIndentLevel) {
        super(tester, environmentData, logIndentLevel);
    }

    @Override
    public boolean canAddWorkflowCondition(String workflowConditionKey) {
        this.goToAddWorkflowCondition();
        return this.workflowModuleRadioLocator(workflowConditionKey).exists();
    }

    @Override
    public WorkflowTransition goToAddWorkflowCondition() {
        this.openTab(WorkflowTransition.Tabs.CONDITIONS);
        this.tester.clickLink(ADD_CONDITION_LINK_ID);
        return this;
    }

    @Override
    public WorkflowTransition addWorkflowCondition(String workflowConditionKey) {
        this.goToAddWorkflowCondition();
        this.selectWorkflowModule(workflowConditionKey);
        this.submitAdd();
        return this;
    }

    @Override
    public WorkflowTransition addWorkflowCondition(String workflowConditionKey, Map<String, String> configFormParams) {
        this.goToAddWorkflowCondition();
        this.selectWorkflowModule(workflowConditionKey);
        this.submitAdd();
        this.setConfigValues(configFormParams);
        this.submitAdd();
        return this;
    }

    @Override
    public WorkflowTransition goToAddWorkflowValidator() {
        this.openTab(WorkflowTransition.Tabs.VALIDATORS);
        this.tester.clickLink(ADD_VALIDATOR_LINK_ID);
        return this;
    }

    @Override
    public boolean canAddWorkflowValidator(String workflowValidatorKey) {
        this.goToAddWorkflowValidator();
        return this.workflowModuleRadioLocator(workflowValidatorKey).exists();
    }

    @Override
    public WorkflowTransition addWorkflowValidator(String workflowValidatorKey) {
        this.goToAddWorkflowValidator();
        this.selectWorkflowModule(workflowValidatorKey);
        this.submitAdd();
        return this;
    }

    @Override
    public WorkflowTransition addWorkflowValidator(String workflowValidatorKey, Map<String, String> configFormParams) {
        this.goToAddWorkflowValidator();
        this.selectWorkflowModule(workflowValidatorKey);
        this.submitAdd();
        this.setConfigValues(configFormParams);
        this.submitAdd();
        return this;
    }

    @Override
    public boolean canAddWorkflowFunction(String workflowFunctionKey) {
        this.goToAddWorkflowFunction();
        return this.workflowModuleRadioLocator(workflowFunctionKey).exists();
    }

    @Override
    public WorkflowTransition goToAddWorkflowFunction() {
        this.openTab(WorkflowTransition.Tabs.POST_FUNCTIONS);
        this.tester.clickLink(ADD_POST_FUNCTION_LINK_ID);
        return this;
    }

    @Override
    public WorkflowTransition addWorkflowFunction(String workflowFunctionKey) {
        this.goToAddWorkflowFunction();
        this.selectWorkflowModule(workflowFunctionKey);
        this.submitAdd();
        return this;
    }

    @Override
    public WorkflowTransition addWorkflowFunction(String workflowFunctionKey, Map<String, String> configFormParams) {
        this.goToAddWorkflowFunction();
        this.selectWorkflowModule(workflowFunctionKey);
        this.setConfigValues(configFormParams);
        this.submitAdd();
        return this;
    }

    @Override
    public boolean isTabOpen(WorkflowTransition.Tabs tab) {
        return !this.locators.id(tab.linkId()).exists();
    }

    @Override
    public WorkflowTransition openTab(WorkflowTransition.Tabs tab) {
        if (!this.isTabOpen(tab)) {
            this.tester.clickLink(tab.linkId());
        }
        return this;
    }

    private void selectWorkflowModule(String workflowModuleKey) {
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement(RADIO_TYPE_NAME, workflowModuleKey);
    }

    private void setConfigValues(Map<String, String> configFormParams) {
        this.tester.setWorkingForm("jiraform");
        for (Map.Entry<String, String> formEntry : configFormParams.entrySet()) {
            this.tester.setFormElement(formEntry.getKey(), formEntry.getValue());
        }
    }

    private void submitAdd() {
        this.tester.submit(ADD_BUTTON_NAME);
    }

    private Locator workflowModuleRadioLocator(String moduleKey) {
        return this.locators.css(String.format("input[type=radio][name=type][value=%s]", moduleKey));
    }
}

