/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.admin.WorkflowSteps;
import com.atlassian.jira.functest.framework.admin.WorkflowTransition;
import com.atlassian.jira.functest.framework.admin.WorkflowTransitionImpl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import net.sourceforge.jwebunit.WebTester;
import org.xml.sax.SAXException;

public class WorkflowStepsImpl
extends AbstractFuncTestUtil
implements WorkflowSteps {
    private static final String TRANSITION_LINK_ID_TEMPLATE = "edit_action_%d_%d";
    private static final String ADD_TRANSITION_LINK_PREFIX = "add_trans_";
    private final WorkflowTransition transition;

    public WorkflowStepsImpl(WebTester tester, JIRAEnvironmentData environmentData, int logIndentLevel) {
        super(tester, environmentData, logIndentLevel);
        this.transition = new WorkflowTransitionImpl(tester, environmentData, this.childLogIndentLevel());
    }

    @Override
    public WorkflowTransition editTransition(int stepId, int transitionId) {
        this.tester.clickLink(this.transitionLinkLocatorFor(stepId, transitionId));
        return this.transition;
    }

    @Override
    public WorkflowSteps add(String stepName, String linkedStatus) {
        this.tester.setFormElement("stepName", stepName);
        if (linkedStatus != null) {
            this.tester.selectOption("stepStatus", linkedStatus);
        }
        this.tester.submit("Add");
        return this;
    }

    @Override
    public WorkflowSteps addTransition(String stepName, String transitionName, String transitionDescription, String destinationStep, String transitionFieldScreen) {
        this.tester.clickLink(ADD_TRANSITION_LINK_PREFIX + this.getStepId(stepName));
        this.tester.setFormElement("transitionName", transitionName);
        this.tester.setFormElement("description", transitionDescription);
        this.tester.selectOption("destinationStep", destinationStep);
        if (transitionFieldScreen != null) {
            this.tester.selectOption("view", transitionFieldScreen);
        }
        this.tester.submit("Add");
        return this;
    }

    private String getStepId(String stepName) {
        try {
            String workflowStepLinkId = this.tester.getDialog().getResponse().getLinkWith(stepName).getID();
            return workflowStepLinkId.substring(10);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private String transitionLinkLocatorFor(int stepId, int transitionId) {
        return String.format(TRANSITION_LINK_ID_TEMPLATE, stepId, transitionId);
    }
}

