/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.ViewWorkflows;
import com.atlassian.jira.functest.framework.admin.WorkflowSteps;
import com.atlassian.jira.functest.framework.admin.WorkflowStepsImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import net.sourceforge.jwebunit.WebTester;

public class ViewWorkflowsImpl
extends AbstractFuncTestUtil
implements ViewWorkflows {
    private static final String NEW_WORKFLOW_NAME_INPUT_NAME = "newWorkflowName";
    private static final String NEW_WORKFLOW_DESCRIPTION_INPUT_NAME = "description";
    private static final String SUBMIT_BUTTON_NAME = "Add";
    private static final String COPY_BUTTON_NAME = "Copy";
    private static final String COPY_LINK_PREFIX = "copy_";
    private static final String STEPS_LINK_PREFIX = "steps_live_";
    private final Navigation navigation;
    private final WorkflowSteps steps;

    public ViewWorkflowsImpl(WebTester tester, JIRAEnvironmentData environmentData, int logIndentLevel, Navigation navigation) {
        super(tester, environmentData, logIndentLevel);
        this.navigation = navigation;
        this.steps = new WorkflowStepsImpl(tester, environmentData, this.childLogIndentLevel());
    }

    @Override
    public ViewWorkflows goTo() {
        this.navigation.gotoWorkflows();
        return this;
    }

    @Override
    public ViewWorkflows addWorkflow(String name, String description) {
        Assertions.notNull("name", name);
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement(NEW_WORKFLOW_NAME_INPUT_NAME, name);
        if (description != null) {
            this.tester.setFormElement(NEW_WORKFLOW_DESCRIPTION_INPUT_NAME, description);
        }
        this.tester.submit(SUBMIT_BUTTON_NAME);
        return this;
    }

    @Override
    public ViewWorkflows copyWorkflow(String nameToCopy, String newWorkflowName) {
        this.tester.clickLink(COPY_LINK_PREFIX + nameToCopy);
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement(NEW_WORKFLOW_NAME_INPUT_NAME, newWorkflowName);
        this.tester.submit(COPY_BUTTON_NAME);
        return this;
    }

    @Override
    public WorkflowSteps workflowSteps(String workflowName) {
        this.tester.clickLink(STEPS_LINK_PREFIX + workflowName);
        return this.steps;
    }
}

