/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.admin.DefaultRoleDetails;
import com.atlassian.jira.functest.framework.admin.RoleDetails;
import com.atlassian.jira.functest.framework.admin.Roles;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;

public class RolesImpl
extends AbstractFuncTestUtil
implements Roles {
    private static final String DELETE_ROLE = "/secure/project/DeleteProjectRole!default.jspa?id=";
    private static final String ADD_ROLE = "/secure/project/UserRoleActorAction!addUsers.jspa?projectRoleId=";
    private RoleDetails roleDetails;

    public RolesImpl(WebTester tester, JIRAEnvironmentData environmentData, int logIndentLevel) {
        super(tester, environmentData, logIndentLevel);
        this.roleDetails = new DefaultRoleDetails(tester);
    }

    @Override
    public void delete(long roleId) {
        this.log("Deleting project role " + roleId);
        this.tester.gotoPage(DELETE_ROLE + roleId);
        this.tester.submit("Delete");
    }

    @Override
    public void delete(String name) {
        this.log("Deleting project role:" + name);
        this.gotoProjectRolesScreen();
        this.tester.clickLink("delete_" + name);
        this.tester.submit("Delete");
    }

    private void gotoProjectRolesScreen() {
        if (new IdLocator(this.tester, "adminMenu").getNodes().length == 0) {
            this.getFuncTestHelperFactory().getNavigation().gotoAdmin();
        }
        this.tester.clickLink("project_role_browser");
    }

    @Override
    public void create(String name, String description) {
        this.gotoProjectRolesScreen();
        this.tester.setFormElement("name", name);
        this.tester.setFormElement("description", description);
        this.tester.submit("Add Project Role");
        this.tester.assertTextPresent(name);
        this.tester.assertTextPresent(description);
    }

    @Override
    public RoleDetails edit(String name) {
        this.gotoProjectRolesScreen();
        this.tester.clickLink("edit_" + name);
        return this.roleDetails;
    }

    @Override
    public void addProjectRoleForUser(String projectName, int roleId, String userName) {
        boolean projectExists = this.getFuncTestHelperFactory().getAdministration().project().projectExists(projectName);
        if (projectExists) {
            this.tester.clickLink("view_projects");
            this.tester.clickLinkWithText(projectName);
            String text = this.tester.getDialog().getResponse().getURL().toString();
            int projectIdLocation = text.indexOf("pid=") + "pid=".length();
            String projectId = text.substring(projectIdLocation, projectIdLocation + 5);
            HtmlPage page = new HtmlPage(this.tester);
            this.tester.gotoPage(page.addXsrfToken(ADD_ROLE + roleId + "&projectId=" + projectId + "&id=" + roleId + "&userNames=" + userName));
            this.tester.assertLinkPresent("watcher_link_" + userName);
        } else {
            Assert.fail((String)("A project with the name '" + projectName + "' does not exist."));
        }
    }
}

