/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.Project;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.util.AsynchronousTasks;
import com.atlassian.jira.functest.framework.util.url.URLUtil;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.WebLink;
import java.io.IOException;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;
import org.xml.sax.SAXException;

public class ProjectImpl
extends AbstractFuncTestUtil
implements Project {
    private final Navigation navigation;
    private final Assertions assertions;
    private AsynchronousTasks asynchronousTasks;
    private final HtmlPage htmlPage;

    public ProjectImpl(WebTester tester, JIRAEnvironmentData environmentData, Navigation navigation, Assertions assertions, AsynchronousTasks asynchronousTasks) {
        super(tester, environmentData, 2);
        this.navigation = navigation;
        this.assertions = assertions;
        this.asynchronousTasks = asynchronousTasks;
        this.htmlPage = new HtmlPage(tester);
    }

    @Override
    public String addProject(String name, String key, String lead) {
        return this.addProject(name, key, "", lead, "");
    }

    @Override
    public String addProject(String name, String key, String url, String lead, String description) {
        return this.addProject(name, key, url, lead, description, null);
    }

    @Override
    public void deleteProject(long projectId) {
        this.tester.gotoPage("/secure/admin/DeleteProject!default.jspa?pid=" + projectId);
        this.navigation.checkWebSudoWithLastPassword();
        this.tester.submit("Delete");
    }

    @Override
    public void deleteProject(String project) {
        this.tester.gotoPage("/secure/project/ViewProjects.jspa");
        this.tester.clickLinkWithText(project);
        this.tester.clickLinkWithText("Delete Project");
        this.tester.assertTextPresent("Delete Project: " + project);
        this.tester.submit("Delete");
    }

    @Override
    public String addComponent(String projectName, String componentName, String description, String leadUserName) {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLinkWithText(projectName);
        this.tester.clickLink("add_component");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("name", componentName);
        if (description != null) {
            this.tester.setFormElement("description", description);
        }
        if (leadUserName != null) {
            this.tester.setFormElement("componentLead", leadUserName);
        }
        this.tester.submit("Add");
        return this.extractIdFromLinkParameterValue("del_comp_" + componentName, "cid");
    }

    @Override
    public String addVersion(String projectName, String versionName, String description, String releaseDate) {
        this.gotoManageVersions(projectName);
        this.tester.setWorkingForm("jiraform");
        if (versionName != null) {
            this.tester.setFormElement("name", versionName);
        }
        if (description != null) {
            this.tester.setFormElement("description", description);
        }
        if (releaseDate != null) {
            this.tester.setFormElement("releaseDate", releaseDate);
        }
        this.tester.submit("Add");
        return this.extractIdFromLinkParameterValue("del_" + versionName, "versionId");
    }

    @Override
    public void archiveVersion(String projectName, String versionName) {
        this.gotoManageVersions(projectName);
        this.tester.clickLink("archive_" + versionName);
    }

    @Override
    public void releaseVersion(String projectName, String versionName, String releaseDate) {
        this.gotoManageVersions(projectName);
        this.tester.clickLink("release_" + versionName);
        if (releaseDate != null) {
            this.tester.setWorkingForm("jiraform");
            this.tester.setFormElement("releaseDate", releaseDate);
        }
        this.tester.submit("Release");
    }

    @Override
    public void unreleaseVersion(String projectName, String versionName, String releaseDate) {
        this.gotoManageVersions(projectName);
        this.tester.clickLink("unrelease_" + versionName);
        if (releaseDate != null) {
            this.tester.setWorkingForm("jiraform");
            this.tester.setFormElement("releaseDate", releaseDate);
        }
        this.tester.submit("Unrelease");
    }

    @Override
    public void deleteVersion(String projectName, String versionName) {
        this.gotoManageVersions(projectName);
        this.tester.clickLink("del_" + versionName);
        this.tester.submit("Delete");
    }

    @Override
    public void editVersionDetails(String projectName, String versionName, String name, String description, String releaseDate, String precedingVersionName) {
        this.gotoManageVersions(projectName);
        this.tester.clickLink("edit_" + versionName);
        this.tester.setWorkingForm("jiraform");
        if (name != null) {
            this.tester.setFormElement("name", name);
        }
        if (description != null) {
            this.tester.setFormElement("description", description);
        }
        if (releaseDate != null) {
            this.tester.setFormElement("releaseDate", releaseDate);
        }
        if (precedingVersionName != null) {
            this.tester.setFormElement("scheduleAfterVersion_select", precedingVersionName);
        }
        this.tester.submit("Update");
    }

    @Override
    public void editComponent(String projectName, String componentName, String name, String description, String leadUserName) {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLinkWithText(projectName);
        this.tester.clickLink("edit_comp_" + componentName);
        this.tester.setWorkingForm("jiraform");
        if (name != null) {
            this.tester.setFormElement("name", name);
        }
        if (description != null) {
            this.tester.setFormElement("description", description);
        }
        if (leadUserName != null) {
            this.tester.setFormElement("componentLead", leadUserName);
        }
        this.tester.submit("Update");
    }

    @Override
    public void associateFieldConfigurationScheme(String projectName, String newFieldConfigurationSchemeName) {
        this.navigation.gotoAdminSection("view_projects");
        this.navigation.clickLinkWithExactText(projectName);
        this.tester.clickLink("select_fieldlayoutscheme");
        this.navigation.checkWebSudoWithLastPassword();
        this.tester.setWorkingForm("jiraform");
        if (newFieldConfigurationSchemeName == null) {
            newFieldConfigurationSchemeName = "None";
        }
        this.tester.selectOption("schemeId", newFieldConfigurationSchemeName);
        this.tester.submit("Associate");
        String displayName = "None".equals(newFieldConfigurationSchemeName) ? "System Default Field Configuration" : newFieldConfigurationSchemeName;
        this.assertions.getTextAssertions().assertTextSequence(new XPathLocator(this.tester, "//td[@class='jiraformbody']"), "Field Configuration Scheme:", displayName, "Issue Type Screen Scheme:");
    }

    @Override
    public void associateWorkflowScheme(String projectName, String workflowSchemeName) {
        this.viewProject(projectName);
        this.tester.clickLink("select_workflow_scheme");
        this.tester.setWorkingForm("jiraform");
        this.tester.selectOption("schemeId", workflowSchemeName);
        this.tester.submit("Associate");
        boolean thereAreIssuesToMigrate = !this.locators.css(".jiraform").getText().contains("There are no issues to migrate.");
        this.tester.submit("Associate");
        if (thereAreIssuesToMigrate) {
            this.waitForWorkflowMigration(1000L, 100);
        }
    }

    private void waitForWorkflowMigration(long sleepTime, int retryCount) {
        this.asynchronousTasks.waitForSuccessfulCompletion(sleepTime, retryCount, "Workflow Migration");
    }

    @Override
    public void setProjectLead(String projectName, String userName) {
        this.navigation.gotoAdminSection("view_projects");
        this.navigation.clickLinkWithExactText(projectName);
        this.tester.clickLink("edit_project");
        this.tester.setFormElement("lead", userName);
        this.tester.submit();
    }

    @Override
    public String addProject(String name, String key, String url, String lead, String description, String securitySchemeName) {
        String projectId;
        if (this.projectExists(name)) {
            this.log("Project " + name + " exists ");
            this.navigation.gotoAdmin();
            this.navigation.clickLinkWithExactText(name);
            this.assertions.getURLAssertions().assertCurrentURLPathEndsWith(this.getEnvironmentData().getContext() + "/secure/project/ViewProject.jspa");
        } else {
            this.log("Adding project " + name);
            this.navigation.gotoAdmin();
            this.tester.clickLink("add_project");
            this.navigation.checkWebSudoWithLastPassword();
            this.tester.assertTextPresent("action=\"AddProject.jspa\"");
            this.tester.setFormElement("name", name);
            this.tester.setFormElement("key", key);
            this.tester.setFormElement("url", url);
            this.tester.setFormElement("lead", lead);
            this.tester.setFormElement("description", description);
            if (securitySchemeName != null) {
                this.tester.selectOption("issueSecurityScheme", securitySchemeName);
            }
            this.tester.submit();
            this.assertions.getURLAssertions().assertCurrentURLPathEndsWith(this.getEnvironmentData().getContext() + "/secure/admin/ViewProject.jspa");
        }
        try {
            String text = this.tester.getDialog().getResponse().getText();
            int projectIdLocation = text.indexOf("projectId=") + "projectId=".length();
            projectId = text.substring(projectIdLocation, projectIdLocation + 5);
        }
        catch (IOException e) {
            Assert.fail((String)("Unable to retrieve issue key" + e.getMessage()));
            return "fail";
        }
        return projectId;
    }

    @Override
    public void viewProject(String project) {
        this.navigation.gotoAdmin();
        this.tester.clickLink("view_projects");
        if (this.htmlPage.isLinkPresentWithExactText(project)) {
            this.navigation.clickLinkWithExactText(project);
        } else {
            Assert.fail((String)("Cannot find link to project with name '" + project + "'"));
        }
    }

    @Override
    public boolean projectExists(String project) {
        this.log("Checking if project '" + project + "' exists");
        this.navigation.gotoAdmin();
        this.tester.clickLink("view_projects");
        return this.htmlPage.isLinkPresentWithExactText(project);
    }

    private void gotoManageVersions(String projectName) {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLinkWithText(projectName);
        this.tester.clickLink("manage_versions");
    }

    private String extractIdFromLinkParameterValue(String linkId, String paramName) {
        try {
            WebLink link = this.tester.getDialog().getResponse().getLinkWithID(linkId);
            String href = link.getURLString();
            String paramValueFromUrl = URLUtil.getQueryParamValueFromUrl(href, paramName);
            if (paramValueFromUrl == null) {
                Assert.fail((String)("Unable to retrieve paramName value from href '" + href + "'"));
            }
            return paramValueFromUrl;
        }
        catch (SAXException e) {
            Assert.fail((String)("Unable to retrieve link from response: " + e.getMessage()));
            return null;
        }
    }
}

