/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.Dashboard;
import com.atlassian.jira.functest.framework.DashboardImpl;
import com.atlassian.jira.functest.framework.FilterPickerPopupNavigation;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.UserProfile;
import com.atlassian.jira.functest.framework.UserProfileImpl;
import com.atlassian.jira.functest.framework.Workflows;
import com.atlassian.jira.functest.framework.WorkflowsImpl;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.log.FuncTestLogger;
import com.atlassian.jira.functest.framework.navigation.FilterNavigation;
import com.atlassian.jira.functest.framework.navigation.IssueNavigation;
import com.atlassian.jira.functest.framework.navigation.IssueNavigationImpl;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigationImpl;
import com.atlassian.jira.functest.framework.navigation.ManageFiltersNavigation;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;
import java.net.URL;
import java.net.URLEncoder;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public class NavigationImpl
extends AbstractFuncTestUtil
implements Navigation,
FuncTestLogger {
    public static final String BUTTON_NEXT = "Next";
    private static final String PAGE_CUSTOM_FIELDS = "/secure/admin/ViewCustomFields.jspa";
    private static final String PAGE_LIST_WORKFLOWS = "/secure/admin/workflows/ListWorkflows.jspa";
    private final FilterNavigation manageFiltersNavigation;
    private final IssueNavigation issue;
    private final IssueNavigatorNavigation issueNavigator;
    private final Dashboard dashboard;
    private final FilterNavigation filterPickerPopup;
    private final UserProfile userProfile;
    private final HtmlPage page;
    private final Workflows workflows;
    private String lastPasswordUsed;

    public NavigationImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData, 2);
        this.manageFiltersNavigation = new ManageFiltersNavigation(tester, environmentData);
        this.filterPickerPopup = new FilterPickerPopupNavigation(tester);
        this.issue = new IssueNavigationImpl(tester, environmentData);
        this.issueNavigator = new IssueNavigatorNavigationImpl(tester, environmentData);
        this.dashboard = new DashboardImpl(tester, environmentData, this);
        this.userProfile = new UserProfileImpl(tester, environmentData, this);
        this.page = new HtmlPage(tester);
        this.workflows = new WorkflowsImpl(tester, environmentData, this);
    }

    @Override
    public void login(String userName) {
        this.login(userName, userName);
    }

    @Override
    public void login(String userName, String userPassword) {
        this.login(userName, userPassword, false);
    }

    @Override
    public void login(String userName, String userPassword, boolean useCookie) {
        this.log("Logging in as '" + userName + "'");
        this.tester.beginAt("/login.jsp");
        this.tester.setFormElement("os_username", userName);
        this.tester.setFormElement("os_password", userPassword);
        if (useCookie) {
            this.tester.checkCheckbox("os_cookie", "true");
        }
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        this.lastPasswordUsed = userPassword;
    }

    @Override
    public void logout() {
        String token;
        try {
            token = this.page.getXsrfToken();
        }
        catch (Exception e) {
            token = "";
        }
        if (StringUtils.isBlank((String)token)) {
            this.tester.gotoPage("/secure/ViewKeyboardShortcuts.jspa");
            token = this.page.getXsrfToken();
        }
        this.log("Logging out");
        this.tester.beginAt("/secure/Logout!default.jspa?atl_token=" + token);
        if (this.tester.getDialog().isTextInResponse("Confirm logout")) {
            this.tester.clickButton("confirm-logout-submit");
        }
    }

    @Override
    public String getCurrentPage() {
        String urlString = this.tester.getDialog().getResponse().getURL().toString();
        String ctx = this.environmentData.getContext();
        if (ctx.length() > 0) {
            return urlString.substring(urlString.indexOf(ctx) + ctx.length());
        }
        String base = this.environmentData.getBaseUrl().toString();
        return urlString.substring(base.length());
    }

    @Override
    public void clickLink(WebLink webLink) {
        String url = webLink.getURLString();
        if (!url.startsWith("/")) {
            url = this.makeAbsoluteUrl(url, this.tester.getDialog().getResponse().getURL());
        }
        if (url.startsWith(this.getEnvironmentData().getContext())) {
            url = url.substring(this.getEnvironmentData().getContext().length());
        }
        this.tester.gotoPage(url);
    }

    @Override
    public void clickLinkWithExactText(String text) {
        WebLink link = this.page.getLinksWithExactText(text)[0];
        this.clickLink(link);
    }

    @Override
    public void clickLinkInTableCell(WebTable table, int row, int col, String linkText) {
        WebLink webLink = table.getTableCell(row, col).getLinkWith(linkText);
        this.clickLink(webLink);
    }

    @Override
    public void clickLinkInTableCell(String tableId, int row, int col, String linkText) {
        this.clickLinkInTableCell(this.tester.getDialog().getWebTableBySummaryOrId(tableId), row, col, linkText);
    }

    @Override
    public void jiraLog(String logMessage) {
        this.tester.gotoPage("/secure/admin/debug/logMessage.jsp?message=" + URLEncoder.encode(logMessage));
    }

    @Override
    public void gotoDashboard() {
        this.dashboard.navigateTo();
    }

    @Override
    public Dashboard dashboard() {
        return this.dashboard;
    }

    @Override
    public Workflows workflows() {
        return this.workflows;
    }

    @Override
    public void clickOnNext() {
        this.tester.submit(BUTTON_NEXT);
    }

    @Override
    public void gotoAdmin() {
        HTMLElement element = null;
        try {
            element = this.tester.getDialog().getResponse().getElementWithID("adminMenu");
        }
        catch (SAXException e) {
            this.log("problem trying to find admin menu div, mustn't be on the admin menu");
        }
        if (element == null) {
            this.log("going to admin page");
            this.tester.clickLink("admin_link");
            this.tester.clickLink("general_configuration");
            this.checkWebSudoWithLastPassword();
        }
    }

    @Override
    public void checkWebSudoAndAuthenticate(String password) {
        if (new IdLocator(this.tester, "login-notyou").exists()) {
            this.tester.setFormElement("webSudoPassword", password);
            this.tester.setWorkingForm("login-form");
            this.tester.submit();
        }
    }

    @Override
    public void checkWebSudoWithLastPassword() {
        this.checkWebSudoAndAuthenticate(this.lastPasswordUsed != null ? this.lastPasswordUsed : "admin");
    }

    @Override
    public void gotoPage(String url) {
        this.tester.gotoPage(url);
    }

    @Override
    public void gotoResource(String resourcePath) {
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        if ((resourcePath = this.makeAbsoluteUrl(resourcePath, this.tester.getDialog().getResponse().getURL())).startsWith(this.getEnvironmentData().getContext())) {
            resourcePath = resourcePath.substring(this.getEnvironmentData().getContext().length());
        }
        this.tester.gotoPage(resourcePath);
    }

    @Override
    public void gotoAdminSection(String linkId) {
        this.gotoAdmin();
        this.tester.clickLink(linkId);
        this.checkWebSudoWithLastPassword();
    }

    @Override
    public void gotoCustomFields() {
        this.tester.gotoPage(PAGE_CUSTOM_FIELDS);
        this.checkWebSudoWithLastPassword();
    }

    @Override
    public void gotoWorkflows() {
        this.tester.gotoPage(PAGE_LIST_WORKFLOWS);
        this.checkWebSudoWithLastPassword();
    }

    @Override
    public void runReport(Long projectId, String reportKey) {
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=" + projectId + "&reportKey=" + reportKey);
    }

    @Override
    public void runReport(Long projectId, String reportKey, Long filterId, String mapper) {
        this.tester.gotoPage("/secure/ConfigureReport.jspa?selectedProjectId=" + projectId + "&reportKey=" + reportKey + "&filterid=" + filterId + "&mapper=" + mapper);
    }

    @Override
    public void browseProject(String projectKey) {
        this.tester.gotoPage("/browse/" + projectKey);
    }

    @Override
    public void browseProjectTabPanel(String projectKey, String tab) {
        this.browseProject(projectKey);
        this.clickLinkOrAssertSpanPresent(tab + "-panel-panel");
    }

    @Override
    public void browseComponentTabPanel(String projectKey, String componentName, String tab) {
        this.browseProjectTabPanel(projectKey, "components");
        this.tester.clickLinkWithText(componentName);
        this.clickLinkOrAssertSpanPresent("component-" + tab + "-panel-panel");
    }

    @Override
    public void browseVersionTabPanel(String projectKey, String versionName, String tab) {
        this.browseProjectTabPanel(projectKey, "versions");
        this.tester.clickLinkWithText(versionName);
        this.clickLinkOrAssertSpanPresent("version-" + tab + "-panel-panel");
    }

    @Override
    public void browseComponentTabPanel(String projectKey, String componentName) {
        this.browseProjectTabPanel(projectKey, "components");
        this.tester.clickLinkWithText(componentName);
    }

    @Override
    public void browseVersionTabPanel(String projectKey, String versionName) {
        this.browseProjectTabPanel(projectKey, "versions");
        this.tester.clickLinkWithText(versionName);
    }

    private void clickLinkOrAssertSpanPresent(String linkId) {
        WebLink linkElement = null;
        try {
            linkElement = this.tester.getDialog().getResponse().getLinkWithID(linkId);
        }
        catch (SAXException e) {
            this.log("Can't find link with id: " + linkId + ", might already be on that tab panel");
        }
        if (linkElement != null) {
            this.tester.clickLink(linkId);
        } else {
            HTMLElement spanElement = null;
            try {
                spanElement = this.tester.getDialog().getResponse().getElementWithID(linkId);
            }
            catch (SAXException e) {
                this.log("Can't find span with id: " + linkId + ", this is bad.");
            }
            if (spanElement == null) {
                throw new IllegalStateException("Could not browse to project tab panel with link id '" + linkId + "' - tab did not exist.");
            }
        }
    }

    @Override
    public FilterNavigation manageFilters() {
        return this.manageFiltersNavigation;
    }

    @Override
    public FilterNavigation filterPickerPopup() {
        return this.filterPickerPopup;
    }

    @Override
    public UserProfile userProfile() {
        return this.userProfile;
    }

    @Override
    public IssueNavigation issue() {
        return this.issue;
    }

    @Override
    public IssueNavigatorNavigation issueNavigator() {
        return this.issueNavigator;
    }

    private String makeAbsoluteUrl(String relativeUrl, URL currentPage) {
        String path = currentPage.getPath();
        int pos = path.lastIndexOf(47);
        path = path.substring(0, pos + 1);
        return path + relativeUrl;
    }
}

