/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.TestSuiteBuilder;
import com.atlassian.jira.functest.framework.log.FuncTestOut;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.util.LocalTestEnvironmentData;
import com.atlassian.jira.webtests.util.TestClassUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

public class FuncTestSuite
implements Test {
    private final Set<Class<? extends TestCase>> funcTests = new LinkedHashSet<Class<? extends TestCase>>();
    private final Set<Class<? extends TestCase>> bundledPlugins2Tests = new LinkedHashSet<Class<? extends TestCase>>();
    private final Set<Class<? extends TestCase>> tpmLdapTests = new LinkedHashSet<Class<? extends TestCase>>();
    private final Set<Class<? extends TestCase>> singleRunTests = new LinkedHashSet<Class<? extends TestCase>>();

    public Test createTest() {
        return this.createTest(new LocalTestEnvironmentData());
    }

    public Test createTest(JIRAEnvironmentData environment) {
        Set<Class<? extends TestCase>> tests = this.getTests(environment);
        TestSuiteBuilder builder = FuncTestSuite.createFuncTestBuilder();
        builder.addTests(tests);
        return builder.build();
    }

    public Set<Class<? extends TestCase>> getTests(JIRAEnvironmentData environmentData) {
        Set<Object> tests;
        if (environmentData.isSingleNamedTest()) {
            tests = new LinkedHashSet<Class<? extends TestCase>>();
            tests.add(environmentData.getSingleTestClass());
        } else if (environmentData.isAllTests()) {
            tests = new LinkedHashSet();
            tests.addAll(this.getFuncTests());
            tests.addAll(this.getBundledPlugins2Tests());
        } else {
            tests = environmentData.isBundledPluginsOnly() ? this.getBundledPlugins2Tests() : (environmentData.isTpmLdapTests() ? this.getTpmLdapTests() : this.getFuncTests());
        }
        return tests;
    }

    private static TestSuiteBuilder createFuncTestBuilder() {
        String b = System.getProperty("atlassian.test.suite.numbatches");
        String n = System.getProperty("atlassian.test.suite.batch");
        boolean parallel = Boolean.getBoolean("atlassian.test.suite.parallel");
        if (parallel && b != null) {
            int numBatches = Integer.parseInt(b);
            return new TestSuiteBuilder().maxBatch(numBatches).parallel(true).log(true);
        }
        if (b != null && n != null) {
            String batchInfo = "Batch " + n + " of " + b;
            try {
                int numBatches = Integer.parseInt(b);
                int batch = Integer.parseInt(n);
                if (batch > 0 && batch <= numBatches) {
                    FuncTestOut.out.println(batchInfo);
                    return new TestSuiteBuilder(batch, numBatches).log(true);
                }
                FuncTestOut.out.println("Batch mode FAIL. Batch information looks wrong-arse: " + batchInfo);
            }
            catch (NumberFormatException e) {
                FuncTestOut.err.println("Batch mode FAIL. Batch information cannot be properly interpreted: " + batchInfo);
                e.printStackTrace(FuncTestOut.err);
            }
        }
        return new TestSuiteBuilder().log(true);
    }

    public Set<Class<? extends TestCase>> getFuncTests() {
        return new LinkedHashSet<Class<? extends TestCase>>(this.funcTests);
    }

    public Set<Class<? extends TestCase>> getBundledPlugins2Tests() {
        return new LinkedHashSet<Class<? extends TestCase>>(this.bundledPlugins2Tests);
    }

    public Set<Class<? extends TestCase>> getTpmLdapTests() {
        return new LinkedHashSet<Class<? extends TestCase>>(this.tpmLdapTests);
    }

    public Set<Class<? extends TestCase>> getSingleRunTests() {
        return new LinkedHashSet<Class<? extends TestCase>>(this.singleRunTests);
    }

    public Set<Class<? extends TestCase>> getAllTests() {
        return CollectionBuilder.newBuilder().addAll((Collection<Class<? extends TestCase>>)this.getFuncTests()).addAll((Collection<Class<? extends TestCase>>)this.getBundledPlugins2Tests()).addAll((Collection<Class<? extends TestCase>>)this.getTpmLdapTests()).addAll((Collection<Class<? extends TestCase>>)this.getSingleRunTests()).asSet();
    }

    public FuncTestSuite addBundledPlugins2Only(Class<? extends TestCase> testCaseClass) {
        this.assertItsATest(testCaseClass);
        this.bundledPlugins2Tests.add(testCaseClass);
        return this;
    }

    public FuncTestSuite addTpmLdapOnly(Class<? extends TestCase> testCaseClass) {
        this.assertItsATest(testCaseClass);
        this.tpmLdapTests.add(testCaseClass);
        return this;
    }

    public FuncTestSuite addSingleRunTest(Class<? extends TestCase> testCaseClass) {
        this.assertItsATest(testCaseClass);
        this.singleRunTests.add(testCaseClass);
        return this;
    }

    public FuncTestSuite addTest(Class<? extends TestCase> testCaseClass) {
        this.assertItsATest(testCaseClass);
        this.funcTests.add(testCaseClass);
        return this;
    }

    public FuncTestSuite addTests(Collection<Class<? extends TestCase>> testCaseClasses) {
        for (Class<? extends TestCase> testCaseClass : testCaseClasses) {
            this.addTest(testCaseClass);
        }
        return this;
    }

    public FuncTestSuite addTestsInPackage(String packageName, boolean recursive) {
        List<Class<? extends TestCase>> cases = this.getTestClasses(packageName, recursive);
        this.addTests(cases);
        return this;
    }

    public FuncTestSuite addTestsInPackageBundledPluginsOnly(String packageName, boolean recursive) {
        List<Class<? extends TestCase>> cases = this.getTestClasses(packageName, recursive);
        for (Class<? extends TestCase> aCase : cases) {
            this.addBundledPlugins2Only(aCase);
        }
        return this;
    }

    public FuncTestSuite addTestSuite(FuncTestSuite funcTestSuite) {
        Set<Class<? extends TestCase>> tests = funcTestSuite.getFuncTests();
        for (Class<? extends TestCase> testCaseClass : tests) {
            this.addTest(testCaseClass);
        }
        tests = funcTestSuite.getBundledPlugins2Tests();
        for (Class<? extends TestCase> testCaseClass : tests) {
            this.addBundledPlugins2Only(testCaseClass);
        }
        tests = funcTestSuite.getTpmLdapTests();
        for (Class<? extends TestCase> testCaseClass : tests) {
            this.addTpmLdapOnly(testCaseClass);
        }
        tests = funcTestSuite.getSingleRunTests();
        for (Class<? extends TestCase> testCaseClass : tests) {
            this.addSingleRunTest(testCaseClass);
        }
        return this;
    }

    private void assertItsATest(Class testCaseClass) {
        if (!Test.class.isAssignableFrom(testCaseClass)) {
            throw new IllegalArgumentException("The class must be an instanceof of junit.framework.Test to be added - " + testCaseClass);
        }
    }

    public int countTestCases() {
        return this.createTest().countTestCases();
    }

    public void run(TestResult result) {
        this.createTest().run(result);
    }

    private List<Class<? extends TestCase>> getTestClasses(String packageName, boolean recursive) {
        List<Class<? extends TestCase>> result = TestClassUtils.getTestClasses(packageName, recursive);
        Collections.sort(result, new Comparator<Class<? extends TestCase>>(){

            @Override
            public int compare(Class<? extends TestCase> o1, Class<? extends TestCase> o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return result;
    }
}

