/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.AdministrationImpl;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.FormImpl;
import com.atlassian.jira.functest.framework.FuncTestCaseJiraSetup;
import com.atlassian.jira.functest.framework.FuncTestWebClientListener;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LocatorFactoryImpl;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.NavigationImpl;
import com.atlassian.jira.functest.framework.Parser;
import com.atlassian.jira.functest.framework.ParserImpl;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.AssertionsImpl;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.webtests.WebTesterFactory;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import junit.framework.TestCase;
import net.sourceforge.jwebunit.WebTester;

public class FuncTestHelperFactory {
    private final JIRAEnvironmentData environmentData;
    private final FuncTestCaseJiraSetup funcTestCaseJiraSetup;
    private WebTester tester;
    private NavigationImpl navigation = null;
    private AdministrationImpl administration = null;
    private AssertionsImpl assertions = null;
    private Parser parser = null;
    private Form form;
    private LocatorFactory locator;

    public FuncTestHelperFactory(TestCase funcTest, JIRAEnvironmentData environmentData) {
        this(funcTest, environmentData, new FuncTestWebClientListener());
    }

    public FuncTestHelperFactory(WebTester tester, JIRAEnvironmentData environmentData) {
        this.tester = tester;
        this.environmentData = environmentData;
        this.funcTestCaseJiraSetup = null;
    }

    FuncTestHelperFactory(TestCase funcTest, JIRAEnvironmentData environmentData, FuncTestWebClientListener webClientListener) {
        this.tester = new WebTester();
        this.environmentData = environmentData;
        this.initWebTester(environmentData);
        this.funcTestCaseJiraSetup = new FuncTestCaseJiraSetup(funcTest, this.getTester(), environmentData, this.getNavigation(), webClientListener);
    }

    private void initWebTester(JIRAEnvironmentData environmentData) {
        WebTesterFactory.setupWebTester(this.tester, environmentData);
        this.tester.beginAt("/");
    }

    public WebTester getTester() {
        return this.tester;
    }

    public Navigation getNavigation() {
        if (this.navigation == null) {
            this.navigation = new NavigationImpl(this.getTester(), this.getEnvironmentData());
        }
        return this.navigation;
    }

    public Form getForm() {
        if (this.form == null) {
            this.form = new FormImpl(this.getTester());
        }
        return this.form;
    }

    public Administration getAdministration() {
        if (this.administration == null) {
            this.administration = new AdministrationImpl(this.getTester(), this.getEnvironmentData(), this.getNavigation(), this.getAssertions());
        }
        return this.administration;
    }

    public Assertions getAssertions() {
        if (this.assertions == null) {
            this.assertions = new AssertionsImpl(this.getTester(), this.getEnvironmentData(), this.getNavigation(), this.getLocator());
        }
        return this.assertions;
    }

    public LocatorFactory getLocator() {
        if (this.locator == null) {
            this.locator = new LocatorFactoryImpl(this.getTester());
        }
        return this.locator;
    }

    public TextAssertions getTextAssertions() {
        return this.getAssertions().getTextAssertions();
    }

    public FuncTestCaseJiraSetup getFuncTestCaseJiraSetup() {
        return this.funcTestCaseJiraSetup;
    }

    public Parser getParser() {
        if (this.parser == null) {
            this.parser = new ParserImpl(this.tester, this.environmentData);
        }
        return this.parser;
    }

    public JIRAEnvironmentData getEnvironmentData() {
        return this.environmentData;
    }
}

