/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.Dashboard;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermissionUtils;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Set;
import net.sourceforge.jwebunit.HttpUnitDialog;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Node;

class DashboardImpl
extends AbstractFuncTestUtil
implements Dashboard {
    private static final String CONFIGURE_OFF_ID = "configure_off";
    private static final String CONFIGURE_ON_ID = "configure_on";
    private final Navigation navigation;

    DashboardImpl(WebTester tester, JIRAEnvironmentData environmentData, Navigation navigation) {
        super(tester, environmentData, 2);
        this.navigation = navigation;
    }

    @Override
    public Dashboard enableConfigureMode() {
        if (this.tester.getDialog().isLinkPresent(CONFIGURE_OFF_ID)) {
            return this;
        }
        if (this.tester.getDialog().isLinkPresent(CONFIGURE_ON_ID)) {
            this.tester.clickLink(CONFIGURE_ON_ID);
            return this;
        }
        return this.navigateTo();
    }

    @Override
    public Dashboard disableConfigureMode() {
        HttpUnitDialog d = this.tester.getDialog();
        if (d.isLinkPresent(CONFIGURE_ON_ID)) {
            return this;
        }
        this.tester.clickLink(CONFIGURE_OFF_ID);
        return this;
    }

    @Override
    public Dashboard navigateTo() {
        this.log("Navigating to Dashboard");
        this.tester.gotoPage("secure/Dashboard.jspa");
        return this;
    }

    @Override
    public Dashboard navigateTo(long pageId) {
        this.tester.gotoPage("secure/Dashboard.jspa?selectPageId=" + pageId);
        return this;
    }

    @Override
    public Dashboard navigateToFavourites() {
        this.tester.gotoPage("secure/ConfigurePortalPages!default.jspa?view=favourite");
        return this;
    }

    @Override
    public Dashboard navigateToMy() {
        this.tester.gotoPage("secure/ConfigurePortalPages!default.jspa?view=my");
        return this;
    }

    @Override
    public Dashboard navigateToPopular() {
        this.tester.gotoPage("secure/ConfigurePortalPages!default.jspa?view=popular");
        return this;
    }

    @Override
    public Dashboard navigateToSearch() {
        this.tester.gotoPage("secure/ConfigurePortalPages!default.jspa?view=search");
        return this;
    }

    @Override
    public Dashboard favouriteDashboard(long id) {
        this.tester.gotoPage("/secure/AddFavourite.jspa?entityType=PortalPage&entityId=" + id);
        return this;
    }

    @Override
    public Dashboard unFavouriteDashboard(long id) {
        this.tester.gotoPage("/secure/RemoveFavourite.jspa?entityType=PortalPage&entityId=" + id);
        return this;
    }

    @Override
    public Dashboard resetUserSessionState() {
        this.tester.gotoPage("/secure/Dashboard.jspa?resetPortal=true");
        return this;
    }

    @Override
    public Dashboard resetToDefault() {
        this.tester.gotoPage("/secure/RestoreDefaultDashboard.jspa?confirm=true");
        return this;
    }

    @Override
    public Long getDashboardPageId(String dashboardPageName, Locator pagesLocator) {
        XPathLocator links = new XPathLocator(pagesLocator.getNode(), "tbody/tr//a[text() = '" + dashboardPageName + "']/@href");
        Node link = links.getNode();
        if (link != null) {
            String href = link.getNodeValue();
            String str = "selectPageId=";
            int equalsIndex = href.lastIndexOf("selectPageId=");
            if (equalsIndex != -1) {
                try {
                    return Long.valueOf(href.substring(equalsIndex + "selectPageId=".length()));
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Override
    public Dashboard navigateToFullConfigure(Long dashboardPageId) {
        this.tester.gotoPage("secure/DashboardConfig!default.jspa?selectPageId=" + dashboardPageId);
        return this;
    }

    @Override
    public Dashboard navigateToDefaultFullConfigure() {
        this.tester.gotoPage("secure/admin/jira/EditDefaultDashboard!default.jspa");
        this.navigation.checkWebSudoWithLastPassword();
        return this;
    }

    @Override
    public Dashboard addPage(SharedEntityInfo info, Long cloneId) {
        Set<? extends TestSharingPermission> permissions = info.getSharingPermissions();
        if (info.isFavourite() && (permissions == null || permissions.isEmpty())) {
            this.tester.gotoPage("secure/AddPortalPage!default.jspa");
            this.tester.setFormElement("portalPageName", info.getName());
            if (!StringUtils.isBlank((String)info.getDescription())) {
                this.tester.setFormElement("portalPageDescription", info.getDescription());
            }
            if (cloneId != null) {
                this.tester.getDialog().getForm().setParameter("clonePageId", String.valueOf(cloneId));
            }
            this.tester.submit("Add");
        } else {
            this.addUsingPut(info, cloneId);
        }
        return this;
    }

    @Override
    public Dashboard editPage(SharedEntityInfo info) {
        Set<? extends TestSharingPermission> permissions = info.getSharingPermissions();
        if (info.isFavourite() && (permissions == null || permissions.isEmpty())) {
            this.tester.gotoPage("secure/EditPortalPage!default.jspa?pageId=" + info.getId());
            this.tester.setFormElement("portalPageName", info.getName());
            if (!StringUtils.isBlank((String)info.getDescription())) {
                this.tester.setFormElement("portalPageDescription", info.getDescription());
            }
            this.tester.submit("Update");
        } else {
            this.editUsingPut(info);
        }
        return this;
    }

    private void addUsingPut(SharedEntityInfo info, Long cloneId) {
        this.tester.gotoPage(this.createAddUrl(info, cloneId));
    }

    private String createAddUrl(SharedEntityInfo info, Long cloneId) {
        Set<? extends TestSharingPermission> permissions;
        StringBuffer buffer = new StringBuffer();
        buffer.append("secure/AddPortalPage.jspa?submit=Add");
        if (!StringUtils.isBlank((String)info.getName())) {
            buffer.append("&portalPageName=").append(DashboardImpl.encode(info.getName()));
        }
        if (!StringUtils.isBlank((String)info.getDescription())) {
            buffer.append("&portalPageDescription=").append(DashboardImpl.encode(info.getDescription()));
        }
        if (cloneId != null) {
            buffer.append("&clonePageId=").append(cloneId);
        }
        if ((permissions = info.getSharingPermissions()) != null) {
            buffer.append("&shareValues=").append(DashboardImpl.encode(TestSharingPermissionUtils.createJsonString(permissions)));
        }
        buffer.append("&favourite=").append(String.valueOf(info.isFavourite()));
        return buffer.toString();
    }

    private void editUsingPut(SharedEntityInfo info) {
        this.tester.gotoPage(this.createEditUrl(info));
    }

    private String createEditUrl(SharedEntityInfo info) {
        Set<? extends TestSharingPermission> permissions;
        StringBuffer buffer = new StringBuffer();
        buffer.append("secure/EditPortalPage.jspa?submit=Update&pageId=").append(info.getId());
        if (!StringUtils.isBlank((String)info.getName())) {
            buffer.append("&portalPageName=").append(DashboardImpl.encode(info.getName()));
        }
        if (!StringUtils.isBlank((String)info.getDescription())) {
            buffer.append("&portalPageDescription=").append(DashboardImpl.encode(info.getDescription()));
        }
        if ((permissions = info.getSharingPermissions()) != null) {
            buffer.append("&shareValues=").append(DashboardImpl.encode(TestSharingPermissionUtils.createJsonString(permissions)));
        }
        buffer.append("&favourite=").append(String.valueOf(info.isFavourite()));
        return buffer.toString();
    }

    private static String encode(String data) {
        try {
            return URLEncoder.encode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

