/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.Attachments;
import com.atlassian.jira.functest.framework.admin.AttachmentsImpl;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.admin.CustomFieldsImpl;
import com.atlassian.jira.functest.framework.admin.CvsModules;
import com.atlassian.jira.functest.framework.admin.CvsModulesImpl;
import com.atlassian.jira.functest.framework.admin.FieldConfigurationSchemes;
import com.atlassian.jira.functest.framework.admin.FieldConfigurationSchemesImpl;
import com.atlassian.jira.functest.framework.admin.FieldConfigurations;
import com.atlassian.jira.functest.framework.admin.FieldConfigurationsImpl;
import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.functest.framework.admin.GeneralConfigurationImpl;
import com.atlassian.jira.functest.framework.admin.IssueLinking;
import com.atlassian.jira.functest.framework.admin.IssueLinkingImpl;
import com.atlassian.jira.functest.framework.admin.IssueSecuritySchemes;
import com.atlassian.jira.functest.framework.admin.IssueSecuritySchemesImpl;
import com.atlassian.jira.functest.framework.admin.PermissionSchemes;
import com.atlassian.jira.functest.framework.admin.PermissionSchemesImpl;
import com.atlassian.jira.functest.framework.admin.Plugins;
import com.atlassian.jira.functest.framework.admin.PluginsImpl;
import com.atlassian.jira.functest.framework.admin.Project;
import com.atlassian.jira.functest.framework.admin.ProjectImpl;
import com.atlassian.jira.functest.framework.admin.ProjectImport;
import com.atlassian.jira.functest.framework.admin.ProjectImportImpl;
import com.atlassian.jira.functest.framework.admin.Resolutions;
import com.atlassian.jira.functest.framework.admin.ResolutionsImpl;
import com.atlassian.jira.functest.framework.admin.Roles;
import com.atlassian.jira.functest.framework.admin.RolesImpl;
import com.atlassian.jira.functest.framework.admin.Subtasks;
import com.atlassian.jira.functest.framework.admin.SubtasksImpl;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.admin.TimeTrackingImpl;
import com.atlassian.jira.functest.framework.admin.UsersAndGroups;
import com.atlassian.jira.functest.framework.admin.UsersAndGroupsImpl;
import com.atlassian.jira.functest.framework.admin.ViewFieldScreens;
import com.atlassian.jira.functest.framework.admin.ViewFieldScreensImpl;
import com.atlassian.jira.functest.framework.admin.ViewServices;
import com.atlassian.jira.functest.framework.admin.ViewWorkflows;
import com.atlassian.jira.functest.framework.admin.ViewWorkflowsImpl;
import com.atlassian.jira.functest.framework.admin.WorkflowSchemes;
import com.atlassian.jira.functest.framework.admin.WorkflowSchemesImpl;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.dump.FuncTestTimer;
import com.atlassian.jira.functest.framework.dump.TestInformationKit;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.log.FuncTestLogger;
import com.atlassian.jira.functest.framework.util.AsynchronousTasks;
import com.atlassian.jira.functest.framework.xmlbackup.XmlBackupCopier;
import com.atlassian.jira.webtests.LicenseKeys;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.WebTable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public class AdministrationImpl
extends AbstractFuncTestUtil
implements Administration,
FuncTestLogger {
    private static final String IMPORT_DIR = "import";
    private static final String PAGE_TRACKBACKS = "/secure/admin/jira/TrackbackAdmin!default.jspa";
    private static final Pattern PATTERN_BUILD_NUMBER = Pattern.compile("#(\\d+)");
    private final XmlBackupCopier xmlBackupCopier;
    private final Navigation navigation;
    private AsynchronousTasks asynchronousTasks;
    private final TextAssertions text;
    private final GeneralConfiguration generalConfiguration;
    private final Project project;
    private final UsersAndGroups usersAndGroups;
    private final Roles roles;
    private final CustomFields customFields;
    private final PermissionSchemes permissionSchemes;
    private final IssueSecuritySchemes issueSecuritySchemes;
    private final FieldConfigurations fieldConfigurations;
    private final FieldConfigurationSchemes fieldConfigurationSchemes;
    private final ResolutionsImpl resolutions;
    private final ViewServices viewServices;
    private final CvsModules cvsModules;
    private final ProjectImport projectImport;
    private final Attachments attachments;
    private final Plugins plugins;
    private final ViewFieldScreensImpl viewFieldScreens;
    private final ViewWorkflows workflows;
    private final WorkflowSchemes workflowSchemes;
    private static final ThreadLocal<String> JIRA_HOME_DIR = new ThreadLocal();

    public AdministrationImpl(WebTester tester, JIRAEnvironmentData environmentData, Navigation navigation, Assertions assertions) {
        super(tester, environmentData, 2);
        this.xmlBackupCopier = new XmlBackupCopier(environmentData.getBaseUrl());
        this.navigation = navigation;
        this.asynchronousTasks = new AsynchronousTasks(tester, environmentData, 2);
        this.text = assertions.getTextAssertions();
        this.generalConfiguration = new GeneralConfigurationImpl(tester, environmentData);
        this.project = new ProjectImpl(tester, environmentData, navigation, assertions, this.asynchronousTasks);
        this.usersAndGroups = new UsersAndGroupsImpl(tester, environmentData, assertions.getTextAssertions(), 3);
        this.roles = new RolesImpl(tester, environmentData, 3);
        this.customFields = new CustomFieldsImpl(tester, environmentData, navigation, this.getFuncTestHelperFactory().getForm());
        this.permissionSchemes = new PermissionSchemesImpl(tester, environmentData);
        this.issueSecuritySchemes = new IssueSecuritySchemesImpl(tester, environmentData);
        this.fieldConfigurations = new FieldConfigurationsImpl(tester, environmentData);
        this.fieldConfigurationSchemes = new FieldConfigurationSchemesImpl(tester, environmentData);
        this.resolutions = new ResolutionsImpl(tester, environmentData);
        this.viewServices = new ViewServices(tester, navigation);
        this.cvsModules = new CvsModulesImpl(tester, environmentData, navigation, assertions);
        this.projectImport = new ProjectImportImpl(tester, environmentData, navigation, this);
        this.attachments = new AttachmentsImpl(tester, environmentData, navigation);
        this.viewFieldScreens = new ViewFieldScreensImpl(tester, environmentData, navigation);
        this.workflows = new ViewWorkflowsImpl(tester, environmentData, this.childLogIndentLevel(), navigation);
        this.workflowSchemes = new WorkflowSchemesImpl(tester, environmentData, this.childLogIndentLevel());
        this.plugins = new PluginsImpl(tester, environmentData, this.logIndentLevel, navigation);
    }

    @Override
    public void reIndex() {
        this.tester.gotoPage("secure/admin/jira/IndexAdmin.jspa");
        this.navigation.checkWebSudoWithLastPassword();
        this.tester.submit("Re-Index");
        this.waitForIndexCompletion(1000L, 100);
    }

    @Override
    public void setProfiling(boolean on) {
    }

    @Override
    public void restoreBlankInstance() {
        this.restoreData("blankprojects.xml");
    }

    @Override
    public void restoreNotSetupInstance() {
        File file = new File(this.environmentData.getXMLDataLocation(), "TestEmpty.xml");
        this.copyFileToJiraImportDirectory(file);
        this.tester.gotoPage("secure/admin/XmlRestore!default.jspa");
        this.navigation.checkWebSudoWithLastPassword();
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.setFormElement("filename", file.getName());
        this.tester.checkCheckbox("quickImport", "true");
        this.tester.submit();
        this.tester.assertTextPresent("Your project has been successfully imported");
    }

    private void copyFileToJiraImportDirectory(File file) {
        File jiraImportDirectory = new File(this.getJiraHomeDirectory(), IMPORT_DIR);
        try {
            FileUtils.copyFileToDirectory((File)file, (File)jiraImportDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not copy file " + file.getAbsolutePath() + " to the import directory in jira home " + jiraImportDirectory, e);
        }
    }

    @Override
    public File replaceTokensInFile(String originalXmlFileName, Map<String, String> replacements) throws IOException {
        String resource = this.environmentData.getXMLDataLocation().getAbsolutePath() + "/" + originalXmlFileName;
        String xml = IOUtils.toString((Reader)new FileReader(resource));
        xml = this.replaceTokens(xml, replacements);
        File newData = File.createTempFile(originalXmlFileName, ".xml");
        FileWriter of = new FileWriter(newData);
        of.write(xml);
        of.close();
        return newData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreDataWithReplacedTokens(String originalXmlFileName, Map<String, String> replacements) throws IOException {
        String resource = this.environmentData.getXMLDataLocation().getAbsolutePath() + "/" + originalXmlFileName;
        String xml = IOUtils.toString((Reader)new FileReader(resource));
        xml = this.replaceTokens(xml, replacements);
        File newData = null;
        try {
            newData = this.replaceTokensInFile(originalXmlFileName, replacements);
            this.restoreData(newData.getParent(), newData.getName());
        }
        finally {
            if (newData.exists()) assert (newData.delete());
        }
    }

    @Override
    public void restoreData(String fileName) {
        this.restoreData(this.environmentData.getXMLDataLocation().getAbsolutePath(), fileName);
    }

    @Override
    public void restoreDataAndLogin(String fileName, String username) {
        this.restoreData(this.environmentData.getXMLDataLocation().getAbsolutePath(), fileName, true, username, username);
    }

    @Override
    public void restoreDataSlowOldWay(String fileName) {
        this.restoreDataSlowOldWay(this.environmentData.getXMLDataLocation().getAbsolutePath(), fileName);
    }

    public void restoreData(String path, String fileName) {
        this.restoreData(path, fileName, true, "admin", "admin");
    }

    @Override
    public void restoreDataSlowOldWay(String path, String fileName) {
        this.restoreData(path, fileName, false, "admin", "admin");
    }

    private void restoreData(String path, String fileName, boolean clearCache, String username, String password) {
        this.navigation.gotoAdminSection("system_info");
        this.navigation.checkWebSudoWithLastPassword();
        FuncTestTimer timer = TestInformationKit.pullTimer("XML Restore");
        String sourcePath = path + FS + fileName;
        String jiraImportDir = this.getJiraHomeDirectory() + FS + IMPORT_DIR + FS + new File(fileName).getName();
        boolean baseUrlReplaced = this.xmlBackupCopier.copyXmlBackupTo(sourcePath, jiraImportDir);
        this.log("Restoring data '" + jiraImportDir + "'");
        this.tester.gotoPage("secure/admin/XmlRestore!default.jspa");
        this.navigation.checkWebSudoWithLastPassword();
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("filename", fileName);
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        if (clearCache) {
            this.tester.checkCheckbox("quickImport", "true");
        }
        this.tester.submit();
        if (!this.isRestoreSuccessful()) {
            this.assertCauseOfError("The xml data you are trying to import seems to be from a newer version of JIRA. This will not work.", jiraImportDir);
            this.assertCauseOfError("You must enter the location of an XML file.", jiraImportDir);
            this.assertCauseOfError("Could not find file at this location.", jiraImportDir);
            this.assertCauseOfError("Invalid license key specified.", jiraImportDir);
            this.assertCauseOfError("The current license is too old to install this version of JIRA", jiraImportDir);
            this.assertCauseOfError("Invalid license type for this version of JIRA. License should be of type Standard.", jiraImportDir);
            this.assertCauseOfError("Invalid license type for this version of JIRA. License should be of type Professional.", jiraImportDir);
            this.assertCauseOfError("Invalid license type for this version of JIRA. License should be of type Enterprise.", jiraImportDir);
            this.assertCauseOfError("You must specify an index for the restore process.", jiraImportDir);
            this.assertCauseOfError("Error parsing export file. Your export file is invalid.", jiraImportDir);
            this.assertCauseOfError("There is a problem with one or more of your file paths", jiraImportDir);
            throw new AssertionError((Object)("Failed to restore JIRA data from [" + jiraImportDir + "]. See logs for details."));
        }
        long howLong = timer.end();
        this.navigation.login(username, password);
        this.log("Restored '" + fileName + "' in " + howLong + "ms");
        if (!baseUrlReplaced) {
            this.generalConfiguration.setBaseUrl(this.getEnvironmentData().getBaseUrl().toString());
        }
        this.tester.beginAt("/");
    }

    @Override
    public void restoreI18nData(String fileName) {
        FuncTestTimer timer = TestInformationKit.pullTimer("XML Restore");
        String filePath = this.environmentData.getXMLDataLocation().getAbsolutePath() + "/" + fileName;
        File file = new File(filePath);
        this.copyFileToJiraImportDirectory(file);
        this.log("Restoring data '" + filePath + "'");
        this.tester.gotoPage("secure/admin/XmlRestore!default.jspa");
        this.navigation.checkWebSudoWithLastPassword();
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("filename", file.getName());
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.checkCheckbox("quickImport", "true");
        this.tester.submit();
        if (!this.isRestoreSuccessful()) {
            Assert.fail((String)"Your project failed to import successfully. See logs for details");
        }
        long howLong = timer.end();
        this.navigation.login("admin", "admin");
        this.log("Restored '" + fileName + "' in " + howLong + "ms");
    }

    @Override
    public void restoreDataWithLicense(String fileName, String licenseKey) {
        FuncTestTimer timer = TestInformationKit.pullTimer("XML Restore");
        String sourcePath = this.environmentData.getXMLDataLocation().getAbsolutePath() + FS + fileName;
        String filePath = this.getJiraHomeDirectory() + FS + IMPORT_DIR + FS + new File(fileName).getName();
        boolean baseUrlReplaced = this.xmlBackupCopier.copyXmlBackupTo(sourcePath, filePath);
        this.log("Restoring data '" + filePath + "'");
        this.tester.gotoPage("secure/admin/XmlRestore!default.jspa");
        this.navigation.checkWebSudoWithLastPassword();
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("filename", fileName);
        this.tester.setFormElement("license", licenseKey);
        this.tester.checkCheckbox("quickImport", "true");
        this.tester.submit();
        this.tester.assertTextPresent("Your project has been successfully imported");
        long howLong = timer.end();
        this.navigation.login("admin", "admin");
        this.log("Restored '" + fileName + "' in " + howLong + "ms");
        if (!baseUrlReplaced) {
            this.generalConfiguration.setBaseUrl(this.getEnvironmentData().getBaseUrl().toString());
        }
        this.tester.beginAt("/");
    }

    @Override
    public File exportDataToFile(String fileName) {
        return this.exportDataToFile(fileName, false);
    }

    @Override
    public File exportDataToFile(String fileName, boolean zip) {
        String text;
        FuncTestTimer timer = TestInformationKit.pullTimer("XML Export");
        String realFileName = FilenameUtils.getName((String)fileName);
        this.log("Backing up data to '" + realFileName + "'");
        this.tester.gotoPage("secure/admin/XmlBackup!default.jspa");
        this.navigation.checkWebSudoWithLastPassword();
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("filename", realFileName);
        if (zip) {
            this.tester.checkCheckbox("useZip", "true");
        } else {
            this.tester.uncheckCheckbox("useZip");
        }
        this.tester.submit();
        if (new IdLocator(this.tester, "replace_submit").exists()) {
            this.tester.setWorkingForm("jiraform");
            this.tester.submit();
        }
        if ((text = StringUtils.stripToNull((String)new IdLocator(this.tester, "backup-file").getText())) == null) {
            Assert.fail((String)"The restore did not redirect to the result page.");
        }
        timer.end();
        File file = new File(text);
        Assert.assertTrue((String)("Backup returned '" + text + "' which is not an absolute file."), (boolean)file.isAbsolute());
        return file;
    }

    @Override
    public String getCurrentAttachmentPath() {
        this.navigation.gotoAdmin();
        this.tester.clickLink("attachments");
        this.navigation.checkWebSudoWithLastPassword();
        WebTable attachmentSettings = this.tester.getDialog().getWebTableBySummaryOrId("attachmentSettings");
        if ("Attachment Path".equals(attachmentSettings.getCellAsText(2, 0).trim())) {
            String attachmentPath = attachmentSettings.getCellAsText(2, 1).trim();
            if (attachmentPath.startsWith("Default Directory [")) {
                attachmentPath = attachmentPath.substring("Default Directory [".length(), attachmentPath.length() - 1);
            }
            return attachmentPath;
        }
        throw new RuntimeException("Error occured when trying to screen-scrape the attachment path. 'Attachment Path' not found where expected in the table.");
    }

    @Override
    public void activateSubTasks() {
        this.log("activating sub tasks");
        this.tester.gotoPage("/secure/admin/subtasks/ManageSubTasks.jspa");
        this.navigation.checkWebSudoWithLastPassword();
        if (this.tester.getDialog().isLinkPresentWithText("Enable")) {
            this.tester.clickLinkWithText("Enable");
        } else {
            this.log("Subtasks already enabled");
        }
    }

    @Override
    public void addSubTaskType(String name) {
        this.activateSubTasks();
        this.tester.setFormElement("name", name);
        this.tester.submit("Add");
    }

    @Override
    public void enableTrackBacks() {
        this.tester.gotoPage(PAGE_TRACKBACKS);
        this.navigation.checkWebSudoWithLastPassword();
        this.tester.checkCheckbox("acceptPings", "true");
        this.tester.checkCheckbox("sendPings", "allIssues");
        this.tester.submit("Update");
    }

    @Override
    public GeneralConfiguration generalConfiguration() {
        return this.generalConfiguration;
    }

    @Override
    public CvsModules cvsModules() {
        return this.cvsModules;
    }

    @Override
    public Project project() {
        return this.project;
    }

    @Override
    public UsersAndGroups usersAndGroups() {
        return this.usersAndGroups;
    }

    @Override
    public Roles roles() {
        return this.roles;
    }

    @Override
    public CustomFields customFields() {
        return this.customFields;
    }

    @Override
    public PermissionSchemes permissionSchemes() {
        return this.permissionSchemes;
    }

    @Override
    public IssueSecuritySchemes issueSecuritySchemes() {
        return this.issueSecuritySchemes;
    }

    @Override
    public FieldConfigurations fieldConfigurations() {
        return this.fieldConfigurations;
    }

    @Override
    public FieldConfigurationSchemes fieldConfigurationSchemes() {
        return this.fieldConfigurationSchemes;
    }

    @Override
    public ProjectImport projectImport() {
        return this.projectImport;
    }

    @Override
    public Plugins plugins() {
        return this.plugins;
    }

    @Override
    public void removeGlobalPermission(int permission, String group) {
        HtmlPage page = new HtmlPage(this.tester);
        String deleteUrl = page.addXsrfToken("secure/admin/jira/GlobalPermissions.jspa?groupName=" + group + "&permType=" + permission + "&action=confirm");
        this.tester.gotoPage(deleteUrl);
        this.navigation.checkWebSudoWithLastPassword();
        this.tester.assertTextPresent("Delete Global Permission");
        this.tester.submit("Delete");
    }

    @Override
    public void addGlobalPermission(int permission, String group) {
        HtmlPage page = new HtmlPage(this.tester);
        String addUrl = page.addXsrfToken("secure/admin/jira/GlobalPermissions.jspa?groupName=" + group + "&permType=" + permission + "&action=add");
        this.tester.gotoPage(addUrl);
        this.navigation.checkWebSudoWithLastPassword();
    }

    @Override
    public void switchToLicense(LicenseKeys.License license) {
        this.switchToLicense(license.getLicenseString(), license.getDescription());
    }

    @Override
    public void switchToLicense(String license, String description) {
        this.navigation.gotoAdminSection("license_details");
        this.tester.setFormElement("license", license);
        this.tester.submit("Add");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//table[@id='license_table']"), description);
    }

    @Override
    public void switchToPersonalLicense() {
        this.switchToLicense(LicenseKeys.V2_PERSONAL.getLicenseString(), "JIRA " + this.getEdition() + ": Personal");
    }

    @Override
    public void switchToStarterLicense() {
        this.switchToLicense(LicenseKeys.V2_STARTER.getLicenseString(), "JIRA " + this.getEdition() + ": Starter");
    }

    @Override
    public String getJiraHomeDirectory() {
        String jiraHome = JIRA_HOME_DIR.get();
        if (jiraHome == null) {
            WebTable filePathTable;
            this.navigation.gotoAdminSection("system_info");
            try {
                filePathTable = this.tester.getDialog().getResponse().getTableWithID("file_paths");
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            if (filePathTable != null && filePathTable.getTableCell(1, 1) != null) {
                jiraHome = filePathTable.getTableCell(1, 1).asText().trim();
                JIRA_HOME_DIR.set(jiraHome);
            }
        }
        return jiraHome;
    }

    @Override
    public String getSystemTenantHomeDirectory() {
        WebTable filePathTable;
        this.navigation.gotoAdminSection("system_info");
        try {
            filePathTable = this.tester.getDialog().getResponse().getTableWithID("file_paths");
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        if (filePathTable != null && filePathTable.getTableCell(1, 1) != null) {
            return filePathTable.getTableCell(1, 1).asText().trim();
        }
        return null;
    }

    private void assertCauseOfError(String errorMessage, String filePath) {
        if (this.tester.getDialog().isTextInResponse(errorMessage)) {
            throw new AssertionError((Object)("Failed to restore JIRA data. Cause: " + errorMessage + " File path: [" + filePath + "]"));
        }
    }

    @Override
    public Subtasks subtasks() {
        return new SubtasksImpl(this.tester, this.getEnvironmentData());
    }

    @Override
    public IssueLinking issueLinking() {
        return new IssueLinkingImpl(this.tester, this.getEnvironmentData());
    }

    @Override
    public TimeTracking timeTracking() {
        return new TimeTrackingImpl(this.tester, this.getEnvironmentData());
    }

    @Override
    public Resolutions resolutions() {
        return this.resolutions;
    }

    @Override
    public ViewServices services() {
        return this.viewServices;
    }

    @Override
    public String getEdition() {
        return "Enterprise";
    }

    @Override
    public long getBuildNumber() {
        IdLocator idLocator = new IdLocator(this.tester, "footer-build-information");
        String buildInfo = idLocator.getText();
        if (StringUtils.isBlank((String)buildInfo)) {
            throw new RuntimeException("Unable to find build information in the footer.");
        }
        Matcher matcher = PATTERN_BUILD_NUMBER.matcher(buildInfo);
        if (!matcher.find()) {
            throw new RuntimeException("Unable to find build number from the footer.");
        }
        try {
            return Long.parseLong(matcher.group(1));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Unable to find builder number from the footer.", e);
        }
    }

    private String replaceTokens(String source, Map<String, String> replacements) {
        for (String token : replacements.keySet()) {
            int index = source.indexOf(token);
            if (index < 0) {
                Assert.fail((String)("Replacement token '" + token + "' not found"));
            }
            source = source.replaceAll(token, Matcher.quoteReplacement(replacements.get(token)));
        }
        return source;
    }

    @Override
    public void runJellyScript(String script) {
        this.log("Running jelly script '" + script + "'.");
        this.navigation.gotoAdminSection("jelly_runner");
        this.tester.setFormElement("script", script);
        this.tester.submit("Run now");
    }

    @Override
    public void enableAccessLogging() {
        this.log("enabling access logging");
        this.navigation.gotoAdminSection("logging_profiling");
        this.tester.clickLink("enable_http_access");
    }

    @Override
    public Attachments attachments() {
        return this.attachments;
    }

    @Override
    public ViewFieldScreens viewFieldScreens() {
        return this.viewFieldScreens;
    }

    @Override
    public Administration.Utilities utilities() {
        return new Util();
    }

    @Override
    public ViewWorkflows workflows() {
        return this.workflows;
    }

    @Override
    public WorkflowSchemes workflowSchemes() {
        return this.workflowSchemes;
    }

    private void waitForIndexCompletion(long sleepTime, int retryCount) {
        this.asynchronousTasks.waitForSuccessfulCompletion(sleepTime, retryCount, "Indexing");
    }

    private boolean isRestoreSuccessful() {
        return this.isOnRestore() && new XPathLocator(this.tester, "//a[@id=\"login\"]").exists();
    }

    private boolean isOnRestore() {
        return this.tester.getDialog().getResponse().getURL().toExternalForm().contains("XmlRestore.jspa");
    }

    private class Util
    implements Administration.Utilities {
        private Util() {
        }

        @Override
        public void runServiceNow(long serviceId) {
            AdministrationImpl.this.navigation.gotoPage("ServiceExecutor.jspa");
            AdministrationImpl.this.navigation.checkWebSudoWithLastPassword();
            AdministrationImpl.this.tester.setFormElement("serviceId", String.valueOf(serviceId));
            AdministrationImpl.this.tester.submit();
            AdministrationImpl.this.tester.assertTextNotPresent("No service with this id exists");
        }
    }
}

