/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config;

import com.atlassian.jira.functest.config.ConfigAdminLocator;
import com.atlassian.jira.functest.config.ConfigSequence;
import com.atlassian.jira.functest.config.DefaultConfigSequence;
import com.atlassian.jira.functest.config.dashboard.ConfigDashboard;
import com.atlassian.jira.functest.config.dashboard.ConfigDashboardManager;
import com.atlassian.jira.functest.config.dashboard.ConfigExternalGadget;
import com.atlassian.jira.functest.config.dashboard.ConfigGadgetManager;
import com.atlassian.jira.functest.config.dashboard.DefaultConfigDashboardManager;
import com.atlassian.jira.functest.config.dashboard.DefaultConfigGadgetManager;
import com.atlassian.jira.functest.config.mail.ConfigMailServer;
import com.atlassian.jira.functest.config.mail.ConfigMailServerManager;
import com.atlassian.jira.functest.config.mail.DefaultConfigMailServerManager;
import com.atlassian.jira.functest.config.ps.ConfigPropertySet;
import com.atlassian.jira.functest.config.ps.ConfigPropertySetManager;
import com.atlassian.jira.functest.config.ps.DefaultConfigPropertySetManager;
import com.atlassian.jira.functest.config.service.ConfigService;
import com.atlassian.jira.functest.config.service.ConfigServiceManager;
import com.atlassian.jira.functest.config.service.DefaultConfigServiceManager;
import com.atlassian.jira.functest.config.sharing.DefaultConfigSharedEntityCleaner;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;

public class JiraConfig {
    private static final String APP_PROPS_NAME = "jira.properties";
    private static final long APP_PROPS_ID = 1L;
    private static final String ROOT_ELEMENT = "entity-engine-xml";
    private static final String KEY_BUILD_NUMBER = "jira.version.patched";
    private final Document document;
    private final File file;
    private final ConfigMailServerManager mailServerManager;
    private final ConfigPropertySetManager propertySetManager;
    private final ConfigServiceManager serviceManager;
    private final ConfigSequence configSequence;
    private final ConfigDashboardManager dashboardManager;
    private final ConfigGadgetManager gadgetManager;
    private final ConfigAdminLocator adminLocator;
    private ConfigPropertySet applicationProperties;
    private List<ConfigService> services;
    private List<ConfigMailServer> mailServers;
    private List<ConfigDashboard> dashboards;
    private List<ConfigExternalGadget> externalGadgets;
    private Set<String> admins;

    public JiraConfig(Document document, File file) {
        if (!JiraConfig.isJiraXml(document)) {
            throw new IllegalArgumentException("The passed document does not seem to contain JIRA backup XML data.");
        }
        this.document = document;
        this.file = file;
        this.configSequence = new DefaultConfigSequence(document);
        this.mailServerManager = new DefaultConfigMailServerManager(document);
        this.propertySetManager = new DefaultConfigPropertySetManager(document, this.configSequence);
        this.serviceManager = new DefaultConfigServiceManager(document, this.propertySetManager, this.configSequence);
        this.gadgetManager = new DefaultConfigGadgetManager(document);
        this.dashboardManager = new DefaultConfigDashboardManager(document, this.gadgetManager, new DefaultConfigSharedEntityCleaner(document));
        this.adminLocator = new ConfigAdminLocator(document);
    }

    public JiraConfig(Document document, File file, ConfigSequence configSequence, ConfigMailServerManager configMailServerManager, ConfigPropertySetManager configPropertySetManager, ConfigServiceManager configServiceManager, ConfigDashboardManager dashboardManager, ConfigGadgetManager gadgetManager, ConfigAdminLocator adminLocator) {
        if (!JiraConfig.isJiraXml(document)) {
            throw new IllegalArgumentException("The passed document does not seem to contain JIRA backup XML data.");
        }
        this.document = document;
        this.file = file;
        this.configSequence = configSequence;
        this.mailServerManager = configMailServerManager;
        this.propertySetManager = configPropertySetManager;
        this.serviceManager = configServiceManager;
        this.gadgetManager = gadgetManager;
        this.dashboardManager = dashboardManager;
        this.adminLocator = adminLocator;
    }

    public JiraConfig() {
        this(JiraConfig.createEmptyDocument(), null);
    }

    public long getBuildNumber() {
        return this.getApplicationProperties().getLongPropertyDefault(KEY_BUILD_NUMBER, 0L);
    }

    public JiraConfig setApplicationProperties(ConfigPropertySet applicationProperties) {
        this.applicationProperties = applicationProperties;
        return this;
    }

    public Set<String> getSystemAdmins() {
        if (this.admins == null) {
            this.admins = this.adminLocator.locateSystemAdmins();
        }
        return this.admins;
    }

    public ConfigPropertySet getApplicationProperties() {
        if (this.applicationProperties == null) {
            this.applicationProperties = this.propertySetManager.loadPropertySet(APP_PROPS_NAME, 1L);
        }
        return this.applicationProperties;
    }

    public List<ConfigService> getServices() {
        if (this.services == null) {
            this.services = JiraConfig.copy(this.serviceManager.loadServices());
        }
        return this.services;
    }

    public JiraConfig setServices(List<ConfigService> services) {
        this.services = services;
        return this;
    }

    public List<ConfigMailServer> getMailServers() {
        if (this.mailServers == null) {
            this.mailServers = JiraConfig.copy(this.mailServerManager.loadServers());
        }
        return this.mailServers;
    }

    public JiraConfig setMailServers(List<ConfigMailServer> mailServers) {
        this.mailServers = mailServers;
        return this;
    }

    public List<ConfigDashboard> getDashboards() {
        if (this.dashboards == null) {
            this.dashboards = JiraConfig.copy(this.dashboardManager.loadDashboards());
        }
        return this.dashboards;
    }

    public JiraConfig setDashboards(List<ConfigDashboard> dashboards) {
        this.dashboards = dashboards;
        return this;
    }

    public List<ConfigExternalGadget> getExternalGadgets() {
        if (this.externalGadgets == null) {
            this.externalGadgets = JiraConfig.copy(this.gadgetManager.loadExternalGadgets());
        }
        return this.externalGadgets;
    }

    public JiraConfig setExternalGadgets(List<ConfigExternalGadget> externalGadgets) {
        this.externalGadgets = externalGadgets;
        return this;
    }

    public boolean save() {
        boolean returnValue = false;
        if (this.applicationProperties != null) {
            returnValue = this.propertySetManager.savePropertySet(this.applicationProperties.copyForEntity(APP_PROPS_NAME, 1L));
        }
        if (this.services != null) {
            returnValue = this.serviceManager.saveServices(this.services) | returnValue;
        }
        if (this.mailServers != null) {
            returnValue = this.mailServerManager.saveServers(this.mailServers) | returnValue;
        }
        if (this.dashboards != null) {
            returnValue = this.dashboardManager.saveDashboards(this.dashboards) | returnValue;
        }
        if (this.externalGadgets != null) {
            returnValue = this.gadgetManager.saveExternalGadgets(this.externalGadgets) | returnValue;
        }
        return this.configSequence.save() | returnValue;
    }

    public Document getDocument() {
        return this.document;
    }

    public File getFile() {
        return this.file;
    }

    public static boolean isJiraXml(Document document) {
        if (document == null) {
            return false;
        }
        Element rootElem = document.getRootElement();
        return rootElem != null && ROOT_ELEMENT.equalsIgnoreCase(rootElem.getName());
    }

    private static Document createEmptyDocument() {
        DocumentFactory instance = DocumentFactory.getInstance();
        Document rootDoc = instance.createDocument();
        rootDoc.setRootElement(instance.createElement(ROOT_ELEMENT));
        return rootDoc;
    }

    private static <T> List<T> copy(Collection<? extends T> source) {
        if (source == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(source);
    }
}

