/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config;

import com.atlassian.jira.functest.config.AttachmentDirectoryChecker;
import com.atlassian.jira.functest.config.BackupChecker;
import com.atlassian.jira.functest.config.ConfigurationCheck;
import com.atlassian.jira.functest.config.IndexDirectoryChecker;
import com.atlassian.jira.functest.config.dashboard.DashboardConfigurationCheck;
import com.atlassian.jira.functest.config.mail.MailChecker;
import com.atlassian.jira.webtests.util.LocalTestEnvironmentData;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.DelegateFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;

public final class ConfigurationDefaults {
    private ConfigurationDefaults() {
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Why are you calling me? I'm static.");
    }

    public static File getDefaultXmlDataLocation() {
        LocalTestEnvironmentData environmentData = new LocalTestEnvironmentData();
        File xmlDataLocation = environmentData.getXMLDataLocation();
        if (xmlDataLocation == null) {
            throw new RuntimeException("Func Test XML directory has not been configured.");
        }
        if (!xmlDataLocation.exists()) {
            throw new RuntimeException(String.format("Func Test XML directory '%s' does not exist.", xmlDataLocation));
        }
        return xmlDataLocation;
    }

    public static List<IOFileFilter> getDefaultExcludedFilters() {
        ArrayList<IOFileFilter> files = new ArrayList<IOFileFilter>();
        files.add(ConfigurationDefaults.createNameFilter("TestXmlIssueView-HSP-1-no-issue-links.xml"));
        files.add(ConfigurationDefaults.createNameFilter("TestXmlIssueView-HSP-1-no-timetracking.xml"));
        files.add(ConfigurationDefaults.createNameFilter("TestXmlIssueView-HSP-1-due-date-hidden.xml"));
        files.add(ConfigurationDefaults.createNameFilter("TestXmlIssueView-HSP-1.xml"));
        files.add(ConfigurationDefaults.createNameFilter("TestXmlIssueView-HSP-1-no-subtasks.xml"));
        files.add(ConfigurationDefaults.createNameFilter("TestXmlIssueView-HSP-1-no-custom-fields.xml"));
        files.add(ConfigurationDefaults.createNameFilter("check-cache.xml"));
        files.add(ConfigurationDefaults.createNameFilter("fixerBroken.zip"));
        files.add(ConfigurationDefaults.createParentFilter("TestDownloadZipAttachmentEntries/attachments"));
        files.add(ConfigurationDefaults.createParentFilter("TestAttachmentsBlockSortingOnViewIssue/attachments"));
        files.add(ConfigurationDefaults.createParentFilter("TestBrowseZipAttachmentEntries/attachments"));
        files.add(ConfigurationDefaults.createNameFilter("TestEmptyStringDataRestore_out.xml"));
        return files;
    }

    public static List<ConfigurationCheck> createDefaultConfigurationChecks() {
        ArrayList<ConfigurationCheck> checkers = new ArrayList<ConfigurationCheck>();
        checkers.add(new AttachmentDirectoryChecker());
        checkers.add(new IndexDirectoryChecker());
        checkers.add(new BackupChecker());
        checkers.add(new MailChecker());
        checkers.add(new DashboardConfigurationCheck());
        return checkers;
    }

    private static IOFileFilter createNameFilter(String name) {
        return new NameFileFilter(name, IOCase.INSENSITIVE);
    }

    private static IOFileFilter createParentFilter(String name) {
        String s = Pattern.quote(FilenameUtils.separatorsToSystem((String)name));
        return new DelegateFileFilter((FileFilter)new RegexPathFilter(s));
    }

    private static class RegexPathFilter
    implements FileFilter {
        private final Pattern patten;

        public RegexPathFilter(String patten) {
            this.patten = Pattern.compile(patten, 2);
        }

        @Override
        public boolean accept(File pathname) {
            return this.patten.matcher(pathname.getPath()).find();
        }
    }
}

