/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.FuncTestCase;

public class TestCustomWorkflowScreenLocalization
extends FuncTestCase {
    public void setUpTest() {
        this.administration.restoreData("TestCustomWorkflowScreenLocalization.xml");
    }

    public void testSubmitButtonLabelIsTransitionName() {
        this.navigation.issue().viewIssue("HMS-1");
        this.tester.clickLink("action_id_11");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.assertions.assertSubmitButtonPresentWithText("issue-workflow-transition-submit", "Resolve");
    }

    public void testSubmitButtonLabelIsLocalized() {
        this.createWorkflowDraft("Workflow2");
        this.gotoWorkflowDraftSteps("Workflow2");
        this.tester.clickLinkWithText("Resolve");
        this.tester.clickLink("view_transition_properties");
        this.tester.setFormElement("attributeKey", "jira.i18n.submit");
        this.tester.setFormElement("attributeValue", "resolveissue.title");
        this.tester.submit();
        this.tester.assertTextPresent("jira.i18n.submit");
        this.tester.assertTextPresent("resolveissue.title");
        this.publishWorkflowDraft("Workflow2");
        this.navigation.issue().viewIssue("HMS-1");
        this.tester.clickLink("action_id_11");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.assertions.assertSubmitButtonPresentWithText("issue-workflow-transition-submit", "Resolve Issue");
    }

    public void testFallBackToTransitionName() {
        this.createWorkflowDraft("Workflow2");
        this.gotoWorkflowDraftSteps("Workflow2");
        this.tester.clickLinkWithText("Resolve");
        this.tester.clickLink("view_transition_properties");
        this.tester.setFormElement("attributeKey", "jira.i18n.submit");
        this.tester.setFormElement("attributeValue", "blah.doesnt.exist");
        this.tester.submit();
        this.tester.assertTextPresent("jira.i18n.submit");
        this.tester.assertTextPresent("blah.doesnt.exist");
        this.publishWorkflowDraft("Workflow2");
        this.navigation.issue().viewIssue("HMS-1");
        this.tester.clickLink("action_id_11");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.assertions.assertSubmitButtonPresentWithText("issue-workflow-transition-submit", "Resolve");
    }

    public void testTransitionNameTitle() {
        this.navigation.issue().viewIssue("HMS-1");
        this.tester.clickLink("action_id_11");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.assertions.assertSubmitButtonPresentWithText("issue-workflow-transition-submit", "Resolve");
        this.tester.assertTitleEquals("Resolve [HMS-1] - Your Company JIRA ");
    }

    public void testLocalizedTitle() {
        this.createWorkflowDraft("Workflow2");
        this.gotoWorkflowDraftSteps("Workflow2");
        this.tester.clickLinkWithText("Resolve");
        this.tester.clickLink("view_transition_properties");
        this.tester.setFormElement("attributeKey", "jira.i18n.title");
        this.tester.setFormElement("attributeValue", "resolveissue.title");
        this.tester.submit();
        this.tester.assertTextPresent("jira.i18n.title");
        this.tester.assertTextPresent("resolveissue.title");
        this.publishWorkflowDraft("Workflow2");
        this.navigation.issue().viewIssue("HMS-1");
        this.tester.clickLink("action_id_11");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.assertions.assertSubmitButtonPresentWithText("issue-workflow-transition-submit", "Resolve");
        this.tester.assertTitleEquals("Resolve Issue [HMS-1] - Your Company JIRA ");
    }

    public void testFixedDescription() {
        this.createWorkflowDraft("Workflow2");
        this.gotoWorkflowDraftSteps("Workflow2");
        this.tester.clickLinkWithText("Resolve");
        this.tester.clickLink("view_transition_properties");
        this.tester.setFormElement("attributeKey", "description");
        this.tester.setFormElement("attributeValue", "My Special description");
        this.tester.submit();
        this.tester.assertTextPresent("description");
        this.tester.assertTextPresent("My Special description");
        this.publishWorkflowDraft("Workflow2");
        this.navigation.issue().viewIssue("HMS-1");
        this.tester.clickLink("action_id_11");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.assertions.assertSubmitButtonPresentWithText("issue-workflow-transition-submit", "Resolve");
        this.tester.assertTextPresent("My Special description");
    }

    public void publishWorkflowDraft(String workflowName) {
        this.gotoWorkflowDraftSteps(workflowName);
        this.tester.clickLink("publish_draft_workflow");
        this.tester.checkCheckbox("enableBackup", "false");
        this.tester.submit();
    }

    public void createWorkflowDraft(String workflowName) {
        this.navigation.gotoWorkflows();
        this.tester.assertLinkPresentWithText("Create Draft");
        this.tester.assertLinkPresent("createDraft_" + workflowName);
        this.tester.clickLink("createDraft_" + workflowName);
    }

    public void gotoWorkflowDraftSteps(String workflowName) {
        this.navigation.gotoWorkflows();
        this.tester.clickLink("steps_draft_" + workflowName);
    }
}

