/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestAddWorkflowTransition
extends JIRAWebTest {
    private static final String WORKFLOW_NAME = "Test Workflow";
    private static final String STEP_NAME_OPEN = "Open";
    private static final String STEP_NAME_AND = "SpecialChar&";
    private static final String STEP_NAME_LESSTHAN = "SpecialChar<";
    private static final String STEP_NAME_QUOTE = "SpecialChar\"";
    private static final String TRANSITION_NAME_AND = "To&";
    private static final String TRANSITION_NAME_LESSTHAN = "To<";
    private static final String TRANSITION_NAME_QUOTE = "To\"";

    public TestAddWorkflowTransition(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestAddWorkflowTransition.xml");
    }

    public void tearDown() {
        super.tearDown();
    }

    public void testAddWorkflowTransitionSpecialCharacters() {
        this.addStep(WORKFLOW_NAME, STEP_NAME_AND, null);
        this.addStep(WORKFLOW_NAME, STEP_NAME_LESSTHAN, null);
        this.addStep(WORKFLOW_NAME, STEP_NAME_QUOTE, null);
        this.addTransition(WORKFLOW_NAME, STEP_NAME_OPEN, TRANSITION_NAME_AND, null, STEP_NAME_AND, null);
        this.addTransition(WORKFLOW_NAME, STEP_NAME_AND, TRANSITION_NAME_LESSTHAN, null, STEP_NAME_LESSTHAN, null);
        this.addTransition(WORKFLOW_NAME, STEP_NAME_LESSTHAN, TRANSITION_NAME_QUOTE, null, STEP_NAME_QUOTE, null);
        this.addWorkFlowScheme("New Workflow Scheme", "Test workflow scheme.");
        this.assignWorkflowScheme("New Workflow Scheme", "Bug", WORKFLOW_NAME);
        this.associateWorkFlowSchemeToProject("homosapien", "New Workflow Scheme");
        this.waitForSuccessfulWorkflowSchemeMigration("homosapien", WORKFLOW_NAME);
        this.addIssue("homosapien", "HSP", "Bug", "Test Special Characters");
        this.clickLinkWithText(TRANSITION_NAME_AND);
        this.clickLinkWithText(TRANSITION_NAME_LESSTHAN);
        this.clickLinkWithText(TRANSITION_NAME_QUOTE);
        this.assertTextPresentBeforeText("Status", "Resolved");
    }
}

