/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearch;
import com.atlassian.jira.functest.framework.sharing.GroupTestSharingPermission;
import java.util.Collections;

public class TestViewGroup
extends FuncTestCase {
    public static final int CREATE_SHARED_FILTER = 22;
    private static final String TEST_GROUP = "test_group";

    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }

    public void testGroupSharedFiltersReported() {
        this.gotoViewGroup("jira-users");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//td[@class='jiraformbody']"), "There are no Saved Filters associated with this Group.");
        this.administration.addGlobalPermission(22, "jira-users");
        this.navigation.issueNavigator().createSearch(new NavigatorSearch(Collections.EMPTY_LIST));
        long adminId = this.navigation.issueNavigator().saveCurrentAsNewFilter("AdministratorFilter", "AdministratorFilter description", true, Collections.singleton(new GroupTestSharingPermission("jira-users")));
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issueNavigator().createSearch(new NavigatorSearch(Collections.EMPTY_LIST));
        long fredId = this.navigation.issueNavigator().saveCurrentAsNewFilter("FredFilter", null, true, Collections.singleton(new GroupTestSharingPermission("jira-users")));
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.gotoViewGroup("jira-users");
        XPathLocator pathLocator = new XPathLocator(this.tester, "//td[@class='jiraformbody']");
        this.text.assertTextPresent(pathLocator, "AdministratorFilter (Owner: Administrator)");
        this.text.assertTextPresent(pathLocator, "FredFilter (Owner: Fred Normal)");
        this.navigation.issueNavigator().deleteFilter(adminId);
        this.gotoViewGroup("jira-users");
        pathLocator = new XPathLocator(this.tester, "//td[@class='jiraformbody']");
        this.text.assertTextNotPresent(pathLocator, "AdministratorFilter (Owner: Administrator)");
        this.text.assertTextPresent(pathLocator, "FredFilter (Owner: Fred Normal)");
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issueNavigator().deleteFilter(fredId);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.gotoViewGroup("jira-users");
        pathLocator = new XPathLocator(this.tester, "//td[@class='jiraformbody']");
        this.text.assertTextNotPresent(pathLocator, "AdministratorFilter (Owner: Administrator)");
        this.text.assertTextNotPresent(pathLocator, "FredFilter (Owner: Fred Normal)");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//td[@class='jiraformbody']"), "There are no Saved Filters associated with this Group.");
    }

    public void testViewSchemes() {
        this.navigation.gotoAdmin();
        this.tester.clickLink("group_browser");
        this.tester.setFormElement("addName", TEST_GROUP);
        this.tester.submit("add_group");
        this.tester.clickLinkWithText(TEST_GROUP);
        this.text.assertTextPresent(new WebPageLocator(this.tester), "There are no Permission Schemes associated with this Group.");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "There are no Notification Schemes associated with this Group.");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "There are no Saved Filters associated with this Group.");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "There are no Issue Security Schemes associated with this Group.");
        this.navigation.gotoAdmin();
        this.tester.clickLink("permission_schemes");
        this.tester.clickLink("0_edit");
        this.tester.clickLink("add_perm_23");
        this.tester.checkCheckbox("type", "group");
        this.tester.selectOption("group", TEST_GROUP);
        this.tester.submit(" Add ");
        this.navigation.gotoAdmin();
        this.tester.clickLink("notification_schemes");
        this.tester.clickLink("10000_edit");
        this.tester.clickLink("add_1");
        this.tester.checkCheckbox("type", "Group_Dropdown");
        this.tester.selectOption("Group_Dropdown", TEST_GROUP);
        this.tester.submit(" Add ");
        this.navigation.gotoAdmin();
        this.tester.clickLink("security_schemes");
        this.tester.clickLink("add_securityscheme");
        this.tester.setFormElement("name", "Test Issue Security Scheme");
        this.tester.submit("Add");
        this.tester.clickLinkWithText("Security Levels");
        this.tester.setFormElement("name", "Code Red");
        this.tester.submit("Add Security Level");
        this.tester.setFormElement("name", "");
        this.tester.clickLink("add_Code Red");
        this.tester.checkCheckbox("type", "group");
        this.tester.selectOption("group", TEST_GROUP);
        this.tester.submit(" Add ");
        this.gotoViewGroup(TEST_GROUP);
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Default Permission Scheme");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Default Notification Scheme");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Test Issue Security Scheme");
        this.navigation.gotoAdmin();
        this.tester.clickLink("notification_schemes");
        this.tester.clickLink("10000_edit");
        this.tester.clickLink("del_10060");
        this.tester.submit("Delete");
        this.tester.clickLink("permission_schemes");
        this.tester.clickLink("0_edit");
        this.tester.clickLink("del_perm_23_test_group");
        this.tester.submit("Delete");
        this.tester.clickLink("security_schemes");
        this.tester.clickLink("del_Test Issue Security Scheme");
        this.tester.submit("Delete");
        this.gotoViewGroup(TEST_GROUP);
        this.text.assertTextPresent(new WebPageLocator(this.tester), "There are no Permission Schemes associated with this Group.");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "There are no Notification Schemes associated with this Group.");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "There are no Saved Filters associated with this Group.");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "There are no Issue Security Schemes associated with this Group.");
    }

    private void gotoViewGroup(String group) {
        this.tester.gotoPage("secure/admin/user/ViewGroup.jspa?name=" + group);
        XPathLocator locator = new XPathLocator(this.tester, "//td[@class='jiraformheader']");
        this.text.assertTextPresent(locator, "Group: " + group);
    }
}

