/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import net.sourceforge.jwebunit.WebTester;

public class TestUserRememberMeCookies
extends FuncTestCase {
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
        for (int i = 0; i < 5; ++i) {
            this.loginAs("admin");
        }
    }

    public void testHasRememberMeCookies() {
        this.gotoRememberMeUserBrowserAdminSection();
        this.text.assertTextSequence(this.xpath("//form[@id='rememberme_cookies_form']//h2"), "Remember My Login", "Administrator");
        TestUserRememberMeCookies.assertEquals((String)"There should be 5 rows of cookies", (int)5, (int)this.xpath("//table[@id='rememberme_cookies_table']//tbody/tr").getNodes().length);
        this.tester.submit("Submit");
        this.assertHasNoRememberMeCookies();
    }

    public void testUserProfileRememberMeClear() {
        this.navigation.gotoPage("secure/ViewProfile.jspa");
        this.tester.clickLink("view_clear_rememberme");
        this.text.assertTextPresent("Remember My Login");
        this.tester.submit("Clear");
        this.text.assertTextPresent("Your remember my login tokens have successfully been cleared");
        this.gotoRememberMeUserBrowserAdminSection();
        this.assertHasNoRememberMeCookies();
    }

    public void testUserProfileRememberMeClear_NotLoggedIn() {
        this.navigation.logout();
        this.navigation.gotoPage("secure/ClearRememberMeCookies!default.jspa");
        this.text.assertTextPresent("You must be logged in to clear your remember my login tokens.");
    }

    public void testAllUsersRememberMeClear() {
        this.navigation.gotoPage("secure/admin/user/AllUsersRememberMeCookies!default.jspa");
        this.assertWeAreOnTheClearAllPage(5);
        this.navigation.gotoAdminSection("rememberme");
        this.assertWeAreOnTheClearAllPage(5);
        this.tester.submit("Submit");
        this.text.assertTextPresent("All the tokens have been cleared.");
        this.assertWeAreOnTheClearAllPage(0);
        this.gotoRememberMeUserBrowserAdminSection();
        this.assertHasNoRememberMeCookies();
    }

    private void assertWeAreOnTheClearAllPage(Integer numberOfTokens) {
        this.text.assertTextPresent("Remember My Login for All Users");
        this.text.assertTextPresent("to clear all of these tokens from this JIRA site.");
        this.text.assertTextPresent(this.xpath("//div[@class='content-body']/p/strong"), numberOfTokens.toString());
    }

    private void assertHasNoRememberMeCookies() {
        this.text.assertTextPresent(this.xpath("//form[@id='rememberme_cookies_form']"), "No login tokens have been set for: Administrator");
    }

    private void gotoRememberMeUserBrowserAdminSection() {
        this.navigation.gotoAdminSection("user_browser");
        this.tester.clickLink("admin");
        this.tester.clickLink("rememberme_link");
    }

    private void loginAs(String userName) {
        WebTester tester = new WebTester();
        tester.getTestContext().setBaseUrl(this.getEnvironmentData().getBaseUrl().toExternalForm());
        tester.beginAt("/login.jsp");
        tester.setFormElement("os_username", userName);
        tester.setFormElement("os_password", userName);
        tester.setFormElement("os_cookie", "true");
        tester.setWorkingForm("login-form");
        tester.submit();
        this.log.log("Started session for " + userName);
    }
}

