/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.webtests.JIRAWebTest;
import org.apache.commons.lang.StringUtils;

public class TestUserProperties
extends JIRAWebTest {
    protected static final String USER_BOB_BROWSER = "/secure/admin/user/EditUserProperties.jspa?name=bob";
    protected static final String DELETE_PROP = "delete_testprop";

    public TestUserProperties(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
        this.addUser("bob", "bob_password", "Bob The Builder", "bob@stuff.com.com");
        this.goToBobPropertiesPage();
    }

    public void testAddUserProperty() {
        this.addBobProperty("testprop", "testvalue");
        this.goToBobPropertiesPage();
        this.assertTextPresentBeforeText("testprop", "testvalue");
    }

    public void testDuplicateProperty() {
        this.addBobProperty("testprop", "testvalue1");
        this.addBobProperty("testprop", "testvalue2");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("This 'key' already exists for the user.");
    }

    public void testDeleteUserProperty() {
        this.addBobProperty("testprop", "testvalue");
        this.gotoPage(USER_BOB_BROWSER);
        this.clickLink(DELETE_PROP);
        this.assertTextPresent("Delete Property: testprop");
        this.submit("Delete");
        this.tester.assertTextPresent("currently has no properties");
    }

    public void testInvalidCharactersForProperty() {
        this.addBobProperty("testprop!", "testvalue");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("The 'key' can only contain alphanumeric characters");
    }

    public void testKeyExceedsCharacterLengthCheck() {
        this.addBobProperty(StringUtils.repeat((String)"x", (int)251), "testvalue");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("The 'key' length must be less than 200 characters");
    }

    public void testValueExceedCharacterLengthCheck() {
        this.addBobProperty("testproperty", StringUtils.repeat((String)"x", (int)251));
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("The 'value' length must be less than 250 characters");
    }

    public void testKeyIsEmptyCheck() {
        this.addBobProperty("", "testvalue");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("The 'key' cannot be empty");
    }

    public void testValueIsEmptyCheck() {
        this.addBobProperty("testproperty", "");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("The 'value' cannot be empty");
    }

    public void testValueIsHtmlEncoded() {
        this.addBobProperty("testproperty", "<blink>Annoying</blink>");
        this.assertTextPresent("&lt;blink&gt;Annoying&lt;/blink&gt;");
        this.assertTextNotPresent("<blink>Annoying</blink>");
    }

    private void addBobProperty(String key, String value) {
        this.goToBobPropertiesPage();
        this.setFormElement("key", key);
        this.setFormElement("value", value);
        this.submit();
    }

    private void goToBobPropertiesPage() {
        this.gotoPage(USER_BOB_BROWSER);
        this.assertTextPresent("Bob The Builder");
    }
}

