/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;

public class TestUserHover
extends FuncTestCase {
    protected void setUpTest() {
        this.administration.restoreData("TestUserAvatars.xml");
    }

    public void testUserHover() {
        this.navigation.gotoPage("/secure/ViewUserHover!default.jspa?decorator=none&username=unknownuser");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "unknownuser");
        this.tester.assertLinkPresentWithText("Current Issues");
        this.tester.assertLinkPresentWithText("Profile");
        this.navigation.gotoPage("/secure/ViewUserHover!default.jspa?decorator=none&username=admin");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Administrator");
        this.tester.assertLinkPresentWithText("admin@example.com");
        this.tester.assertLinkPresentWithText("Current Issues");
        this.tester.assertLinkPresentWithText("Profile");
        this.tester.assertLinkNotPresent("update_avatar_link");
        this.navigation.gotoPage("/secure/ViewUserHover!default.jspa?decorator=none&username=brad");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Brad Baker");
        this.tester.assertLinkPresentWithText("brad@example.com");
        this.tester.assertLinkPresentWithText("Current Issues");
        this.tester.assertLinkPresentWithText("Profile");
        this.navigation.logout();
        this.navigation.gotoPage("/secure/ViewUserHover!default.jspa?decorator=none&username=brad");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Brad Baker");
        this.tester.assertLinkNotPresentWithText("brad@example.com");
        this.tester.assertLinkNotPresentWithText("Current Issues");
        this.tester.assertLinkNotPresentWithText("Profile");
        this.navigation.login("admin", "admin");
        this.administration.generalConfiguration().setUserEmailVisibility(GeneralConfiguration.EmailVisibility.MASKED);
        this.navigation.gotoPage("/secure/ViewUserHover!default.jspa?decorator=none&username=brad");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Brad Baker");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "brad at example dot com");
        this.tester.assertLinkNotPresentWithText("brad@example.com");
        this.tester.assertLinkPresentWithText("Current Issues");
        this.tester.assertLinkPresentWithText("Profile");
        this.administration.usersAndGroups().addUser("bob");
        this.navigation.logout();
        this.navigation.login("bob");
        this.navigation.gotoPage("/secure/ViewUserHover!default.jspa?decorator=none&username=bob");
        this.tester.assertLinkPresent("update_avatar_link");
        this.navigation.logout();
        this.navigation.gotoPage("/secure/ViewUserHover!default.jspa?decorator=none&username=admin");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Administrator");
        this.tester.assertLinkNotPresentWithText("admin@example.com");
        this.tester.assertTextNotPresent("admin@example.com");
        this.tester.assertLinkNotPresentWithText("Current Issues");
        this.tester.assertLinkNotPresentWithText("Profile");
    }
}

