/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.modern;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.locator.IdLocator;

public class TestTimeTrackingIsEditableByUpdateIssueFieldFunction
extends FuncTestCase {
    protected void setUpTest() {
        this.administration.restoreData("TestTimeTrackingUpdateIssueFieldFunction.xml");
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable(TimeTracking.Mode.MODERN);
        this.administration.fieldConfigurations().defaultFieldConfiguration().getScreens("Log Work").addFieldToScreen("Default Screen");
    }

    public void testCanEditRemainingEstimateOnResolve() {
        this.navigation.issue().resolveIssue("HSP-1", "Fixed", "Resolving the Issue as Fixed. This should set the remaining estimate to 0");
        this.assertTimeTrackingValuesAreEqualTo("1w", "0m", "3d");
    }

    public void testCanEditOriginalEstimateOnClose() {
        this.navigation.issue().closeIssue("HSP-4", "Won't Fix", "Closing the Issue as Won't Fix. This should set the original estimate to 0");
        this.assertTimeTrackingValuesAreEqualTo("0m", "0m", "1w");
    }

    public void testCanEditOriginalAndRemainingEstimateOnReopen() {
        this.navigation.issue().reopenIssue("HSP-2");
        this.assertTimeTrackingValuesAreEqualTo("2h", "2h", "Not Specified");
    }

    private void assertTimeTrackingValuesAreEqualTo(String originalEstimateValue, String remainingEstimateValue, String timeSpentValue) {
        this.text.assertTextPresent(new IdLocator(this.tester, "tt_single_values_orig"), originalEstimateValue);
        this.text.assertTextPresent(new IdLocator(this.tester, "tt_single_values_remain"), remainingEstimateValue);
        this.text.assertTextPresent(new IdLocator(this.tester, "tt_single_values_spent"), timeSpentValue);
    }
}

