/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.modern;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.locator.IdLocator;

public class TestTimeTrackingInputValidation
extends FuncTestCase {
    protected void setUpTest() {
        this.administration.restoreData("TestTimeTrackingBase.xml");
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable("8", "5", "pretty", "hour", TimeTracking.Mode.MODERN);
        this.administration.fieldConfigurations().defaultFieldConfiguration().getScreens("Log Work").addFieldToScreen("Default Screen");
    }

    public void testTimeTrackingFieldRejectsRubbish() {
        this.navigation.issue().setOriginalEstimate("HSP-5", "[@asksajm1541%<><><<<();>)");
        this.text.assertTextPresent("The original estimate specified is not valid.");
        this.navigation.issue().setRemainingEstimate("HSP-5", "[#s#~@^%&&*^&*ksajm1541%<><><<<();>)");
        this.text.assertTextPresent("The remaining estimate specified is not valid.");
    }

    public void testTimeTrackingAcceptsFractionalValues() {
        String key = this.navigation.issue().createIssue("homosapien", "Bug", "testTimeTrackingAcceptsFractionalValues");
        this.navigation.issue().setOriginalEstimate(key, "7.15h");
        this.navigation.issue().setRemainingEstimate(key, "7.15h");
        this.text.assertTextSequence(new IdLocator(this.getTester(), "tt_single_table_info"), "Estimated:", "7h 9m", "Remaining:", "7h 9m");
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable("8", "5", "hours", "hour", TimeTracking.Mode.MODERN);
        this.navigation.issue().viewIssue(key);
        this.text.assertTextSequence(new IdLocator(this.getTester(), "tt_single_table_info"), "Estimated:", "7.15h", "Remaining:", "7.15h");
        this.navigation.issue().setRemainingEstimate(key, "12m");
        this.text.assertTextSequence(new IdLocator(this.getTester(), "tt_single_table_info"), "Estimated:", "7.15h", "Remaining:", "0.2h");
        this.navigation.issue().setRemainingEstimate(key, "20m");
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_orig"), "7.15h");
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_remain"), "20m");
    }

    public void testTimeTrackingRejectsInvalidTimeUnitSuffixes() {
        this.navigation.issue().setOriginalEstimate("HSP-5", "1y");
        this.text.assertTextPresent("The original estimate specified is not valid.");
        this.navigation.issue().setRemainingEstimate("HSP-5", "1ms");
        this.text.assertTextPresent("The remaining estimate specified is not valid.");
    }

    public void testTimeTrackingAcceptsMoreThanOneEntryQualifiedByTheSameTimeUnit() {
        this.navigation.issue().setOriginalEstimate("HSP-5", "1w 2w");
        this.text.assertTextNotPresent("The original estimate specified is not valid.");
        this.navigation.issue().setRemainingEstimate("HSP-5", "1h 30h");
        this.text.assertTextNotPresent("The remaining estimate specified is not valid.");
    }

    public void testTimeTrackingRejectsTimeUnitsNotQualifiedByANumber() {
        this.navigation.issue().setOriginalEstimate("HSP-5", "w 2d");
        this.text.assertTextPresent("The original estimate specified is not valid.");
        this.navigation.issue().setRemainingEstimate("HSP-5", "1h s");
        this.text.assertTextPresent("The remaining estimate specified is not valid.");
    }

    public void testTimeTrackingAcceptsMoreThanOneEmptyTimeUnitSuffix() {
        this.navigation.issue().setOriginalEstimate("HSP-5", "6 10");
        this.text.assertTextNotPresent("The original estimate specified is not valid.");
        this.navigation.issue().setRemainingEstimate("HSP-5", "5 30");
        this.text.assertTextNotPresent("The remaining estimate specified is not valid.");
    }
}

