/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.modern;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.changehistory.ChangeHistoryList;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.webtests.ztests.timetracking.modern.LogWorkRunner;

public abstract class AbstractTestCreateWorklogAsField
extends FuncTestCase {
    protected static final String CHANGEHISTORY_10001 = "changehistory_10001";
    protected static final String HSP_1 = "HSP-1";
    protected static final String HSP_2 = "HSP-2";
    private static final String WORK_LOG_COMMENT_1 = "This is a comment generated for a first work log.";
    private static final String ROLE_DEVELOPERS = "Developers";
    private static final String GROUP_ADMINISTRATORS = "jira-administrators";
    private static final String WORKLOG = "worklog_";
    private static final String FIELD_NAME_TIME_LOGGED = "worklog_timeLogged";
    private static final String FIELD_NAME_START_DATE = "worklog_startDate";
    private static final String FIELD_NAME_NEW_ESTIMATE = "worklog_newEstimate";
    private static final String FIELD_NAME_ADJUSTMENT_AMOUNT = "worklog_adjustmentAmount";
    private static final String FIELD_NAME_ADJUST_ESTIMATE = "worklog_adjustEstimate";
    private static final String FIELD_NAME_COMMENT = "comment";
    private static final String FIELD_NAME_COMMENT_LEVEL = "commentLevel";
    private TimeTracking.Format currentTimeFormat;

    protected abstract LogWorkRunner getLogWorkRunner();

    public void setUpTest() {
        this.administration.restoreData("TestLogWorkAsField.xml");
    }

    public void testWorklogNoPermToCreate() {
        this.administration.permissionSchemes().defaultScheme();
        this.getTester().clickLink("del_perm_20_jira-developers");
        this.getTester().submit("Delete");
        this.getLogWorkRunner().gotoLogWorkScreen1();
        this.getTester().assertElementNotPresent(FIELD_NAME_TIME_LOGGED);
    }

    public void testWorklogTimeTrackingDisabled() {
        this.administration.timeTracking().disable();
        this.getLogWorkRunner().gotoLogWorkScreen1();
        this.tester.assertElementNotPresent("log-work-time-logged");
        this.administration.timeTracking().enable(TimeTracking.Mode.MODERN);
        this.getLogWorkRunner().gotoLogWorkScreen1();
        this.tester.assertElementPresent("log-work-time-logged");
    }

    public void testLogWorkLeaveEstimateNoteCorrect() {
        this.getLogWorkRunner().gotoLogWorkScreen1();
        if (this.getLogWorkRunner().isLoggingWorkTwiceSupported()) {
            this.text.assertTextPresent("Use existing estimate of 15 hours");
        } else {
            this.text.assertTextPresent("Leave estimate unset");
        }
        this.getLogWorkRunner().gotoLogWorkScreenWithOriginalEstimate("");
        this.text.assertTextPresent("Leave estimate unset");
    }

    public void testMandatoryFields() {
        this.administration.fieldConfigurations().defaultFieldConfiguration().requireField("Log Work");
        this.getLogWorkRunner().gotoLogWorkScreen1();
        this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "");
        this.getTester().setFormElement(FIELD_NAME_START_DATE, "");
        this.getTester().setFormElement(FIELD_NAME_NEW_ESTIMATE, "");
        this.getTester().checkCheckbox(FIELD_NAME_ADJUST_ESTIMATE, "new");
        this.getTester().submit();
        this.text.assertTextPresent("You must indicate the time spent working.");
        this.text.assertTextPresent("You must specify a date on which the work occurred.");
        this.text.assertTextPresent("You must supply a valid new estimate.");
        this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "");
        this.getTester().setFormElement(FIELD_NAME_START_DATE, "");
        this.getTester().setFormElement(FIELD_NAME_ADJUSTMENT_AMOUNT, "");
        this.getTester().checkCheckbox(FIELD_NAME_ADJUST_ESTIMATE, "manual");
        this.getTester().submit();
        this.text.assertTextPresent("You must indicate the time spent working.");
        this.text.assertTextPresent("You must specify a date on which the work occurred.");
        this.text.assertTextPresent("You must supply a valid amount of time to adjust the estimate by.");
        this.administration.fieldConfigurations().defaultFieldConfiguration().optionalField("Log Work");
        this.getLogWorkRunner().gotoLogWorkScreen1();
        this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "");
        this.getTester().setFormElement(FIELD_NAME_START_DATE, "");
        this.getTester().setFormElement(FIELD_NAME_NEW_ESTIMATE, "1h");
        this.getTester().checkCheckbox(FIELD_NAME_ADJUST_ESTIMATE, "new");
        this.getTester().submit();
        this.text.assertTextPresent("You must indicate the time spent working.");
        this.text.assertTextPresent("You must specify a date on which the work occurred.");
        this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "1h");
        this.getTester().setFormElement(FIELD_NAME_START_DATE, "");
        this.getTester().setFormElement(FIELD_NAME_NEW_ESTIMATE, "");
        this.getTester().checkCheckbox(FIELD_NAME_ADJUST_ESTIMATE, "new");
        this.getTester().submit();
        this.text.assertTextPresent("You must specify a date on which the work occurred.");
        this.text.assertTextPresent("You must supply a valid new estimate.");
        this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "");
        this.getTester().setFormElement(FIELD_NAME_START_DATE, "");
        this.getTester().setFormElement(FIELD_NAME_ADJUSTMENT_AMOUNT, "1h");
        this.getTester().checkCheckbox(FIELD_NAME_ADJUST_ESTIMATE, "manual");
        this.getTester().submit();
        this.text.assertTextPresent("You must indicate the time spent working.");
        this.text.assertTextPresent("You must specify a date on which the work occurred.");
        this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "1h");
        this.getTester().setFormElement(FIELD_NAME_START_DATE, "");
        this.getTester().setFormElement(FIELD_NAME_ADJUSTMENT_AMOUNT, "");
        this.getTester().checkCheckbox(FIELD_NAME_ADJUST_ESTIMATE, "manual");
        this.getTester().submit();
        this.text.assertTextPresent("You must specify a date on which the work occurred.");
        this.text.assertTextPresent("You must supply a valid amount of time to adjust the estimate by.");
    }

    public void testInvalidFormattedDurationFields() {
        this.getLogWorkRunner().gotoLogWorkScreen1();
        this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "16 Candles");
        this.getTester().setFormElement(FIELD_NAME_START_DATE, "18/Jun/07 10:49 AM");
        this.getTester().setFormElement(FIELD_NAME_NEW_ESTIMATE, "Six Days, Seven Nights");
        this.getTester().checkCheckbox(FIELD_NAME_ADJUST_ESTIMATE, "new");
        this.getTester().submit();
        this.text.assertTextPresent("Invalid time duration entered.");
        this.text.assertTextPresent("Invalid new estimate entered.");
        this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "16 Candles");
        this.getTester().setFormElement(FIELD_NAME_START_DATE, "18/Jun/07 10:49 AM");
        this.getTester().setFormElement(FIELD_NAME_ADJUSTMENT_AMOUNT, "Six Days, Seven Nights");
        this.getTester().checkCheckbox(FIELD_NAME_ADJUST_ESTIMATE, "manual");
        this.getTester().submit();
        this.text.assertTextPresent("Invalid time entered for adjusting the estimate.");
        this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "-2h");
        this.getTester().checkCheckbox(FIELD_NAME_ADJUST_ESTIMATE, "auto");
        this.getTester().submit();
        this.text.assertTextPresent("Invalid time duration entered.");
    }

    public void testBadFractionDuration() {
        String[] badDurations;
        for (String badDuration : badDurations = new String[]{"2.h", "5.3756h", "0.5m"}) {
            this.getLogWorkRunner().gotoLogWorkScreen1();
            this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, badDuration);
            this.getTester().submit();
            this.text.assertTextPresent("Invalid time duration entered.");
        }
    }

    public void testGoodFractionDuration() throws Exception {
        this.getLogWorkRunner().gotoLogWorkScreenWithOriginalEstimate("4d");
        this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "1.5d 2.5h 18m");
        this.getTester().submit();
        this.text.assertTextSequence(new IdLocator(this.tester, "timetrackingmodule"), "Estimated", "4d", "Remaining", "2d 9h 12m", "Logged", "1d 14h 48m");
    }

    public void testInvalidTimeSpentZero() {
        this.getLogWorkRunner().gotoLogWorkScreen1();
        this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "0");
        this.getTester().setFormElement(FIELD_NAME_START_DATE, "18/Jun/07 10:49 AM");
        this.getTester().submit();
        this.text.assertTextPresent("Time Spent can not be zero.");
    }

    public void testInvalidStartDateField() {
        this.getLogWorkRunner().gotoLogWorkScreen1();
        this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "4h");
        this.getTester().setFormElement(FIELD_NAME_START_DATE, "The Day After Tomorrow");
        this.getTester().checkCheckbox(FIELD_NAME_ADJUST_ESTIMATE, "leave");
        this.getTester().submit();
        this.text.assertTextPresent("You must specify a date on which the work occurred.");
    }

    public void testAutoAdjustEstimate() {
        this.getLogWorkRunner().gotoLogWorkScreenWithOriginalEstimate("4d");
        this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "4h 30m");
        this.getTester().submit();
        this.text.assertTextSequence(new IdLocator(this.tester, "timetrackingmodule"), "Estimated", "4d", "Remaining", "3d 19h 30m", "Logged", "4h 30m");
    }

    public void testNewEstimate() {
        this.getLogWorkRunner().gotoLogWorkScreenWithOriginalEstimate("4d");
        this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "4h 30m");
        this.getTester().checkCheckbox(FIELD_NAME_ADJUST_ESTIMATE, "new");
        this.getTester().setFormElement(FIELD_NAME_NEW_ESTIMATE, "1d 5h");
        this.getTester().submit();
        this.text.assertTextSequence(new IdLocator(this.tester, "timetrackingmodule"), "Estimated", "4d", "Remaining", "1d 5h", "Logged", "4h 30m");
    }

    public void testLeaveExistingEstimate() {
        this.getLogWorkRunner().gotoLogWorkScreenWithOriginalEstimate("4d");
        this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "4h 30m");
        this.getTester().checkCheckbox(FIELD_NAME_ADJUST_ESTIMATE, "leave");
        this.getTester().submit();
        this.text.assertTextSequence(new IdLocator(this.tester, "timetrackingmodule"), "Estimated", "4d", "Remaining", "4d", "Logged", "4h 30m");
    }

    public void testManuallyAdjustEstimate() {
        this.getLogWorkRunner().gotoLogWorkScreenWithOriginalEstimate("2d");
        this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "4h 30m");
        this.getTester().checkCheckbox(FIELD_NAME_ADJUST_ESTIMATE, "manual");
        this.getTester().setFormElement(FIELD_NAME_ADJUSTMENT_AMOUNT, "1d 6h");
        this.getTester().submit();
        this.text.assertTextSequence(new IdLocator(this.tester, "timetrackingmodule"), "Estimated", "2d", "Remaining", "18h", "Logged", "4h 30m");
    }

    public void testLogWorkVisibleToAll() {
        this.reconfigureTimetracking(TimeTracking.Format.PRETTY);
        this.execLogWorkVisibleToAll();
    }

    public void testLogWorkVisibleToAllDaysTimeFormat() {
        this.reconfigureTimetracking(TimeTracking.Format.DAYS);
        this.execLogWorkVisibleToAll();
    }

    public void testLogWorkVisibleToAllHoursTimeFormat() {
        this.reconfigureTimetracking(TimeTracking.Format.HOURS);
        this.execLogWorkVisibleToAll();
    }

    private void execLogWorkVisibleToAll() {
        this.getLogWorkRunner().gotoLogWorkScreen1();
        this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "2d");
        this.getTester().setFormElement(FIELD_NAME_COMMENT, WORK_LOG_COMMENT_1);
        this.getTester().submit();
        this.getTester().clickLinkWithText("Work Log");
        this.text.assertTextPresent(WORK_LOG_COMMENT_1);
        if (TimeTracking.Format.PRETTY == this.currentTimeFormat) {
            this.text.assertTextSequence(new IdLocator(this.tester, "worklog-10000"), "Time Spent", "2 days");
        } else if (TimeTracking.Format.DAYS == this.currentTimeFormat) {
            this.text.assertTextSequence(new IdLocator(this.tester, "worklog-10000"), "Time Spent", "2d");
        } else if (TimeTracking.Format.HOURS == this.currentTimeFormat) {
            this.text.assertTextSequence(new IdLocator(this.tester, "worklog-10000"), "Time Spent", "48h");
        }
    }

    public void testLogWorkVisibleToRole() {
        this.reconfigureTimetracking(TimeTracking.Format.PRETTY);
        this.execLogWorkVisibleToRole();
    }

    public void testLogWorkVisibleToRoleDaysTimeFormat() {
        this.reconfigureTimetracking(TimeTracking.Format.DAYS);
        this.execLogWorkVisibleToRole();
    }

    public void testLogWorkVisibleToRoleHoursTimeFormat() {
        this.reconfigureTimetracking(TimeTracking.Format.HOURS);
        this.execLogWorkVisibleToRole();
    }

    private void execLogWorkVisibleToRole() {
        this.execLogWorkVisibleToCommentLevel(ROLE_DEVELOPERS);
    }

    public void testLogWorkVisibleToGroup() {
        this.reconfigureTimetracking(TimeTracking.Format.PRETTY);
        this.execLogWorkVisibleToGroup();
    }

    public void testLogWorkVisibleToGroupDaysTimeFormat() {
        this.reconfigureTimetracking(TimeTracking.Format.DAYS);
        this.execLogWorkVisibleToGroup();
    }

    public void testLogWorkVisibleToGroupHoursTimeFormat() {
        this.reconfigureTimetracking(TimeTracking.Format.HOURS);
        this.execLogWorkVisibleToGroup();
    }

    public void execLogWorkVisibleToGroup() {
        this.execLogWorkVisibleToCommentLevel(GROUP_ADMINISTRATORS);
    }

    public void execLogWorkVisibleToCommentLevel(String commentLevel) {
        this.getLogWorkRunner().gotoLogWorkScreen1();
        this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "dddddd");
        this.getTester().checkCheckbox(FIELD_NAME_ADJUST_ESTIMATE, "new");
        this.getTester().setFormElement(FIELD_NAME_NEW_ESTIMATE, "2w");
        this.getTester().setFormElement(FIELD_NAME_COMMENT, WORK_LOG_COMMENT_1);
        this.getTester().selectOption(FIELD_NAME_COMMENT_LEVEL, commentLevel);
        this.getTester().submit();
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected(FIELD_NAME_COMMENT_LEVEL, commentLevel);
        this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "2d");
        this.getTester().submit();
        this.getTester().clickLinkWithText("Work Log");
        this.text.assertTextPresent(WORK_LOG_COMMENT_1);
        if (TimeTracking.Format.PRETTY == this.currentTimeFormat) {
            this.text.assertTextSequence(new IdLocator(this.tester, "worklog-10000"), "Time Spent", "2 days");
        } else if (TimeTracking.Format.DAYS == this.currentTimeFormat) {
            this.text.assertTextSequence(new IdLocator(this.tester, "worklog-10000"), "Time Spent", "2d");
        } else if (TimeTracking.Format.HOURS == this.currentTimeFormat) {
            this.text.assertTextSequence(new IdLocator(this.tester, "worklog-10000"), "Time Spent", "48h");
        }
        this.navigation.login("fred", "fred");
        this.getLogWorkRunner().gotoLogWorkResult();
        this.text.assertTextNotPresent(WORK_LOG_COMMENT_1);
        this.assertions.assertNodeByIdDoesNotExist("worklog-10000");
        if (TimeTracking.Format.PRETTY == this.currentTimeFormat) {
            this.text.assertTextSequence(new IdLocator(this.tester, "timetrackingmodule"), "Remaining", "2w", "Logged", "2d");
        } else if (TimeTracking.Format.DAYS == this.currentTimeFormat) {
            this.text.assertTextSequence(new IdLocator(this.tester, "timetrackingmodule"), "Remaining", "14d", "Logged", "2d");
        } else if (TimeTracking.Format.HOURS == this.currentTimeFormat) {
            this.text.assertTextSequence(new IdLocator(this.tester, "timetrackingmodule"), "Remaining", "336h", "Logged", "48h");
        }
    }

    public void testLogWorkCommentsNotCopiedWhenCopyingDisabled() {
        this.administration.timeTracking().disableCopyingOfComments();
        this.getLogWorkRunner().gotoLogWorkScreen1();
        this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "1h");
        this.getTester().checkCheckbox(FIELD_NAME_ADJUST_ESTIMATE, "new");
        this.getTester().setFormElement(FIELD_NAME_NEW_ESTIMATE, "2w");
        this.getTester().setFormElement(FIELD_NAME_COMMENT, WORK_LOG_COMMENT_1);
        this.getTester().selectOption(FIELD_NAME_COMMENT_LEVEL, GROUP_ADMINISTRATORS);
        this.getTester().submit();
        if (this.getLogWorkRunner().isCommentFieldShown()) {
            this.text.assertTextPresent(WORK_LOG_COMMENT_1);
            this.getTester().clickLinkWithText("Work Log");
            this.text.assertTextNotPresent(WORK_LOG_COMMENT_1);
            this.navigation.login("fred");
            this.getLogWorkRunner().gotoLogWorkResult();
            this.text.assertTextSequence(new IdLocator(this.tester, "worklog-10000"), "Time Spent", "1 hour");
            this.getTester().clickLinkWithText("Comments");
            this.text.assertTextNotPresent(WORK_LOG_COMMENT_1);
        } else {
            this.text.assertTextNotPresent(WORK_LOG_COMMENT_1);
            this.getTester().clickLinkWithText("Work Log");
            this.text.assertTextPresent(WORK_LOG_COMMENT_1);
            this.navigation.login("fred");
            this.getLogWorkRunner().gotoLogWorkResult();
            this.getTester().assertElementNotPresent("worklog-10000");
            this.getTester().clickLinkWithText("Comments");
            this.text.assertTextNotPresent(WORK_LOG_COMMENT_1);
        }
    }

    public void testLogWorkCommentsCopiedWhenCopyingEnabled() {
        if (this.getLogWorkRunner().isCommentFieldShown()) {
            this.getLogWorkRunner().gotoLogWorkScreen1();
            this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "1h");
            this.getTester().checkCheckbox(FIELD_NAME_ADJUST_ESTIMATE, "new");
            this.getTester().setFormElement(FIELD_NAME_NEW_ESTIMATE, "2w");
            this.getTester().setFormElement(FIELD_NAME_COMMENT, WORK_LOG_COMMENT_1);
            this.getTester().selectOption(FIELD_NAME_COMMENT_LEVEL, GROUP_ADMINISTRATORS);
            this.getTester().submit();
            this.text.assertTextPresent(WORK_LOG_COMMENT_1);
            this.getTester().clickLinkWithText("Work Log");
            this.text.assertTextPresent(WORK_LOG_COMMENT_1);
            this.text.assertTextSequence(new IdLocator(this.tester, "worklog-10000"), "Time Spent", "1 hour");
            this.navigation.login("fred");
            this.getLogWorkRunner().gotoLogWorkResult();
            this.getTester().assertElementNotPresent("worklog-10000");
            this.getTester().clickLinkWithText("Comments");
            this.text.assertTextNotPresent(WORK_LOG_COMMENT_1);
        } else {
            this.log("Skipping this test as it does not make sense when the comment field is not shown.");
        }
    }

    private void reconfigureTimetracking(TimeTracking.Format format) {
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable(format);
        this.currentTimeFormat = format;
    }

    public void testLogWorkDateIsStartDate() {
        if (this.getLogWorkRunner().isLoggingWorkTwiceSupported()) {
            this.getLogWorkRunner().gotoLogWorkScreen1();
            this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "2d");
            this.getTester().setFormElement(FIELD_NAME_START_DATE, "1/Jun/06 12:00 PM");
            this.getTester().submit();
            this.getTester().clickLinkWithText("Work Log");
            this.text.assertTextPresent(new IdLocator(this.tester, "worklog-10000"), "01/Jun/06 12:00 PM");
            this.getLogWorkRunner().gotoLogWorkScreen2();
            this.getTester().checkCheckbox("worklog_activate", "true");
            this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "2d");
            this.getTester().setFormElement(FIELD_NAME_START_DATE, "1/Jun/05 12:00 PM");
            this.getTester().submit();
            this.text.assertTextPresent(new IdLocator(this.tester, "worklog-10001"), "01/Jun/05 12:00 PM");
            this.text.assertTextSequence(new IdLocator(this.tester, "issue_actions_container"), "01/Jun/05 12:00 PM", "01/Jun/06 12:00 PM");
        } else {
            this.log("Skipping this test as '" + this.getLogWorkRunner().getClass() + "' does not support logging work twice on the same issue.");
        }
    }

    public void testChangeHistory() throws Exception {
        this.getLogWorkRunner().gotoLogWorkScreenWithOriginalEstimate("4d");
        Thread.sleep(2000L);
        this.getTester().setFormElement(FIELD_NAME_TIME_LOGGED, "4h 30m");
        this.getTester().checkCheckbox(FIELD_NAME_ADJUST_ESTIMATE, "new");
        this.getTester().setFormElement(FIELD_NAME_NEW_ESTIMATE, "1d 5h");
        this.getTester().submit();
        this.getLogWorkRunner().gotoLogWorkResult();
        this.getTester().clickLink("changehistory-tabpanel");
        ChangeHistoryList expectedList = new ChangeHistoryList();
        expectedList.addChangeSet("Administrator").add("Time Spent", "", "4 hours, 30 minutes [ 16200 ]").add("Remaining Estimate", "4 days [ 345600 ]", "1 day, 5 hours [ 104400 ]").add("Worklog Id", "10000 [ 10000 ]", "");
        ChangeHistoryList list = this.parse.issue().parseChangeHistory();
        list.assertContainsSomeOf(expectedList);
    }
}

