/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.legacy;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.locator.IdLocator;

public class TestTimeTrackingEntryValues
extends FuncTestCase {
    public void testBasicValidation() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.timeTracking().enable("24", "7", "pretty", "hour", TimeTracking.Mode.LEGACY);
        String key = this.navigation.issue().createIssue("homosapien", "Bug", "time tracking entry");
        this.navigation.issue().setOriginalEstimate(key, "-5h");
        this.assertions.getJiraFormAssertions().assertAuiFieldErrMsg("The original estimate specified is not valid.");
        this.navigation.issue().setOriginalEstimate(key, "5h");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("5h", "5h", "Not Specified");
        this.navigation.issue().logWork(key, "2h");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("5h", "3h", "2h");
        this.navigation.issue().setRemainingEstimate(key, "xxx");
        this.assertions.getJiraFormAssertions().assertAuiFieldErrMsg("The remaining estimate specified is not valid.");
        this.navigation.issue().setRemainingEstimate(key, "1h");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("5h", "1h", "2h");
    }

    public void testDayFractions() {
        this.administration.restoreBlankInstance();
        this.administration.timeTracking().enable("24", "7", "pretty", "hour", TimeTracking.Mode.LEGACY);
        String key = this.navigation.issue().createIssue("homosapien", "Bug", "time tracking entry");
        this.setOriginalEstimate(key, "12.15h");
        this.text.assertTextSequence(new IdLocator(this.getTester(), "tt_single_table_info"), "Estimated:", "12h 9m", "Remaining:", "12h 9m");
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable("24", "7", "hours", "hour", TimeTracking.Mode.LEGACY);
        this.navigation.issue().viewIssue(key);
        this.text.assertTextSequence(new IdLocator(this.getTester(), "tt_single_table_info"), "Estimated:", "12.15h", "Remaining:", "12.15h");
        this.setOriginalEstimate(key, "12m");
        this.text.assertTextSequence(new IdLocator(this.getTester(), "tt_single_table_info"), "Estimated:", "0.2h", "Remaining:", "0.2h");
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable("24", "7", "days", "hour", TimeTracking.Mode.LEGACY);
        this.navigation.issue().viewIssue(key);
        this.text.assertTextNotPresent(new IdLocator(this.getTester(), "tt_single_values_orig"), "0d 0.2h");
        this.text.assertTextNotPresent(new IdLocator(this.getTester(), "tt_single_values_remain"), "0d 0.2h");
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_remain"), "0.2h");
        this.setOriginalEstimate(key, "20m");
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_orig"), "20m");
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_remain"), "20m");
        this.setOriginalEstimate(key, "12.15h");
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable("4.5", "7", "days", "hour", TimeTracking.Mode.LEGACY);
        this.navigation.issue().viewIssue(key);
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_orig"), "2.7d");
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_remain"), "2.7d");
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable("9.5", "7", "days", "hour", TimeTracking.Mode.LEGACY);
        this.navigation.issue().viewIssue(key);
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_orig"), "1d 2.65h");
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_remain"), "1d 2.65h");
        this.navigation.issue().logWork(key, "1m");
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_orig"), "1d 2.65h");
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_remain"), "1d 2h 38m");
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_spent"), "1m");
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable("9.5", "7", "hours", "hour", TimeTracking.Mode.LEGACY);
        this.navigation.issue().viewIssue(key);
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_orig"), "12.15h");
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_remain"), "12h 8m");
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_spent"), "1m");
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable("9.4", "7", "days", "hour", TimeTracking.Mode.LEGACY);
        this.navigation.issue().viewIssue(key);
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_orig"), "1d 2.75h");
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_remain"), "1d 2h 44m");
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_spent"), "1m");
        this.navigation.issue().logWork(key, "1d");
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_orig"), "1d 2.75h");
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_remain"), "2h 44m");
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_spent"), "1d 1m");
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable("9.5", "7", "days", "hour", TimeTracking.Mode.LEGACY);
        this.navigation.issue().viewIssue(key);
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_orig"), "1d 2.65h");
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_remain"), "2h 44m");
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_spent"), "9h 25m");
    }

    private void setOriginalEstimate(String issueKey, String originalEstimate) {
        this.navigation.issue().viewIssue(issueKey);
        this.getTester().clickLink("editIssue");
        this.getTester().assertFormElementPresent("timetracking");
        this.getTester().setFormElement("timetracking", originalEstimate);
        this.getTester().submit();
    }
}

