/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask.move;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryItem;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryRecord;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.meterware.httpunit.WebTable;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMoveSubTaskEnterprise
extends EmailFuncTestCase {
    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestMoveSubTaskEnterprise.xml");
    }

    public void testMoveSubtaskToParentWithNoSecurityLevel() throws SAXException {
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issue().viewIssue("COW-36");
        this.tester.assertTextPresent("MyFriendsOnly");
        this.tester.clickLink("move-issue");
        this.tester.assertTextPresent("Move Sub-Task: Choose Operation");
        this.tester.checkCheckbox("operation", "move.subtask.parent.operation.name");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Move Sub-Task: COW-36");
        this.tester.setFormElement("parentIssue", "COW-39");
        this.tester.submit("Change Parent");
        this.tester.assertTextNotPresent("MyFriendsOnly");
        this.tester.clickLink("return-to-search");
        this.tester.assertTextPresent("Issue Navigator");
        WebTable issueTable = this.getIssueTable();
        TestMoveSubTaskEnterprise.assertEquals((String)"COW-36", (String)issueTable.getCellAsText(7, 1).trim());
        TestMoveSubTaskEnterprise.assertEquals((String)"", (String)issueTable.getCellAsText(7, 11).trim());
        this.assertions.assertLastChangeHistoryRecords("COW-36", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Security", "MyFriendsOnly", ""), new ExpectedChangeHistoryItem("Parent Issue", "COW-35", "COW-39")));
    }

    public void testMoveSubtaskToParentWithSecurityLevel() throws SAXException {
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issue().viewIssue("COW-36");
        this.tester.assertTextPresent("MyFriendsOnly");
        this.tester.clickLink("move-issue");
        this.tester.assertTextPresent("Move Sub-Task: Choose Operation");
        this.tester.checkCheckbox("operation", "move.subtask.parent.operation.name");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Move Sub-Task: COW-36");
        this.tester.setFormElement("parentIssue", "COW-38");
        this.tester.submit("Change Parent");
        this.tester.assertTextNotPresent("MyFriendsOnly");
        IdLocator locator = new IdLocator(this.tester, "security-val");
        this.assertions.getTextAssertions().assertTextPresent(locator, "A");
        this.tester.clickLink("return-to-search");
        this.tester.assertTextPresent("Issue Navigator");
        WebTable issueTable = this.tester.getDialog().getWebTableBySummaryOrId("issuetable");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 1, "COW-36");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 11, "A");
        this.assertions.assertLastChangeHistoryRecords("COW-36", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Security", "MyFriendsOnly", "A"), new ExpectedChangeHistoryItem("Parent Issue", "COW-35", "COW-38")));
    }

    public void testNotifications() throws InterruptedException, MessagingException, IOException {
        GreenMail smtpServer = this.configureAndStartSmtpServer();
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issue().viewIssue("COW-36");
        this.tester.clickLink("move-issue");
        this.tester.checkCheckbox("operation", "move.subtask.parent.operation.name");
        this.tester.submit("Next >>");
        this.tester.setFormElement("parentIssue", "COW-38");
        this.tester.submit("Change Parent");
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = smtpServer.getReceivedMessages();
        TestMoveSubTaskEnterprise.assertEquals((int)2, (int)mimeMessages.length);
        List expectedList = EasyList.build((Object)"admin@example.com", (Object)"Henry.Ford@example.com");
        List receivedList = EasyList.build((Object)mimeMessages[0].getHeader("To")[0], (Object)mimeMessages[1].getHeader("To")[0]);
        TestMoveSubTaskEnterprise.assertEquals(new HashSet(expectedList), new HashSet(receivedList));
        this.assertMailProperties(mimeMessages[0]);
        this.assertMailProperties(mimeMessages[1]);
    }

    private void assertMailProperties(MimeMessage mimeMessage) throws MessagingException, IOException {
        TestMoveSubTaskEnterprise.assertEquals((String)"[JIRATEST] Updated: (COW-36) Get another milk bucket", (String)mimeMessage.getHeader("Subject")[0]);
        TestMoveSubTaskEnterprise.assertEquals((String)"\"Mark (JIRA)\" <jiratest@atlassian.com>", (String)mimeMessage.getHeader("From")[0]);
        String body = GreenMailUtil.getBody((Part)mimeMessage);
        String baseUrl = this.getEnvironmentData().getBaseUrl().toString();
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        LinkedList<String> testStrings = new LinkedList<String>();
        testStrings.add("[ " + baseUrl + "browse/COW-36?page=com.atlassian.jira.plugin.system.issuetabpanels:all-tabpanel ]");
        testStrings.add("Mark updated COW-36:");
        testStrings.add("--------------------");
        testStrings.add("> Get another milk bucket");
        testStrings.add("> -----------------------");
        testStrings.add("Key: COW-36");
        testStrings.add("URL: " + baseUrl + "browse/COW-36");
        testStrings.add("Project: Bovine");
        testStrings.add("Issue Type: Sub-task");
        testStrings.add("Security Level: A(A)");
        testStrings.add("Reporter: Mark");
        testStrings.add("Assignee: Henry Ford");
        testStrings.add("This message is automatically generated by JIRA.");
        testStrings.add("For more information on JIRA, see: http://www.atlassian.com/software/jira");
        this.assertTextSequence(testStrings, body);
        TestMoveSubTaskEnterprise.assertTrue((body.indexOf("Parent Issue: COW-38  (was: COW-35)") > -1 ? 1 : 0) != 0);
        TestMoveSubTaskEnterprise.assertTrue((body.indexOf("Security: A  (was: MyFriendsOnly)") > -1 ? 1 : 0) != 0);
    }

    private String assertTextSequence(List<String> testStrings, String body) {
        for (String test : testStrings) {
            int index = body.indexOf(test);
            if (index < 0) {
                TestMoveSubTaskEnterprise.fail((String)("Unable to find string '" + test + "' in the body of the e-mail message."));
            }
            body = body.substring(index + test.length());
        }
        return body;
    }

    private WebTable getIssueTable() throws SAXException {
        return this.tester.getDialog().getResponse().getTableWithID("issuetable");
    }
}

