/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask.move;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestMoveSubTask
extends JIRAWebTest {
    private String parentIssue1;
    private String parentIssue2;
    private String parentIssue3;
    private String subtask;
    private String subtask2;
    private String subtask3;
    private static final String NEW_SUBTASK_TYPE = "newSubTaskType";
    private static final String STEP_ONE_TITLE = "Choose Operation";
    private static final String STEP_TWO_TITLE = "Operation Details";
    private static final String STEP_THREE_TITLE = "Update Fields";
    private static final String STEP_FOUR_TITLE = "Confirmation";
    private static final String SUBTASK_SUMMARY = "this subtask is moved";

    public TestMoveSubTask(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("blankprojects.xml");
        this.activateSubTasks();
    }

    public void tearDown() {
        this.deactivateSubTasks();
        this.restoreData("blankprojects.xml");
        super.tearDown();
    }

    public void testMoveSubTask() {
        this.parentIssue1 = this.addIssue("homosapien", "HSP", "Bug", "control parent issue in project homosap", "Major", null, null, null, "Administrator", "environment", "description", null, null, null);
        this.subtask = this.addSubTaskToIssue(this.parentIssue1, "Sub-task", SUBTASK_SUMMARY, "description: Test subject");
        this._testMoveSubTaskOperationListVisibility();
        this._testSidePanelLinksForMoveSubTaskType();
        this._testSuccessfulMoveOfSubTaskType();
        this.parentIssue2 = this.addIssue("homosapien", "HSP", "Bug", "control parent issue 2 in project homosap", "Major", null, null, null, "Administrator", "environment", "description", null, null, null);
        this.parentIssue3 = this.addIssue("monkey", "MKY", "Bug", "control parent issue 3 in project monkey", "Major", null, null, null, "Administrator", "environment", "description", null, null, null);
        this.subtask2 = this.addSubTaskToIssue(this.parentIssue1, "Sub-task", "control subtask of parent 1 (homosap)", "description");
        this.subtask3 = this.addSubTaskToIssue(this.parentIssue3, "Sub-task", "control subtask of parent 3 (monkey)", "description");
        this._testSidePanelLinksForMoveSubTaskParent();
        this._testValidateMoveSubTaskParent();
        this._testSuccessfulMoveOfSubTaskParent();
        this.deleteSubTaskType(NEW_SUBTASK_TYPE);
    }

    private void _testMoveSubTaskOperationListVisibility() {
        TestMoveSubTask.log("Check move_issue link is hidden with no permission");
        this.removeGroupPermission(25, "jira-developers");
        this.gotoIssue(this.subtask);
        this.assertLinkNotPresent("move-issue");
        this.grantGroupPermission(25, "jira-developers");
        TestMoveSubTask.log("Check move subtask type operation cannot be perfomed");
        this.gotoIssue(this.subtask);
        this.clickLink("move-issue");
        this.assertRadioOptionNotPresent("operation", "move.subtask.type.operation.name");
        this.assertRadioOptionPresent("operation", "move.subtask.parent.operation.name");
        TestMoveSubTask.log("Check move subtask type operation can be performed");
        this.addNewSubTaskType();
        this.gotoIssue(this.subtask);
        this.clickLink("move-issue");
        this.assertRadioOptionPresent("operation", "move.subtask.type.operation.name");
        this.assertRadioOptionPresent("operation", "move.subtask.parent.operation.name");
    }

    private void _testSuccessfulMoveOfSubTaskType() {
        this.addNewSubTaskType();
        this.gotoStep1ofMoveSubTaskType();
        this.assertFormElementPresent("issuetype");
        this.selectOption("issuetype", NEW_SUBTASK_TYPE);
        this.submit("Next >>");
        this.submit("Next >>");
        this.assertTextPresentBeforeText("Type", "Sub-task");
        this.assertTextPresentBeforeText("Sub-task", NEW_SUBTASK_TYPE);
        this.submit("Move");
        this.assertLastChangeHistoryIs(this.subtask, "Issue Type", "Sub-task", NEW_SUBTASK_TYPE);
    }

    private void addNewSubTaskType() {
        this.activateSubTasks();
        this.setFormElement("name", NEW_SUBTASK_TYPE);
        this.setFormElement("description", "temporary subtask type");
        this.submit("Add");
    }

    private void _testSidePanelLinksForMoveSubTaskType() {
        this.gotoStep2ofMoveSubTaskType();
        this.assertTextPresent("Step 1 of 4");
        this.gotoStep3ofMoveSubTaskType();
        this.clickLinkWithText(STEP_ONE_TITLE);
        this.assertTextPresent("Step 1 of 4");
        this.gotoStep3ofMoveSubTaskType();
        this.clickLinkWithText(STEP_TWO_TITLE);
        this.assertTextPresent("Step 2 of 4");
        this.gotoStep4ofMoveSubTaskType();
        this.clickLinkWithText(STEP_ONE_TITLE);
        this.assertTextPresent("Step 1 of 4");
        this.gotoStep4ofMoveSubTaskType();
        this.clickLinkWithText(STEP_TWO_TITLE);
        this.assertTextPresent("Step 2 of 4");
        this.gotoStep4ofMoveSubTaskType();
        this.clickLinkWithText(STEP_THREE_TITLE);
        this.assertTextPresent("Step 3 of 4");
    }

    private void _testWizardCancelForMoveSubTaskType() {
        this.gotoMoveSubTaskChooseOperation();
        this.checkCancelRedirectsViewIssue();
        this.gotoStep1ofMoveSubTaskType();
        this.checkCancelRedirectsViewIssue();
        this.gotoStep2ofMoveSubTaskType();
        this.checkCancelRedirectsViewIssue();
        this.gotoStep3ofMoveSubTaskType();
        this.checkCancelRedirectsViewIssue();
        this.gotoStep4ofMoveSubTaskType();
        this.checkCancelRedirectsViewIssue();
    }

    private void checkCancelRedirectsViewIssue() {
        this.assertFormElementPresent("Cancel");
        this.clickAnyButtonWithValue("Cancel");
        this.assertTextNotPresent("Step ");
        this.assertLinkPresentWithText(this.subtask);
        this.assertLinkPresentWithText("move-issue");
    }

    private void gotoMoveSubTaskChooseOperation() {
        this.gotoIssue(this.subtask);
        this.clickLink("move-issue");
        this.assertTextPresent("Step 1 of 4");
    }

    private void gotoStep1ofMoveSubTaskType() {
        this.gotoMoveSubTaskChooseOperation();
        this.checkCheckbox("operation", "move.subtask.type.operation.name");
        this.submit("Next >>");
    }

    private void gotoStep2ofMoveSubTaskType() {
        this.gotoStep1ofMoveSubTaskType();
        this.assertLinkPresentWithText(STEP_ONE_TITLE);
        this.assertLinkNotPresentWithText(STEP_TWO_TITLE);
        this.assertLinkNotPresentWithText(STEP_THREE_TITLE);
        this.assertLinkNotPresentWithText(STEP_FOUR_TITLE);
        this.clickLinkWithText(STEP_ONE_TITLE);
    }

    private void gotoStep3ofMoveSubTaskType() {
        this.gotoStep1ofMoveSubTaskType();
        this.submit("Next >>");
        this.assertLinkPresentWithText(STEP_ONE_TITLE);
        this.assertLinkPresentWithText(STEP_TWO_TITLE);
        this.assertLinkNotPresentWithText(STEP_THREE_TITLE);
        this.assertLinkNotPresentWithText(STEP_FOUR_TITLE);
    }

    private void gotoStep4ofMoveSubTaskType() {
        this.gotoStep1ofMoveSubTaskType();
        this.submit("Next >>");
        this.submit("Next >>");
        this.assertLinkPresentWithText(STEP_ONE_TITLE);
        this.assertLinkPresentWithText(STEP_TWO_TITLE);
        this.assertLinkPresentWithText(STEP_THREE_TITLE);
        this.assertLinkNotPresentWithText(STEP_FOUR_TITLE);
    }

    private void gotoStep4ofMoveSubTaskParent() {
        this.gotoMoveSubTaskChooseOperation();
        this.checkCheckbox("operation", "move.subtask.parent.operation.name");
        this.submit("Next >>");
    }

    private void _testValidateMoveSubTaskParent() {
        this.gotoStep4ofMoveSubTaskParent();
        this.setFormElement("parentIssue", "");
        this.submit("Change Parent");
        this.assertTextPresent("Parent Issue is a required field");
        this.setFormElement("parentIssue", "dontExist");
        this.submit("Change Parent");
        this.assertTextPresent("The issue key &quot;dontExist&quot; does not exist");
        this.setFormElement("parentIssue", this.subtask);
        this.submit("Change Parent");
        this.assertTextPresent("Issue cannot be its own parent");
        this.setFormElement("parentIssue", this.parentIssue1);
        this.submit("Change Parent");
        this.assertTextPresent("Already linked to this parent issue");
        this.setFormElement("parentIssue", this.parentIssue3);
        this.submit("Change Parent");
        this.assertTextPresent("Cannot link Parent issue from a different project");
        this.setFormElement("parentIssue", this.subtask2);
        this.submit("Change Parent");
        this.assertTextPresent("Subtasks cannot be a parent issue");
        this.setFormElement("parentIssue", this.subtask3);
        this.submit("Change Parent");
        this.assertTextPresent("Subtasks cannot be a parent issue");
    }

    private void _testWizardCancelForMoveSubTaskParent() {
        this.gotoMoveSubTaskChooseOperation();
        this.checkCancelRedirectsViewIssue();
        this.gotoStep4ofMoveSubTaskParent();
        this.checkCancelRedirectsViewIssue();
    }

    private void _testSuccessfulMoveOfSubTaskParent() {
        this.gotoStep4ofMoveSubTaskParent();
        this.setFormElement("parentIssue", this.parentIssue2);
        this.submit("Change Parent");
        this.assertTextNotPresent("Step 4 of 4");
        this.assertLastChangeHistoryIs(this.subtask, "Parent Issue", this.parentIssue1, this.parentIssue2);
    }

    private void _testSidePanelLinksForMoveSubTaskParent() {
        this.gotoStep4ofMoveSubTaskParent();
        this.assertLinkPresentWithText(STEP_ONE_TITLE);
        this.assertLinkNotPresentWithText(STEP_TWO_TITLE);
        this.assertLinkNotPresentWithText(STEP_THREE_TITLE);
        this.assertLinkNotPresentWithText(STEP_FOUR_TITLE);
        this.clickLinkWithText(STEP_ONE_TITLE);
        this.assertTextPresent("Step 1 of 4");
        this.assertLinkNotPresentWithText(STEP_ONE_TITLE);
        this.assertLinkNotPresentWithText(STEP_TWO_TITLE);
        this.assertLinkNotPresentWithText(STEP_THREE_TITLE);
        this.assertLinkNotPresentWithText(STEP_FOUR_TITLE);
    }

    public void testMoveParentSubTaskLinks() {
        String origParentName = "First Parent";
        String firstParent = this.addIssue("monkey", "MKY", "Bug", origParentName, "Major", null, null, null, null, null, null, null, null, null);
        String newParent = this.addIssue("monkey", "MKY", "Bug", "Second Parent", "Major", null, null, null, null, null, null, null, null, null);
        String childKey = this.addSubTaskToIssue(firstParent, "Sub-task", "subtask originally on First Parent", "sub bug");
        String linkageName = "linkoid";
        String linkLabel = "is linked to";
        this.createIssueLinkType(linkageName, linkLabel, linkLabel);
        this.linkIssueWithComment(childKey, linkLabel, firstParent, null, null);
        this.activateIssueLinking();
        this.gotoIssue(childKey);
        this.clickLink("move-issue");
        this.checkCheckbox("operation", "move.subtask.parent.operation.name");
        this.submit("Next >>");
        this.setFormElement("parentIssue", newParent);
        this.submit("Change Parent");
        this.assertTextSequence(new String[]{"This issue", linkLabel, firstParent, origParentName});
    }
}

