/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestSubTaskToIssueConversionStep1
extends JIRAWebTest {
    private static final String BUG_KEY = "HSP-1";
    private static final String BUG_ID = "10000";
    private static final String SUBTASK_KEY = "HSP-3";
    private static final String SUBTASK_ID = "10002";
    private static final String SUBTASK_KEY_NO_FEATURES_IN_SCHEME = "MKY-2";
    private static final String SUBTASK_ID_NO_FEATURES_IN_SCHEME = "10021";
    private static final String FEATURE_KEY = "HSP-4";
    private static final String FEATURE_ID = "10010";
    private static final String TASK_KEY = "HSP-5";
    private static final String IMPROVEMENT_KEY = "HSP-6";
    private static final String INVALID_ISSUE_ID = "9999";

    public TestSubTaskToIssueConversionStep1(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestSubTaskToIssueConversion.xml");
    }

    public void testSubTaskToIssueConversionEditPermission() {
        this.gotoIssue(SUBTASK_KEY);
        this.assertLinkPresent("subtask-to-issue");
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(SUBTASK_KEY);
        this.assertLinkNotPresent("subtask-to-issue");
        this.gotoConvertSubTask(SUBTASK_ID);
        this.assertTextPresent("Access Denied");
        this.assertTextNotPresent("Step 1 of 4");
        this.logout();
        this.gotoConvertSubTask(SUBTASK_ID);
        this.assertTextPresent("Access Denied");
    }

    public void testSubTaskToIssueConversionCheckIssueType() {
        this.gotoIssue(SUBTASK_KEY);
        this.assertLinkPresent("subtask-to-issue");
        this.gotoIssue(BUG_KEY);
        this.assertLinkNotPresent("subtask-to-issue");
        this.gotoIssue(FEATURE_KEY);
        this.assertLinkNotPresent("subtask-to-issue");
        this.gotoIssue(TASK_KEY);
        this.assertLinkNotPresent("subtask-to-issue");
        this.gotoIssue(IMPROVEMENT_KEY);
        this.assertLinkNotPresent("subtask-to-issue");
        this.gotoConvertSubTask(FEATURE_ID);
        this.assertTextPresent("Issue HSP-4 is not a sub-task");
        this.assertTextNotPresent("Step 1 of 4");
        this.assertTextPresentBeforeText("Return to", FEATURE_KEY);
        this.assertLinkPresentWithText(FEATURE_KEY);
        this.gotoConvertSubTask(SUBTASK_ID);
        this.assertTextPresent("Step 1 of 4");
    }

    public void testIssueToSubTaskConversionInvalidIssue() {
        this.gotoConvertSubTask(SUBTASK_ID);
        this.assertTextPresent("Step 1 of 4");
        this.gotoConvertSubTask(INVALID_ISSUE_ID);
        this.assertTextPresent("Errors");
        this.assertTextPresent("Issue not found");
        this.assertTextNotPresent("Step 1 of 4");
        this.assertTextPresentBeforeText("Return to", "Dashboard");
        this.assertLinkPresentWithText("Dashboard");
    }

    public void testIssueToSubTaskConversionIssueType() {
        this.gotoConvertSubTask(SUBTASK_ID);
        this.assertOptionsEqual("issuetype", new String[]{"Bug", "New Feature", "Task", "Improvement"});
        this.assertOptionNotPresent("issuetype", "Sub-task");
        this.gotoConvertSubTask(SUBTASK_ID_NO_FEATURES_IN_SCHEME);
        this.assertOptionsEqual("issuetype", new String[]{"Bug", "Improvement", "Task"});
        this.assertOptionNotPresent("issuetype", "New Feature");
        this.gotoConvertSubTaskStep2(SUBTASK_ID_NO_FEATURES_IN_SCHEME, "2");
        this.assertTextPresent("Step 1 of 4");
        this.assertTextPresent("Issue type New Feature not applicable for this project");
        this.gotoConvertSubTaskStep2(SUBTASK_ID_NO_FEATURES_IN_SCHEME, INVALID_ISSUE_ID);
        this.assertTextPresent("Step 1 of 4");
        this.assertTextPresent("Selected issue type not found.");
        this.gotoConvertSubTaskStep2(SUBTASK_ID_NO_FEATURES_IN_SCHEME, "");
        this.assertTextPresent("Step 1 of 4");
        this.assertTextPresent("Issue type not specified");
        this.gotoConvertSubTaskStep2(SUBTASK_ID_NO_FEATURES_IN_SCHEME, "5");
        this.assertTextPresent("Step 1 of 4");
        this.assertTextPresent("Issue type Sub-task is a sub-task");
    }
}

