/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestViewProjectOperationsWebFragment
extends JIRAWebTest {
    private static final String NEW_HOMOSAP_NAME = "homosapien test";

    public TestViewProjectOperationsWebFragment(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestWebFragment.xml");
    }

    public void tearDown() {
        this.login("admin", "admin");
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testLinkVisibilityOnViewProjectForNonUsers() {
        this.logout();
        this.beginAt("secure/project/ViewProject.jspa?pid=10000");
        this.assertTextPresent("Access Denied");
        this.assertLinkNotPresent("browse_project");
        this.assertLinkNotPresent("edit_project");
        this.assertLinkNotPresent("delete_project");
    }

    public void testLinkVisibilityOnViewProjectForProjectAdmin() {
        this.login("project_admin", "project_admin");
        this.assertLinkPresentAndWorks("homosapien", "browse_project", "homosapien");
        this.assertEditProjectIsPresentAndWorks("homosapien", NEW_HOMOSAP_NAME);
        this.goToProject(NEW_HOMOSAP_NAME);
        this.assertLinkNotPresent("delete_project");
    }

    public void testLinkVisibilityOnViewProjectForSystemAdmin() {
        this.login("admin", "admin");
        this.assertLinkPresentAndWorks("homosapien", "browse_project", "homosapien");
        this.assertEditProjectIsPresentAndWorks("homosapien", NEW_HOMOSAP_NAME);
        this.assertDeleteProjectIsPresentAndWorks(NEW_HOMOSAP_NAME);
    }

    private void assertLinkPresentAndWorks(String project, String linkId, String textToAssertOnPage) {
        this.goToProject(project);
        this.assertLinkPresent(linkId);
        this.clickLink(linkId);
        this.assertTextPresent(textToAssertOnPage);
    }

    private void assertEditProjectIsPresentAndWorks(String projectName, String newProjectName) {
        this.goToProject(projectName);
        this.assertTextPresent("Project: " + projectName);
        this.assertLinkPresent("edit_project");
        this.clickLink("edit_project");
        this.assertTextPresent("Edit Project: " + projectName);
        this.setFormElement("name", newProjectName);
        this.submit("Update");
        this.assertTextPresent("Project: " + newProjectName);
        this.assertLinkPresent("edit_project");
    }

    private void assertDeleteProjectIsPresentAndWorks(String projectName) {
        this.goToProject(projectName);
        this.clickLink("delete_project");
        this.submit("Delete");
        this.assertTextPresent("Below is the list of all 1  projects for this installation of JIRA");
        this.assertLinkPresentWithText("monkey");
        this.assertLinkNotPresentWithText("homosapien");
    }
}

