/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;

public class TestDeleteProject
extends FuncTestCase {
    protected void setUpTest() {
        this.administration.restoreData("TestDeleteProject.xml");
    }

    public void testDeleteProjectSuccess() {
        this.assertProjectDeletedInStandardEdition();
    }

    public void testDeleteProjectNoPermission() {
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.tester.gotoPage("secure/project/DeleteProject.jspa?pid=10000&confirm=true&returnUrl=ViewProjects.jspa");
        this.tester.assertTextPresent("Welcome to jWebTest JIRA installation");
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.gotoAdminSection("view_projects");
        this.tester.assertTextPresent("homosapien");
    }

    public void testDeleteProjectEnterprise() {
        this.administration.restoreData("TestDeleteProjectEnterprise.xml");
        this.assertProjectDeletedInStandardEdition();
        this.navigation.gotoAdminSection("security_schemes");
        this.tester.assertTextPresent("Issue Security Schemes allow you to control who can and cannot view issues.");
        this.tester.assertTextNotPresent("homosapien");
        this.navigation.gotoAdminSection("workflow_schemes");
        this.tester.assertTextPresent("Workflow Schemes allow you to define which workflows apply to given issue types and projects.");
        this.tester.assertTextNotPresent("homosapien");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "workflow_schemes_table", 1, 2), "Inactive");
        this.navigation.gotoAdminSection("issue_fields");
        this.tester.assertTextPresent("The table below shows the current Field Configuration Schemes and the projects they are associated with.");
        this.tester.assertTextNotPresent("homosapien");
        this.navigation.gotoAdminSection("issue_type_screen_scheme");
        this.tester.assertTextPresent("The table below shows existing Issue Type Screen Schemes.");
        this.tester.assertTextNotPresent("homosapien");
    }

    public void testDeleteProjectNotExists() {
        this.tester.gotoPage("secure/project/DeleteProject.jspa?pid=20000&confirm=true&returnUrl=ViewProjects.jspa&atl_token=" + this.page.getXsrfToken());
        this.tester.assertTextPresent("Delete Project");
        this.assertions.getJiraFormAssertions().assertFormErrMsg("Project with id '20,000' does not exist. Perhaps it was deleted?");
    }

    private void assertProjectDeletedInStandardEdition() {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.assertTextPresent("homosapien");
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.assertTextPresent("Test issue 1");
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.assertTextPresent("JIRA needs to be more Web 2.0");
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLink("delete_project_10000");
        this.tester.assertTextPresent("Delete Project: homosapien");
        this.tester.submit("Delete");
        this.tester.assertTextPresent("Below is the list of all 1  projects for this installation of JIRA.");
        this.tester.assertTextNotPresent("homosapien");
        this.navigation.gotoAdminSection("notification_schemes");
        this.tester.assertTextPresent("Notification Schemes");
        this.tester.assertTextPresent("The table below shows the notification schemes currently configured for this server");
        this.tester.assertTextNotPresent("homosapien");
        this.navigation.gotoAdminSection("permission_schemes");
        this.tester.assertTextPresent("Permission Schemes");
        this.tester.assertTextPresent("Permission Schemes allow you to create a set of permissions and apply this set of permissions to any project.");
        this.tester.assertTextNotPresent("homosapien");
        this.navigation.gotoAdminSection("view_custom_fields");
        this.tester.assertTextPresent("View Custom Fields");
        this.tester.assertTextNotPresent("homosapien");
        this.tester.assertTextPresent("Not configured for any context");
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.assertTextPresent("The issue you are trying to view does not exist.");
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.assertTextPresent("The issue you are trying to view does not exist.");
    }
}

