/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class TestBrowseProjectCreateIssue
extends FuncTestCase {
    private static final String NEW_COMPONENT_1 = "New Component 1";
    private static final String NEW_VERSION_1 = "New Version 1";
    private static final String VERSIONS = "Versions";

    protected void setUpTest() {
        this.administration.restoreData("testBrowseProjectCreateIssue.xml");
    }

    public void testRespectPermission() throws IOException {
        this.navigation.logout();
        this.navigation.browseProject("HSP");
        XPathLocator locator = new XPathLocator(this.tester, "//div[@id='content-top']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        this.text.assertTextPresent(locator, "homosapien");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertFalse((boolean)locator.exists());
        this.tester.clickLinkWithText(VERSIONS);
        this.tester.clickLinkWithText(NEW_VERSION_1);
        locator = new XPathLocator(this.tester, "//div[@id='content-top']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        this.text.assertTextPresent(locator, "homosapien");
        this.text.assertTextPresent(locator, NEW_VERSION_1);
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        TestBrowseProjectCreateIssue.assertTrue((boolean)StringUtils.isBlank((String)locator.getText()));
        this.navigation.browseProject("HSP");
        this.tester.clickLinkWithText("Components");
        this.tester.clickLinkWithText(NEW_COMPONENT_1);
        locator = new XPathLocator(this.tester, "//div[@id='content-top']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        this.text.assertTextPresent(locator, "homosapien");
        this.text.assertTextPresent(locator, NEW_COMPONENT_1);
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertFalse((boolean)locator.exists());
        this.navigation.browseProject("THREE");
        locator = new XPathLocator(this.tester, "//div[@id='content-top']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        this.text.assertTextPresent(locator, "3 ISSUE TYPES");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertFalse((boolean)locator.exists());
        this.navigation.browseProject("TWO");
        locator = new XPathLocator(this.tester, "//div[@id='content-top']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[1]");
        this.text.assertTextPresent(locator, "Bug");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[2]");
        this.text.assertTextPresent(locator, "Task");
        this.navigation.login("user2");
        this.navigation.browseProject("HSP");
        locator = new XPathLocator(this.tester, "//div[@id='content-top']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        this.text.assertTextPresent(locator, "homosapien");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[1]");
        this.text.assertTextPresent(locator, "Task");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[2]");
        this.text.assertTextPresent(locator, "New Feature");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[3]");
        this.text.assertTextSequence(locator, "Other", "Bug", "Improvement");
        this.tester.clickLinkWithText(VERSIONS);
        this.tester.clickLinkWithText(NEW_VERSION_1);
        locator = new XPathLocator(this.tester, "//div[@id='content-top']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        this.text.assertTextPresent(locator, "homosapien");
        this.text.assertTextPresent(locator, NEW_VERSION_1);
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[1]");
        this.text.assertTextPresent(locator, "Task");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[2]");
        this.text.assertTextPresent(locator, "New Feature");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[3]");
        this.text.assertTextSequence(locator, "Other", "Bug", "Improvement");
        this.navigation.browseProject("HSP");
        this.tester.clickLinkWithText("Components");
        this.tester.clickLinkWithText(NEW_COMPONENT_1);
        locator = new XPathLocator(this.tester, "//div[@id='content-top']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        this.text.assertTextPresent(locator, "homosapien");
        this.text.assertTextPresent(locator, NEW_COMPONENT_1);
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[1]");
        this.text.assertTextPresent(locator, "Task");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[2]");
        this.text.assertTextPresent(locator, "New Feature");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[3]");
        this.text.assertTextSequence(locator, "Other", "Bug", "Improvement");
        this.navigation.browseProject("THREE");
        locator = new XPathLocator(this.tester, "//div[@id='content-top']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        this.text.assertTextPresent(locator, "3 ISSUE TYPES");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[1]");
        this.text.assertTextPresent(locator, "Bug");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[2]");
        this.text.assertTextPresent(locator, "Improvement");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[3]");
        this.text.assertTextPresent(locator, "New Feature");
        this.navigation.browseProject("TWO");
        locator = new XPathLocator(this.tester, "//div[@id='content-top']");
        this.text.assertTextPresent(locator, "Two Issue Types");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[1]");
        this.text.assertTextPresent(locator, "Bug");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[2]");
        this.text.assertTextPresent(locator, "Task");
        this.navigation.browseProject("HIDDEN");
        this.text.assertTextPresent(this.tester.getDialog().getResponse().getText(), "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.navigation.login("fred");
        this.navigation.browseProject("HSP");
        locator = new XPathLocator(this.tester, "//div[@id='content-top']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        this.text.assertTextPresent(locator, "homosapien");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[1]");
        this.text.assertTextPresent(locator, "New Feature");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[2]");
        this.text.assertTextPresent(locator, "Task");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[3]");
        this.text.assertTextSequence(locator, "Other", "Bug", "Improvement");
        this.tester.clickLinkWithText(VERSIONS);
        this.tester.clickLinkWithText(NEW_VERSION_1);
        locator = new XPathLocator(this.tester, "//div[@id='content-top']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        this.text.assertTextPresent(locator, "homosapien");
        this.text.assertTextPresent(locator, NEW_VERSION_1);
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[1]");
        this.text.assertTextPresent(locator, "New Feature");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[2]");
        this.text.assertTextPresent(locator, "Task");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[3]");
        this.text.assertTextSequence(locator, "Other", "Bug", "Improvement");
        this.navigation.browseProject("HSP");
        this.tester.clickLinkWithText("Components");
        this.tester.clickLinkWithText(NEW_COMPONENT_1);
        locator = new XPathLocator(this.tester, "//div[@id='content-top']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        this.text.assertTextPresent(locator, "homosapien");
        this.text.assertTextPresent(locator, NEW_COMPONENT_1);
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[1]");
        this.text.assertTextPresent(locator, "New Feature");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[2]");
        this.text.assertTextPresent(locator, "Task");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[3]");
        this.text.assertTextSequence(locator, "Other", "Bug", "Improvement");
        this.navigation.browseProject("THREE");
        locator = new XPathLocator(this.tester, "//div[@id='content-top']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        this.text.assertTextPresent(locator, "3 ISSUE TYPES");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[1]");
        this.text.assertTextPresent(locator, "Bug");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[2]");
        this.text.assertTextPresent(locator, "Improvement");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[3]");
        this.text.assertTextPresent(locator, "New Feature");
        this.navigation.browseProject("TWO");
        locator = new XPathLocator(this.tester, "//div[@id='content-top']");
        this.text.assertTextPresent(locator, "Two Issue Types");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[1]");
        this.text.assertTextPresent(locator, "Bug");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[2]");
        this.text.assertTextPresent(locator, "Task");
        this.navigation.browseProject("HIDDEN");
        locator = new XPathLocator(this.tester, "//div[@id='content-top']");
        this.text.assertTextPresent(locator, "No can see");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertFalse((boolean)locator.exists());
    }

    public void testCustomCreateButtons() {
        this.navigation.logout();
        this.navigation.browseProject("HSP");
        XPathLocator locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertFalse((boolean)locator.exists());
        this.navigation.login("fred");
        this.navigation.browseProject("HSP");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[1]");
        this.text.assertTextPresent(locator, "New Feature");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[2]");
        this.text.assertTextPresent(locator, "Task");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[3]");
        this.text.assertTextSequence(locator, "Other", "Bug", "Improvement");
        this.navigation.login("user2");
        this.navigation.browseProject("HSP");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[1]");
        this.text.assertTextPresent(locator, "Task");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[2]");
        this.text.assertTextPresent(locator, "New Feature");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[3]");
        this.text.assertTextSequence(locator, "Other", "Bug", "Improvement");
        this.navigation.login("admin");
        this.navigation.browseProject("HSP");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[1]");
        this.text.assertTextPresent(locator, "New Feature");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[2]");
        this.text.assertTextPresent(locator, "Bug");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[3]");
        this.text.assertTextSequence(locator, "Other", "Task", "Improvement");
        this.navigation.login("user2");
        this.navigation.issue().createIssue("homosapien", "Improvement", "My first improvement");
        this.navigation.browseProject("HSP");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[1]");
        this.text.assertTextPresent(locator, "Improvement");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[2]");
        this.text.assertTextPresent(locator, "Task");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[3]");
        this.text.assertTextSequence(locator, "Other", "Bug", "New Feature");
        this.navigation.login("fred");
        this.navigation.browseProject("HSP");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[1]");
        this.text.assertTextPresent(locator, "Improvement");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[2]");
        this.text.assertTextPresent(locator, "New Feature");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[3]");
        this.text.assertTextSequence(locator, "Other", "Bug", "Task");
    }

    public void testDifferentNumberOfTypes() {
        this.navigation.login("admin");
        this.navigation.browseProject("HSP");
        XPathLocator locator = new XPathLocator(this.tester, "//div[@id='create-issue']");
        TestBrowseProjectCreateIssue.assertTrue((boolean)locator.exists());
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[1]");
        this.text.assertTextPresent(locator, "New Feature");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[2]");
        this.text.assertTextPresent(locator, "Bug");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[3]");
        this.text.assertTextSequence(locator, "Other", "Task", "Improvement");
        this.navigation.browseProject("ONE");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[1]");
        this.text.assertTextPresent(locator, "Improvement");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[2]");
        TestBrowseProjectCreateIssue.assertFalse((boolean)locator.exists());
        this.navigation.browseProject("TWO");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[1]");
        this.text.assertTextPresent(locator, "Bug");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[2]");
        this.text.assertTextPresent(locator, "Task");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[3]");
        TestBrowseProjectCreateIssue.assertFalse((boolean)locator.exists());
        this.navigation.browseProject("THREE");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[1]");
        this.text.assertTextPresent(locator, "Bug");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[2]");
        this.text.assertTextPresent(locator, "Improvement");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[3]");
        this.text.assertTextPresent(locator, "New Feature");
        this.text.assertTextNotPresent(locator, "Other");
        locator = new XPathLocator(this.tester, "//div[@id='create-issue']/ul/li[4]");
        TestBrowseProjectCreateIssue.assertFalse((boolean)locator.exists());
    }
}

