/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.Splitable;
import com.atlassian.jira.functest.framework.assertions.IssueNavigatorAssertions;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigator.AssigneeCondition;
import com.atlassian.jira.functest.framework.navigator.NavigatorCondition;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearch;
import com.atlassian.jira.functest.framework.navigator.ReporterCondition;
import com.atlassian.jira.functest.framework.navigator.UserGroupPicker;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermissionUtils;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import junit.framework.Assert;

@Splitable
public class TestJqlSystemFunctions
extends AbstractJqlFuncTest {
    public void testCascadeOption() {
        this.administration.restoreData("TestCascadeOptionFunction.xml");
        this.createSearchAndAssertIssues("project in (HSP, MKY) and CS1 in cascadeOption(a)", "MKY-2", "HSP-4", "HSP-2");
        this.assertTooComplex();
        String query = "project in (MKY) and CS1 in cascadeOption(10011)";
        this.createSearchAndAssertIssues(query, "MKY-4", "MKY-3");
        this.assertions.getIssueNavigatorAssertions().assertJqlFitsInFilterForm(query, TestJqlSystemFunctions.createParam("customfield_10000", "10004"), TestJqlSystemFunctions.createParam("customfield_10000:1", ""));
        query = "project in (MKY) and CS1 in cascadeOption(10011, child)";
        this.createSearchAndAssertIssues(query, "MKY-3");
        this.assertions.getIssueNavigatorAssertions().assertJqlFitsInFilterForm(query, TestJqlSystemFunctions.createParam("customfield_10000", "10004"), TestJqlSystemFunctions.createParam("customfield_10000:1", "10006"));
        this.createSearchAndAssertIssues("project in (HSP, MKY) and CS1 in cascadeOption(a, None)", "MKY-2", "HSP-2");
        this.assertTooComplex();
        query = "project in (MKY) and CS1 in cascadeOption(10011, '\"none\"')";
        this.createSearchAndAssertIssues(query, "MKY-4");
        this.assertions.getIssueNavigatorAssertions().assertJqlFitsInFilterForm(query, TestJqlSystemFunctions.createParam("customfield_10000", "10004"), TestJqlSystemFunctions.createParam("customfield_10000:1", "10008"));
        query = "project in (MKY) and CS1 in cascadeOption('\"none\"')";
        this.createSearchAndAssertIssues(query, "MKY-1");
        this.assertions.getIssueNavigatorAssertions().assertJqlFitsInFilterForm(query, TestJqlSystemFunctions.createParam("customfield_10000", "10005"));
        this.createSearchAndAssertIssues("project in (MKY) and CS1 in cascadeOption(none)", "MKY-5");
        this.assertTooComplex();
        this.navigation.issueNavigator().gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.selectOption("pid", "homosapien");
        this.tester.submit("show");
        this.tester.selectOption("customfield_10000", "a");
        this.tester.selectOption("customfield_10000:1", "ac");
        this.tester.submit("show");
        this.tester.clickLink("switchnavtype");
        String jql = this.tester.getDialog().getFormParameterValue("jqlQuery");
        Assert.assertEquals((String)"project = HSP AND CS1 in cascadeOption(10000, 10009)", (String)jql);
        this.navigation.issueNavigator().createSearch("CS1 in cascadeOption(notaparent)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("The option 'notaparent' specified in function 'cascadeOption' is not a valid parent option.");
        this.navigation.issueNavigator().createSearch("CS1 in cascadeOption(99999)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("The option '99999' specified in function 'cascadeOption' is not a valid parent option.");
        this.navigation.issueNavigator().createSearch("CS1 in cascadeOption(a, fakechild)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("The option 'fakechild' is not a child of option 'a' in function 'cascadeOption'.");
        this.navigation.issueNavigator().createSearch("CS1 in cascadeOption(a, 999999)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("The option '999999' is not a child of option 'a' in function 'cascadeOption'.");
        this.navigation.issueNavigator().createSearch("CS2 in cascadeOption(a, ac)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("The option 'a' specified in function 'cascadeOption' is not a valid parent option.");
        this.navigation.issueNavigator().createSearch("CS2 in cascadeOption(a)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("The option 'a' specified in function 'cascadeOption' is not a valid parent option.");
        this.navigation.issueNavigator().createSearch("CS2 in cascadeOption(None, a)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("The option 'None' specified in function 'cascadeOption' is not a valid parent option.");
        this.navigation.issueNavigator().createSearch("issue in cascadeOption(a)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("The field 'issue' is not supported by the function 'cascadeOption'.");
    }

    public void testAllReleasedVersions() throws Exception {
        this.administration.restoreData("TestJqlReleasedVersionsFunctions.xml");
        this.createSearchAndAssertIssues("fixVersion in releasedVersions()", "NUMBER-2", "MKY-2", "MK-2", "HSP-3");
        this.createSearchAndAssertIssues("affectedVersion in releasedVersions()", "NUMBER-1", "MKY-1", "MK-1", "HSP-1");
        this.createSearchAndAssertIssues("VP in releasedVersions()", "NUMBER-1", "MKY-1", "MK-1", "HSP-1");
        this.createSearchAndAssertIssues("VP in releasedVersions(HSP)", "HSP-1");
        this.createSearchAndAssertIssues("VP in releasedVersions(hsp)", "HSP-1");
        this.createSearchAndAssertIssues("VP in releasedVersions(homosapien)", "HSP-1");
        this.createSearchAndAssertIssues("VP in releasedVersions(HOMOSAPIEN)", "HSP-1");
        this.createSearchAndAssertIssues("VP in releasedVersions(10000)", "NUMBER-1");
        this.createSearchAndAssertIssues("VP in releasedVersions(monkey)", "MKY-1");
        this.createSearchAndAssertIssues("VP in releasedVersions(MKY)", "MKY-1");
        this.createSearchAndAssertIssues("VP in releasedVersions(MK)", "MK-1");
        this.createSearchAndAssertIssues("VP in releasedVersions(10001)", "MKY-1");
        this.navigation.issueNavigator().loadFilter(10000L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.tester.assertTextPresent("VP in releasedVersions(HSP)");
        this.navigation.logout();
        this.navigation.login("fred");
        this.createSearchAndAssertIssues("fixVersion in releasedVersions()", "NUMBER-2", "MKY-2", "MK-2");
        this.createSearchAndAssertIssues("affectedVersion in releasedVersions()", "NUMBER-1", "MKY-1", "MK-1");
        this.navigation.issueNavigator().loadFilter(10000L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.tester.assertTextPresent("VP in releasedVersions(10000)");
        this.tester.clickLink("find_link");
        this.tester.clickLink("new_filter");
        this.tester.clickLink("switchnavtype");
        this.tester.selectOption("pid", "10000");
        this.tester.submit("show");
        this.tester.selectOption("fixfor", "Released Versions");
        this.tester.submit("show");
        this.tester.clickLink("switchnavtype");
        String jql = this.tester.getDialog().getFormParameterValue("jqlQuery");
        Assert.assertEquals((String)"project = \"NUMBER\" AND fixVersion in releasedVersions()", (String)jql);
        this.tester.clickLink("find_link");
        this.tester.clickLink("new_filter");
        this.tester.clickLink("switchnavtype");
        this.tester.selectOption("pid", "10000");
        this.tester.submit("show");
        this.tester.selectOption("version", "Released Versions");
        this.tester.submit("show");
        this.tester.clickLink("switchnavtype");
        jql = this.tester.getDialog().getFormParameterValue("jqlQuery");
        Assert.assertEquals((String)"project = \"NUMBER\" AND affectedVersion in releasedVersions()", (String)jql);
    }

    public void testAllUnreleasedVersions() throws Exception {
        this.administration.restoreData("TestJqlReleasedVersionsFunctions.xml");
        this.createSearchAndAssertIssues("fixVersion in unreleasedVersions()", "NUMBER-1", "MKY-1", "MK-1", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssues("affectedVersion in unreleasedVersions()", "NUMBER-2", "MKY-2", "MK-2", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssues("VP in unreleasedVersions()", "NUMBER-2", "MKY-2", "MK-2", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssues("VP in unreleasedVersions(HSP)", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssues("VP in unreleasedVersions(hsp)", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssues("VP in unreleasedVersions(homosapien)", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssues("VP in unreleasedVersions(HOMOSAPIEN)", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssues("VP in unreleasedVersions(10000)", "NUMBER-2");
        this.createSearchAndAssertIssues("VP in unreleasedVersions(monkey)", "MKY-2");
        this.createSearchAndAssertIssues("VP in unreleasedVersions(MKY)", "MKY-2");
        this.createSearchAndAssertIssues("VP in unreleasedVersions(MK)", "MK-2");
        this.createSearchAndAssertIssues("VP in unreleasedVersions(10001)", "MKY-2");
        this.navigation.issueNavigator().loadFilter(10010L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.tester.assertTextPresent("VP in unreleasedVersions(HSP)");
        this.navigation.logout();
        this.navigation.login("fred");
        this.createSearchAndAssertIssues("fixVersion in unreleasedVersions()", "NUMBER-1", "MKY-1", "MK-1");
        this.createSearchAndAssertIssues("affectedVersion in unreleasedVersions()", "NUMBER-2", "MKY-2", "MK-2");
        this.navigation.issueNavigator().loadFilter(10010L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.tester.assertTextPresent("VP in unreleasedVersions(10000)");
        this.tester.clickLink("find_link");
        this.tester.clickLink("new_filter");
        this.tester.clickLink("switchnavtype");
        this.tester.selectOption("pid", "10000");
        this.tester.submit("show");
        this.tester.selectOption("fixfor", "Unreleased Versions");
        this.tester.submit("show");
        this.tester.clickLink("switchnavtype");
        String jql = this.tester.getDialog().getFormParameterValue("jqlQuery");
        Assert.assertEquals((String)"project = \"NUMBER\" AND fixVersion in unreleasedVersions()", (String)jql);
        this.tester.clickLink("find_link");
        this.tester.clickLink("new_filter");
        this.tester.clickLink("switchnavtype");
        this.tester.selectOption("pid", "10000");
        this.tester.submit("show");
        this.tester.selectOption("version", "Unreleased Versions");
        this.tester.submit("show");
        this.tester.clickLink("switchnavtype");
        jql = this.tester.getDialog().getFormParameterValue("jqlQuery");
        Assert.assertEquals((String)"project = \"NUMBER\" AND affectedVersion in unreleasedVersions()", (String)jql);
    }

    public void testIssueTypesFunctions() {
        this.administration.restoreData("TestJqlStandardIssueTypesFunctions.xml");
        this.administration.subtasks().disable();
        this.navigation.issueNavigator().createSearch("type in standardIssueTypes()");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'standardIssueTypes' is invalid as sub-tasks are currently disabled.");
        this.navigation.issueNavigator().createSearch("type in subTaskIssueTypes()");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'subTaskIssueTypes' is invalid as sub-tasks are currently disabled.");
        this.administration.subtasks().enable();
        this.createSearchAndAssertIssues("type in standardIssueTypes()", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssues("type in subTaskIssueTypes()", new String[0]);
        String subTaskKey = this.navigation.issue().createSubTask("HSP-4", "Sub-task", "SUBSUBSUB", "");
        this.createSearchAndAssertIssues("type in subTaskIssueTypes()", subTaskKey);
        this.navigation.issueNavigator().createSearch("type in standardIssueTypes(arg)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'standardIssueTypes' expected '0' arguments but received '1'.");
        this.navigation.issueNavigator().createSearch("type in subTaskIssueTypes(arg)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'subTaskIssueTypes' expected '0' arguments but received '1'.");
        this.tester.clickLink("find_link");
        this.tester.clickLink("new_filter");
        this.tester.clickLink("switchnavtype");
        this.tester.selectOption("type", "Standard Issue Types");
        this.tester.submit("show");
        this.tester.clickLink("switchnavtype");
        String jql = this.tester.getDialog().getFormParameterValue("jqlQuery");
        Assert.assertEquals((String)"issuetype in standardIssueTypes()", (String)jql);
        this.tester.clickLink("find_link");
        this.tester.clickLink("new_filter");
        this.tester.clickLink("switchnavtype");
        this.tester.selectOption("type", "Sub-Task Issue Types");
        this.tester.submit("show");
        this.tester.clickLink("switchnavtype");
        jql = this.tester.getDialog().getFormParameterValue("jqlQuery");
        Assert.assertEquals((String)"issuetype in subTaskIssueTypes()", (String)jql);
    }

    public void testIllegalJqlFunctionParameters() {
        this.administration.restoreData("TestIllegalJqlFunctionParameters.xml");
        String[] errorMessages = new String[]{"Could not resolve the project 'random argument' provided to function 'releasedVersions'.", "Could not resolve the project 'random argument' provided to function 'unreleasedVersions'.", this.createFunctionArgumentError("standardIssueTypes", 0, 1), this.createFunctionArgumentError("subTaskIssueTypes", 0, 1), "Incorrect number of arguments specified for the function 'cascadeOption'. Usages: cascadeOption(parentOption), cascadeOption(parentOption, childOption), cascadeOption(parentOption, \"None\").", "The option 'random argument' specified in function 'cascadeOption' is not a valid parent option.", "The option 'random argument' is not a child of option 'parent' in function 'cascadeOption'.", "Incorrect number of arguments specified for the function 'cascadeOption'. Usages: cascadeOption(parentOption), cascadeOption(parentOption, childOption), cascadeOption(parentOption, \"None\").", this.createFunctionArgumentError("currentUser", 0, 1), this.createFunctionArgumentError("issueHistory", 0, 1), "Incorrect number of arguments for function 'linkedIssues'. Usage: 'linkedIssues ( issuekey [, linkDescription ]* )'.", "Issue 'random argument' could not be found in function 'linkedIssues'.", "Issue link type 'random argument' could not be found in function 'linkedIssues'.", this.createFunctionArgumentError("membersOf", 1, 0), "Function 'membersOf' can not generate a list of usernames for group 'random argument'; the group does not exist.", this.createFunctionArgumentError("now", 0, 1), this.createFunctionArgumentError("votedIssues", 0, 1), this.createFunctionArgumentError("watchedIssues", 0, 1), this.createFunctionArgumentError("lastLogin", 0, 1), this.createFunctionArgumentError("currentLogin", 0, 1)};
        for (int i = 0; i < errorMessages.length; ++i) {
            String errorMessage = errorMessages[i];
            this.navigation.issueNavigator().loadFilter(10000 + i, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
            this.assertions.getIssueNavigatorAssertions().assertJqlErrors(errorMessage);
        }
    }

    public void testVotedIssuesFunction() {
        this.administration.restoreData("TestVotedAndWatchedIssuesFunction.xml");
        this.navigation.login("fred");
        this.createSearchAndAssertIssues("issue IN votedIssues()", "HSP-2", "HSP-1");
        this.assertTooComplex();
        this.navigation.issueNavigator().createSearch("issue in votedIssues(arg)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(this.createFunctionArgumentError("votedIssues", 0, 1));
        this.navigation.logout();
        this.navigation.gotoDashboard();
        this.navigation.issueNavigator().createSearch("issue in votedIssues()");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'votedIssues' cannot be called as anonymous user.");
        this.navigation.issueNavigator().loadFilter(10000L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'votedIssues' cannot be called as anonymous user.");
        this.navigation.login("admin");
        this.administration.generalConfiguration().disableVoting();
        this.navigation.login("fred");
        this.navigation.issueNavigator().createSearch("issue in votedIssues()");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'votedIssues' cannot be called as voting on issues is currently disabled.");
        this.navigation.issueNavigator().loadFilter(10000L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'votedIssues' cannot be called as voting on issues is currently disabled.");
    }

    public void testWatchedIssuesFunction() {
        this.administration.restoreData("TestVotedAndWatchedIssuesFunction.xml");
        this.navigation.login("fred");
        this.createSearchAndAssertIssues("issue IN watchedIssues()", "HSP-2", "HSP-1");
        this.assertTooComplex();
        this.navigation.issueNavigator().createSearch("issue in watchedIssues(arg)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(this.createFunctionArgumentError("watchedIssues", 0, 1));
        this.navigation.logout();
        this.navigation.gotoDashboard();
        this.navigation.issueNavigator().createSearch("issue in watchedIssues()");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'watchedIssues' cannot be called as anonymous user.");
        this.navigation.issueNavigator().loadFilter(10001L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'watchedIssues' cannot be called as anonymous user.");
        this.navigation.login("admin");
        this.administration.generalConfiguration().disableWatching();
        this.navigation.login("fred");
        this.navigation.issueNavigator().createSearch("issue in watchedIssues()");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'watchedIssues' cannot be called as watching issues is currently disabled.");
        this.navigation.issueNavigator().loadFilter(10001L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'watchedIssues' cannot be called as watching issues is currently disabled.");
    }

    public void testIssueHistoryFunction() {
        this.administration.restoreData("TestIssueHistoryFunction.xml");
        this.navigation.login("fred");
        this.navigation.issue().viewIssue("HSP-1");
        this.createSearchAndAssertIssues("issue in issueHistory()", "HSP-1");
        this.navigation.issue().viewIssue("HSP-2");
        this.createSearchAndAssertIssues("issue in issueHistory()", "HSP-2", "HSP-1");
        this.assertTooComplex();
        this.navigation.issueNavigator().createSearch("issue in issueHistory(arg)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(this.createFunctionArgumentError("issueHistory", 0, 1));
        this.navigation.logout();
        this.navigation.login("fred");
        this.createSearchAndAssertIssues("issue in issueHistory()", "HSP-2", "HSP-1");
        this.navigation.issueNavigator().loadFilter(10000L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertIssues("HSP-2", "HSP-1");
        this.navigation.logout();
        this.navigation.gotoDashboard();
        this.navigation.issue().viewIssue("HSP-2");
        this.createSearchAndAssertIssues("issue in issueHistory()", "HSP-2");
        this.navigation.login("fred");
        this.navigation.logout();
        this.navigation.gotoDashboard();
        this.navigation.issue().viewIssue("HSP-1");
        this.createSearchAndAssertIssues("issue in issueHistory()", "HSP-1");
    }

    public void testLinkedIssues() {
        this.administration.restoreData("TestLinkedIssuesFunction.xml");
        this.createSearchAndAssertIssues("issue in linkedIssues('HSP-1')", "MKY-1", "HSP-4", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssues("issue in linkedIssues(10000)", "MKY-1", "HSP-4", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssues("issue in linkedIssues('HSP-1', 'blocks')", "MKY-1", "HSP-4", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssues("issue in linkedIssues('HSP-1', 'blOCKS')", "MKY-1", "HSP-4", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssues("issue in linkedIssues('HSP-1', 'is blocked by')", new String[0]);
        this.createSearchAndAssertIssues("issue in linkedIssues('HSP-1', 'duplicates')", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssues("issue in linkedIssues('HSP-1', 'DUPLICATES')", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssues("issue in linkedIssues('HSP-1', 'is duplicated by')", "MKY-1");
        this.createSearchAndAssertIssues("issue in linkedIssues('HSP-1', 'duplicates', 'is duplicated by')", "MKY-1", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssues("issue in linkedIssues('HSP-1', 'duplICAtes', 'IS duplicated BY')", "MKY-1", "HSP-3", "HSP-2");
        this.navigation.issueNavigator().createSearch("issue in linkedIssues('HSP-1', 'duplicates', 'fred')");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Issue link type 'fred' could not be found in function 'linkedIssues'.");
        this.navigation.issueNavigator().createSearch("issue in linkedIssues('HSP-5')");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Issue 'HSP-5' could not be found in function 'linkedIssues'.");
        this.navigation.issueNavigator().createSearch("issue in linkedIssues(99999)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Issue '99999' could not be found in function 'linkedIssues'.");
        this.createSearchAndAssertIssues("issue in linkedIssues('HSP-1', 'is blocked by')", new String[0]);
        this.assertTooComplex();
        this.administration.issueLinking().disable();
        this.navigation.issueNavigator().createSearch("issue in linkedIssues('10000')");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'linkedIssues' cannot be called as issue linking is currently disabled.");
        this.administration.issueLinking().enable();
        this.navigation.login("fred");
        this.createSearchAndAssertIssues("issue in linkedIssues('HSP-1')", "HSP-4", "HSP-3", "HSP-2");
        this.navigation.issueNavigator().createSearch("issue in linkedIssues('MKY-1')");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Issue 'MKY-1' could not be found in function 'linkedIssues'.");
        this.navigation.issueNavigator().createSearch("issue in linkedIssues('10001')");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Issue '10001' could not be found in function 'linkedIssues'.");
        this.navigation.issueNavigator().loadFilter(10000L, null);
        TestJqlSystemFunctions.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorMode.SUMMARY), (Object)((Object)this.navigation.issueNavigator().getCurrentMode()));
        this.tester.clickLink("editfilter");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Issue '10001' could not be found in function 'linkedIssues'.");
    }

    public void testNowFunction() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, 1);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("@@CREATED_DATE@@", new Timestamp(calendar.getTimeInMillis()).toString());
        map.put("@@UPDATED_DATE@@", new Timestamp(calendar.getTimeInMillis()).toString());
        this.administration.restoreDataWithReplacedTokens("TestJqlNowFunction.xml", map);
        IssueNavigatorNavigation navigatorNavigation = this.navigation.issueNavigator();
        IssueNavigatorAssertions navAssertions = this.assertions.getIssueNavigatorAssertions();
        this.createSearchAndAssertIssues("created > now()", "MKY-2");
        this.createSearchAndAssertIssues("created < now()", "MKY-1");
        navigatorNavigation.loadFilter(10000L, null);
        TestJqlSystemFunctions.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorMode.SUMMARY), (Object)((Object)this.navigation.issueNavigator().getCurrentMode()));
        this.tester.clickLink("editfilter");
        navAssertions.assertJqlErrors(this.createFunctionArgumentError("now", 0, 1));
        navigatorNavigation.createSearch("created > now ('hrehjre')");
        navAssertions.assertJqlErrors(this.createFunctionArgumentError("now", 0, 1));
        navigatorNavigation.createSearch("created > now ()");
        this.assertTooComplex();
    }

    public void testLastLogin() throws Exception {
        this.administration.restoreData("TestSystemJqlFunctions.xml");
        IssueNavigatorNavigation navigatorNavigation = this.navigation.issueNavigator();
        IssueNavigatorAssertions navAssertions = this.assertions.getIssueNavigatorAssertions();
        this.createSearchAndAssertIssues("created > lastLogin()", new String[0]);
        this.createSearchAndAssertIssues("created < lastLogin()", new String[0]);
        this.navigation.logout();
        this.navigation.login("admin");
        this.createSearchAndAssertIssues("created >= lastLogin()", new String[0]);
        String issue = this.navigation.issue().createIssue("homosapien", "Bug", "created after login");
        this.createSearchAndAssertIssues("created < lastLogin()", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssues("created >= lastLogin()", issue);
        navigatorNavigation.createSearch("created > lastLogin('hrehjre')");
        navAssertions.assertJqlErrors(this.createFunctionArgumentError("lastLogin", 0, 1));
        navigatorNavigation.createSearch("created > lastLogin()");
        this.assertTooComplex();
        this.navigation.logout();
        this.navigation.gotoDashboard();
        this.createSearchAndAssertIssues("created >= lastLogin()", new String[0]);
        this.createSearchAndAssertIssues("created <= lastLogin()", new String[0]);
    }

    public void testCurrentLogin() throws Exception {
        this.administration.restoreData("TestSystemJqlFunctions.xml");
        IssueNavigatorNavigation navigatorNavigation = this.navigation.issueNavigator();
        IssueNavigatorAssertions navAssertions = this.assertions.getIssueNavigatorAssertions();
        this.createSearchAndAssertIssues("created < currentLogin()", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssues("created >= currentLogin()", new String[0]);
        String issue = this.navigation.issue().createIssue("homosapien", "Bug", "created after login");
        this.createSearchAndAssertIssues("created < currentLogin()", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssues("created >= currentLogin()", issue);
        this.navigation.logout();
        this.navigation.login("admin");
        this.createSearchAndAssertIssues("created > currentLogin()", new String[0]);
        this.createSearchAndAssertIssues("created <= currentLogin()", issue, "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        navigatorNavigation.createSearch("created > currentLogin('hrehjre')");
        navAssertions.assertJqlErrors(this.createFunctionArgumentError("currentLogin", 0, 1));
        navigatorNavigation.createSearch("created > currentLogin()");
        this.assertTooComplex();
        this.navigation.logout();
        this.navigation.gotoDashboard();
        this.createSearchAndAssertIssues("created >= currentLogin()", new String[0]);
        this.createSearchAndAssertIssues("created <= currentLogin()", new String[0]);
    }

    public void testCurrentUser() throws Exception {
        this.administration.restoreData("TestSystemJqlFunctions.xml");
        IssueNavigatorNavigation navigatorNavigation = this.navigation.issueNavigator();
        IssueNavigatorAssertions navAssertions = this.assertions.getIssueNavigatorAssertions();
        this.createSearchAndAssertIssues("assignee = currentUser()", "HSP-4", "HSP-2");
        this.createSearchAndAssertIssues("reporter = currentUser()", "HSP-2", "HSP-1");
        navigatorNavigation.loadFilter(10001L, null);
        TestJqlSystemFunctions.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorMode.SUMMARY), (Object)((Object)this.navigation.issueNavigator().getCurrentMode()));
        this.tester.clickLink("editfilter");
        navAssertions.assertJqlErrors(this.createFunctionArgumentError("currentUser", 0, 1));
        this.navigation.login("fred", "fred");
        this.createSearchAndAssertIssues("assignee = currentUser()", "HSP-3", "HSP-1");
        this.createSearchAndAssertIssues("reporter = CURRENTUSER()", "HSP-4", "HSP-3");
        long reporterFilterId = navigatorNavigation.saveCurrentAsNewFilter(new SharedEntityInfo("AllFilter", null, false, TestSharingPermissionUtils.createPublicPermissions()));
        navigatorNavigation.createSearch("assignee = currentuser ('hrehjre')");
        navAssertions.assertJqlErrors(this.createFunctionArgumentError("currentuser", 0, 1));
        NavigatorSearch currentSearch = new NavigatorSearch((NavigatorCondition)new UserGroupPicker("customfield_10000").setCurrentUser());
        navigatorNavigation.createSearch(currentSearch);
        navigatorNavigation.gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        navAssertions.assertAdvancedSearch(this.tester, "cf[10000] = currentUser()");
        navigatorNavigation.gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        navAssertions.assertSimpleSearch(currentSearch, this.tester);
        currentSearch = new NavigatorSearch(new AssigneeCondition().setCurrentUser(), new ReporterCondition().setCurrentUser());
        navigatorNavigation.createSearch(currentSearch);
        navigatorNavigation.gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        navAssertions.assertAdvancedSearch(this.tester, "assignee = currentUser()", "reporter = currentUser()");
        navigatorNavigation.gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        navAssertions.assertSimpleSearch(currentSearch, this.tester);
        navigatorNavigation.createSearch("cf[10001]     =        currentUser()");
        this.assertTooComplex();
        this.navigation.logout();
        this.navigation.gotoDashboard();
        navigatorNavigation.createSearch("assignee = currentuser()");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(new String[0]);
        this.assertions.getIssueNavigatorAssertions().assertNoJqlErrors();
        navigatorNavigation.loadFilter(reporterFilterId, null);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(new String[0]);
        this.assertions.getIssueNavigatorAssertions().assertNoJqlErrors();
    }

    public void testMembersOf() throws Exception {
        this.administration.restoreData("TestSystemJqlFunctionsMembersOf.xml");
        IssueNavigatorNavigation navigatorNavigation = this.navigation.issueNavigator();
        IssueNavigatorAssertions navAssertions = this.assertions.getIssueNavigatorAssertions();
        this.createSearchAndAssertIssues("assignee in membersOf('jira-users')", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssues("assignee in membersOf('JIRA-users')", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssues("reporter in membersOf('jira-administrators')", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssues("reporter in membersOf('jira-ADMINistrators')", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssues("reporter in membersOf('empty-group')", new String[0]);
        this.createSearchAndAssertIssues("reporter in membersOf('jira-developers')", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssues("reporter in membersOf('JIRA-DEVELOPERS')", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        navigatorNavigation.loadFilter(10003L, null);
        TestJqlSystemFunctions.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorMode.SUMMARY), (Object)((Object)this.navigation.issueNavigator().getCurrentMode()));
        this.tester.clickLink("editfilter");
        navAssertions.assertJqlErrors(this.createFunctionArgumentError("membersOf", 1, 0));
        navigatorNavigation.loadFilter(10004L, null);
        TestJqlSystemFunctions.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorMode.SUMMARY), (Object)((Object)this.navigation.issueNavigator().getCurrentMode()));
        this.tester.clickLink("editfilter");
        navAssertions.assertJqlErrors(this.createFunctionArgumentError("membersOf", 1, 2));
        navigatorNavigation.createSearch("assignee in membersOf ()");
        navAssertions.assertJqlErrors(this.createFunctionArgumentError("membersOf", 1, 0));
        navigatorNavigation.createSearch("assignee in membersOf (8689, 38383)");
        navAssertions.assertJqlErrors(this.createFunctionArgumentError("membersOf", 1, 2));
        navigatorNavigation.createSearch("assignee in membersof ('notAGroupDoesNotExist')");
        navAssertions.assertJqlErrors("Function 'membersof' can not generate a list of usernames for group 'notAGroupDoesNotExist'; the group does not exist.");
        NavigatorSearch currentSearch = new NavigatorSearch((NavigatorCondition)new UserGroupPicker("customfield_10000").setGroup("jira-users"));
        navigatorNavigation.createSearch(currentSearch);
        navigatorNavigation.gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        navAssertions.assertAdvancedSearch(this.tester, "cf[10000] in membersOf(jira-users)");
        navigatorNavigation.gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        navAssertions.assertSimpleSearch(currentSearch, this.tester);
        currentSearch = new NavigatorSearch(new AssigneeCondition().setGroup("jira-users"), new ReporterCondition().setGroup("empty-group"));
        navigatorNavigation.createSearch(currentSearch);
        navigatorNavigation.gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        navAssertions.assertAdvancedSearch(this.tester, "assignee in membersOf(jira-users)", "reporter in membersOf(empty-group)");
        navigatorNavigation.gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        navAssertions.assertSimpleSearch(currentSearch, this.tester);
        navigatorNavigation.createSearch("cf[10001]     in        membersOf(\"jira-users\")");
        this.assertTooComplex();
    }

    public void testProjectsLeadByUserFunction() {
        this.administration.restoreData("TestProjectsLeadByUserFunction.xml");
        this.navigation.login("fred");
        this.createSearchAndAssertIssues("project IN projectsLeadByUser()", "FKY-1");
        this.createSearchAndAssertIssues("project IN projectsLeadByUser(fred)", "FKY-1");
        this.createSearchAndAssertIssues("project IN projectsLeadByUser(bill)", "BKY-2", "BKY-1");
        this.createSearchAndAssertIssues("project IN projectsLeadByUser(admin)", "MKY-1", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssues("project IN projectsLeadByUser(mary)", new String[0]);
        this.assertTooComplex();
        this.navigation.issueNavigator().createSearch("project IN projectsLeadByUser(user1, user2)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(this.createFunctionArgumentError("projectsLeadByUser", 0, 1, 2));
        this.navigation.logout();
        this.navigation.gotoDashboard();
        this.navigation.issueNavigator().createSearch("project IN projectsLeadByUser()");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'projectsLeadByUser' cannot be called as anonymous user.");
        this.navigation.issueNavigator().createSearch("project IN projectsLeadByUser(admin)");
        this.assertIssues("MKY-1", "HSP-2", "HSP-1");
        this.navigation.issueNavigator().loadFilter(10000L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'projectsLeadByUser' cannot be called as anonymous user.");
        this.navigation.issueNavigator().loadFilter(10001L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertIssues("MKY-1", "HSP-2", "HSP-1");
    }

    public void testProjectsWhereUserHasPermissionFunction() {
        this.administration.restoreData("TestProjectsWhereUserHasPermissionFunction.xml");
        this.navigation.login("fred");
        this.createSearchAndAssertIssues("project IN projectsWhereUserHasPermission(\"Create Issues\")", "MKY-2", "MKY-1", "HSP-5", "HSP-4", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssues("project IN projectsWhereUserHasPermission(\"Resolve Issues\")", "HSP-5", "HSP-4", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssues("project IN projectsWhereUserHasPermission(\"create issues\")", "MKY-2", "MKY-1", "HSP-5", "HSP-4", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssues("project IN projectsWhereUserHasPermission(\"resolve issues\")", "HSP-5", "HSP-4", "HSP-2", "HSP-1");
        this.assertTooComplex();
        this.navigation.issueNavigator().createSearch("project IN projectsWhereUserHasPermission()");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(this.createFunctionArgumentError("projectsWhereUserHasPermission", 1, 0));
        this.navigation.issueNavigator().createSearch("project IN projectsWhereUserHasPermission(\"Create Issues\", bill)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(this.createFunctionArgumentError("projectsWhereUserHasPermission", 1, 2));
        this.navigation.issueNavigator().loadFilter(10000L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertIssues("HSP-5", "HSP-4", "HSP-2", "HSP-1");
        this.navigation.logout();
        this.navigation.gotoDashboard();
        this.navigation.issueNavigator().createSearch("project IN projectsWhereUserHasPermission(\"Create Issues\")");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'projectsWhereUserHasPermission' cannot be called as anonymous user.");
        this.navigation.issueNavigator().loadFilter(10000L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'projectsWhereUserHasPermission' cannot be called as anonymous user.");
    }

    public void testProjectsWhereUserHasRoleFunction() {
        this.administration.restoreData("TestProjectsWhereUserHasRoleFunction.xml");
        this.navigation.login("fred");
        this.createSearchAndAssertIssues("project IN projectsWhereUserHasRole(\"Developers\")", "HSP-5", "HSP-4", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssues("project IN projectsWhereUserHasRole(\"Users\")", "MKY-2", "MKY-1");
        this.assertTooComplex();
        this.navigation.issueNavigator().createSearch("project IN projectsWhereUserHasRole()");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(this.createFunctionArgumentError("projectsWhereUserHasRole", 1, 0));
        this.navigation.issueNavigator().createSearch("project IN projectsWhereUserHasRole(\"Developers\", admin)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(this.createFunctionArgumentError("projectsWhereUserHasRole", 1, 2));
        this.navigation.issueNavigator().loadFilter(10000L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertIssues("HSP-5", "HSP-4", "HSP-2", "HSP-1");
        this.navigation.logout();
        this.navigation.gotoDashboard();
        this.navigation.issueNavigator().createSearch("project IN projectsWhereUserHasRole(\"Developers\")");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'projectsWhereUserHasRole' cannot be called as anonymous user.");
        this.navigation.issueNavigator().loadFilter(10000L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'projectsWhereUserHasRole' cannot be called as anonymous user.");
    }

    public void testComponentsLeadByUserFunction() {
        this.administration.restoreData("TestComponentsLeadByUserFunction.xml");
        this.navigation.login("fred");
        this.createSearchAndAssertIssues("component IN componentsLeadByUser()", "HSP-5");
        this.createSearchAndAssertIssues("component IN componentsLeadByUser(fred)", "HSP-5");
        this.createSearchAndAssertIssues("component IN componentsLeadByUser(bill)", "MKY-1", "HSP-4", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssues("component IN componentsLeadByUser(admin)", new String[0]);
        this.createSearchAndAssertIssues("component IN componentsLeadByUser(mary)", new String[0]);
        this.assertTooComplex();
        this.navigation.issueNavigator().createSearch("component IN componentsLeadByUser(user1, user2)");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(this.createFunctionArgumentError("componentsLeadByUser", 0, 1, 2));
        this.navigation.logout();
        this.navigation.gotoDashboard();
        this.navigation.issueNavigator().createSearch("component IN componentsLeadByUser()");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'componentsLeadByUser' cannot be called as anonymous user.");
        this.navigation.issueNavigator().createSearch("component IN componentsLeadByUser(fred)");
        this.assertIssues("HSP-5");
        this.navigation.issueNavigator().loadFilter(10000L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'componentsLeadByUser' cannot be called as anonymous user.");
        this.navigation.issueNavigator().loadFilter(10001L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertIssues("HSP-5");
    }

    public void testJqlFunctionMessages() throws Exception {
        this.administration.restoreData("TestJqlFunctionErrors.xml");
        this.assertJqlFunctionErrorEnumeratedValues("affectedVersion");
        this.assertJqlFunctionErrorEnumeratedValues("category");
        this.assertJqlFunctionErrorEnumeratedValues("component");
        this.assertJqlFunctionErrorEnumeratedValues("fixVersion");
        this.assertJqlFunctionErrorEnumeratedValues("level");
        this.assertJqlFunctionErrorEnumeratedValues("priority");
        this.assertJqlFunctionErrorEnumeratedValues("project");
        this.assertJqlFunctionErrorEnumeratedValues("resolution");
        this.assertJqlFunctionErrorEnumeratedValues("savedFilter");
        this.assertJqlFunctionErrorEnumeratedValues("status");
        this.assertJqlFunctionErrorEnumeratedValues("type");
        this.assertJqlFunctionErrorEnumeratedValues("PP");
        this.assertJqlFunctionErrorEnumeratedValues("SVP");
        this.assertJqlFunctionErrorEnumeratedValues("VP");
        IssueNavigatorNavigation navigatorNavigation = this.navigation.issueNavigator();
        IssueNavigatorAssertions assertions = this.assertions.getIssueNavigatorAssertions();
        navigatorNavigation.createSearch("votes = currentUser()");
        assertions.assertJqlErrors("A value provided by the function 'currentUser' is invalid for the field 'votes'. Votes must be a positive whole number.");
        this.assertJqlFunctionErrorTimeTracking("originalEstimate");
        this.assertJqlFunctionErrorTimeTracking("remainingEstimate");
        this.assertJqlFunctionErrorTimeTracking("timeSpent");
        navigatorNavigation.createSearch("workRatio < currentUser()");
        assertions.assertJqlErrors("A value provided by the function 'currentUser' for the field 'workRatio' is not an integer.");
        this.assertJqlFunctionErrorIssueKey("issue");
        this.assertJqlFunctionErrorIssueKey("parent");
        this.assertJqlFunctionErrorUser("assignee");
        this.assertJqlFunctionErrorUser("reporter");
        this.assertJqlFunctionErrorUser("MUP");
        this.assertJqlFunctionErrorUser("UP");
        this.assertJqlFunctionErrorDateValues("updated");
        this.assertJqlFunctionErrorDateValues("created");
        this.assertJqlFunctionErrorDateValues("due");
        this.assertJqlFunctionErrorDateValues("resolved");
        this.assertJqlFunctionErrorDateValues("DP");
        this.assertJqlFunctionErrorDateValues("DT");
        this.assertJqlFunctionErrorTextValues("comment");
        this.assertJqlFunctionErrorTextValues("description");
        this.assertJqlFunctionErrorTextValues("environment");
        this.assertJqlFunctionErrorTextValues("summary");
        this.assertJqlFunctionErrorTextValues("FTF");
        this.assertJqlFunctionErrorTextValues("ROTF");
        this.assertJqlFunctionErrorTextValues("TF");
        this.assertJqlFunctionErrorNumber("II");
        this.assertJqlFunctionErrorNumber("NF");
        this.assertJqlFunctionErrorGroup("GP");
        this.assertJqlFunctionErrorGroup("MGP");
        this.assertJqlFunctionErrorOption("CSF");
        this.assertJqlFunctionErrorOption("MC");
        this.assertJqlFunctionErrorOption("MS");
        this.assertJqlFunctionErrorOption("RB");
        this.assertJqlFunctionErrorOption("SL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadFunctions() throws Exception {
        this.administration.restoreData("TestJqlFunctionDisabled.xml");
        try {
            this.navigation.gotoPage(this.page.addXsrfToken("/secure/admin/jira/ViewPlugins.jspa?mode=disable&moduleKey=jira.jql.function%3Aecho-jql-function"));
            IssueNavigatorNavigation navigation = this.navigation.issueNavigator();
            navigation.loadFilter(10000L, null);
            TestJqlSystemFunctions.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorMode.SUMMARY), (Object)((Object)navigation.getCurrentMode()));
            this.tester.clickLink("editfilter");
            this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Unable to find JQL function 'echo(HSP)'.");
            navigation.loadFilter(10001L, null);
            TestJqlSystemFunctions.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorMode.SUMMARY), (Object)((Object)navigation.getCurrentMode()));
            this.tester.clickLink("editfilter");
            this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Unable to find JQL function 'dontExist(HSP)'.");
        }
        finally {
            this.navigation.gotoPage(this.page.addXsrfToken("/secure/admin/jira/ViewPlugins.jspa?mode=enable&moduleKey=jira.jql.function%3Aecho-jql-function"));
        }
    }

    private void assertJqlFunctionErrorOption(String fieldName) {
        this.navigation.issueNavigator().createSearch(String.format("%s = EcHo('notAnOption')", fieldName));
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(String.format("An option provided by the function 'EcHo' for the field '%s' does not exist.", fieldName));
    }

    private void assertJqlFunctionErrorTextValues(String fieldName) {
        this.navigation.issueNavigator().createSearch(String.format("%s ~ ECHO('?illegal')", fieldName));
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(String.format("The text query given by the function 'ECHO' is not valid for the field '%s' as it starts with '?'.", fieldName));
        this.navigation.issueNavigator().createSearch(String.format("%s ~ ECHO('ru [20002')", fieldName));
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(String.format("The field '%s' is unable to parse the text given to it by the function 'ECHO'.", fieldName));
    }

    private void assertJqlFunctionErrorEnumeratedValues(String fieldName) {
        this.navigation.issueNavigator().createSearch(String.format("%s = CuRReNTuseR()", fieldName));
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(String.format("A value provided by the function 'CuRReNTuseR' is invalid for the field '%s'.", fieldName));
    }

    private void assertJqlFunctionErrorDateValues(String fieldName) {
        this.navigation.issueNavigator().createSearch(String.format("%s = currentUSER()", fieldName));
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(String.format("A date for the field '%s' provided by the function 'currentUSER' is not a valid.", fieldName));
    }

    private void assertJqlFunctionErrorTimeTracking(String fieldName) {
        this.navigation.issueNavigator().createSearch(String.format("%s = cuRRENTUSER()", fieldName));
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(String.format("A value provided by the function 'cuRRENTUSER' for the field '%s' is not a positive duration.", fieldName));
    }

    private void assertJqlFunctionErrorIssueKey(String fieldName) {
        this.navigation.issueNavigator().createSearch(String.format("%s = currentuser()", fieldName));
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(String.format("A value provided by the function 'currentuser' for the field '%s' is not a valid issue key.", fieldName));
    }

    private void assertJqlFunctionErrorUser(String fieldName) {
        this.navigation.issueNavigator().createSearch(String.format("%s = now()", fieldName));
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(String.format("A value provided by the function 'now' is invalid for the field '%s'.", fieldName));
    }

    private void assertJqlFunctionErrorGroup(String fieldName) {
        this.navigation.issueNavigator().createSearch(String.format("%s = now()", fieldName));
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(String.format("A group provided by the function 'now' for the field '%s' does not exist.", fieldName));
    }

    private void assertJqlFunctionErrorNumber(String fieldName) {
        this.navigation.issueNavigator().createSearch(String.format("%s = echo('bad')", fieldName));
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(String.format("A value provided by the function 'echo' for the field '%s' is not a valid number.", fieldName));
    }

    private void createSearchAndAssertIssues(String jqlQuery, String ... keys) {
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertIssues(keys);
    }

    private void assertTooComplex() {
        this.assertions.getIssueNavigatorAssertions().assertJqlTooComplex();
    }

    private String createFunctionArgumentError(Object funcName, int expectedArgs, int actualArgs) {
        return String.format("Function '%s' expected '%d' arguments but received '%d'.", funcName, expectedArgs, actualArgs);
    }

    private String createFunctionArgumentError(Object funcName, int minArgs, int maxArgs, int actualArgs) {
        return String.format("Function '%s' expected between '%d' and '%d' arguments but received '%d'.", funcName, minArgs, maxArgs, actualArgs);
    }

    private static IssueNavigatorAssertions.FilterFormParam createParam(String name, String ... values) {
        return AbstractJqlFuncTest.createFilterFormParam(name, values);
    }
}

