/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.webtests.JIRAWebTest;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TestSearchRequestViewSecurity
extends JIRAWebTest {
    private static final String SR_PRINTABLE_SUCCESS = "/sr/jira.issueviews:searchrequest-printable/10000/SearchRequest-10000.html";
    private static final String SR_FULL_CONTENT_SUCCESS = "/sr/jira.issueviews:searchrequest-fullcontent/10000/SearchRequest-10000.html";
    private static final String SR_XML_SUCCESS = "/sr/jira.issueviews:searchrequest-xml/10000/SearchRequest-10000.xml";
    private static final String SR_RSS_SUCCESS = "/sr/jira.issueviews:searchrequest-rss/10000/SearchRequest-10000.xml";
    private static final String SR_RSS_COMMENTS_SUCCESS = "/sr/jira.issueviews:searchrequest-comments-rss/10000/SearchRequest-10000.xml";
    private static final String SR_WORD_SUCCESS = "/sr/jira.issueviews:searchrequest-word/10000/SearchRequest-10000.doc";
    private static final String SR_EXCEL_ALL_SUCCESS = "/sr/jira.issueviews:searchrequest-excel-all-fields/10000/SearchRequest-10000.xls";
    private static final String SR_EXCEL_CURRENT_SUCCESS = "/sr/jira.issueviews:searchrequest-excel-current-fields/10000/SearchRequest-10000.xls";
    private static final String SR_GLOBAL_PRINTABLE_SUCCESS = "/sr/jira.issueviews:searchrequest-printable/10010/SearchRequest-10010.html";
    private static final String SR_GLOBAL_FULL_CONTENT_SUCCESS = "/sr/jira.issueviews:searchrequest-fullcontent/10010/SearchRequest-10010.html";
    private static final String SR_GLOBAL_XML_SUCCESS = "/sr/jira.issueviews:searchrequest-xml/10010/SearchRequest-10010.xml";
    private static final String SR_GLOBAL_RSS_SUCCESS = "/sr/jira.issueviews:searchrequest-rss/10010/SearchRequest-10010.xml";
    private static final String SR_GLOBAL_RSS_COMMENTS_SUCCESS = "/sr/jira.issueviews:searchrequest-comments-rss/10010/SearchRequest-10010.xml";
    private static final String SR_GLOBAL_WORD_SUCCESS = "/sr/jira.issueviews:searchrequest-word/10010/SearchRequest-10010.doc";
    private static final String SR_GLOBAL_EXCEL_ALL_SUCCESS = "/sr/jira.issueviews:searchrequest-excel-all-fields/10010/SearchRequest-10010.xls";
    private static final String SR_GLOBAL_EXCEL_CURRENT_SUCCESS = "/sr/jira.issueviews:searchrequest-excel-current-fields/10010/SearchRequest-10010.xls";
    private static final String SR_RSS_COMMENTS_FAILED = "/sr/jira.issueviews:searchrequest-comments-rss/10001/SearchRequest-10000.xml";
    private static final String SR_PRINTABLE_FAILED = "/sr/jira.issueviews:searchrequest-printable/10001/SearchRequest-10000.html";
    private static final String SR_FULL_CONTENT_FAILED = "/sr/jira.issueviews:searchrequest-fullcontent/10001/SearchRequest-10000.html";
    private static final String SR_XML_FAILED = "/sr/jira.issueviews:searchrequest-xml/10001/SearchRequest-10000.xml";
    private static final String SR_RSS_FAILED = "/sr/jira.issueviews:searchrequest-rss/10001/SearchRequest-10000.xml";
    private static final String SR_WORD_FAILED = "/sr/jira.issueviews:searchrequest-word/10001/SearchRequest-10000.doc";
    private static final String SR_EXCEL_ALL_FAILED = "/sr/jira.issueviews:searchrequest-excel-all-fields/10001/SearchRequest-10000.xls";
    private static final String SR_EXCEL_CURRENT_FAILED = "/sr/jira.issueviews:searchrequest-excel-current-fields/10001/SearchRequest-10000.xls";
    private static final String ADMIN_USERNAME_PASSWORD = "admin";
    private static final String FRED_USERNAME_PASSWORD = "fred";
    private static final String LOGIN = "log in";
    private static final String LOGIN_LINK = "log in";
    private static final String LOGIN_BUTTON = "login";

    public TestSearchRequestViewSecurity(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestSearchRequestViewSecurity.xml");
    }

    public void testGlobalSearchRequestRequiresNoLogin() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        this.logout();
        this.gotoPage(SR_GLOBAL_PRINTABLE_SUCCESS);
        this.assertTextPresent("HSP-1");
        this.assertTextPresent("Bug 01");
        this.assertTextPresent("Back to previous view");
        this.logout();
        this.gotoPage(SR_GLOBAL_FULL_CONTENT_SUCCESS);
        this.assertTextPresent("HSP-1");
        this.assertTextPresent("Bug 01");
        this.assertTextPresent("Back to previous view");
        this.logout();
        this.gotoPage(SR_GLOBAL_XML_SUCCESS);
        TestSearchRequestViewSecurity.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        String responseText = this.getDialog().getResponse().getText();
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        String xpath = "//rss[contains(@version,'0.92')]";
        TestSearchRequestViewSecurity.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        this.logout();
        try {
            this.gotoPage(SR_GLOBAL_RSS_SUCCESS);
        }
        catch (RuntimeException re) {
            TestSearchRequestViewSecurity.fail((String)("Exception occurred: " + re));
        }
        TestSearchRequestViewSecurity.assertEquals((String)"application/rss+xml", (String)this.getDialog().getResponse().getContentType());
        responseText = this.getDialog().getResponse().getText();
        doc = XMLUnit.buildControlDocument((String)responseText);
        xpath = "//rss[contains(@version,'2.0')]";
        TestSearchRequestViewSecurity.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        xpath = "//item";
        TestSearchRequestViewSecurity.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        this.logout();
        try {
            this.gotoPage(SR_GLOBAL_RSS_COMMENTS_SUCCESS);
        }
        catch (RuntimeException re) {
            TestSearchRequestViewSecurity.fail((String)("Exception occurred: " + re));
        }
        TestSearchRequestViewSecurity.assertEquals((String)"application/rss+xml", (String)this.getDialog().getResponse().getContentType());
        responseText = this.getDialog().getResponse().getText();
        doc = XMLUnit.buildControlDocument((String)responseText);
        xpath = "//rss[contains(@version,'2.0')]";
        TestSearchRequestViewSecurity.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        xpath = "//item";
        TestSearchRequestViewSecurity.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        this.logout();
        this.gotoPage(SR_GLOBAL_WORD_SUCCESS);
        TestSearchRequestViewSecurity.assertEquals((String)"application/vnd.ms-word", (String)this.getDialog().getResponse().getContentType());
        this.logout();
        this.gotoPage(SR_GLOBAL_EXCEL_ALL_SUCCESS);
        TestSearchRequestViewSecurity.assertEquals((String)"application/vnd.ms-excel", (String)this.getDialog().getResponse().getContentType());
        this.logout();
        this.gotoPage(SR_GLOBAL_EXCEL_CURRENT_SUCCESS);
        TestSearchRequestViewSecurity.assertEquals((String)"application/vnd.ms-excel", (String)this.getDialog().getResponse().getContentType());
    }

    public void testErrorsWithGzipFilter() {
        this.getAdministration().generalConfiguration().turnOnGZipCompression();
        this.getNavigation().logout();
        this.getNavigation().gotoPage(SR_PRINTABLE_SUCCESS);
        this.assertTextPresent("Login Required");
        this.assertTextPresent("You are not logged in");
        this.getNavigation().login(ADMIN_USERNAME_PASSWORD, ADMIN_USERNAME_PASSWORD);
        this.getNavigation().gotoPage("/sr/jira.issueviews:searchrequest-printable/10002/SearchRequest-10002.html");
        this.assertTextPresent("Error processing Search Request");
    }

    public void testLoginRequiredSuccess() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        this.logout();
        this.gotoPage(SR_PRINTABLE_SUCCESS);
        this.checkNoLoginPageAndClickLink();
        this.loginFromErrorPage(ADMIN_USERNAME_PASSWORD, ADMIN_USERNAME_PASSWORD);
        this.assertTextPresent("HSP-1");
        this.assertTextPresent("Bug 01");
        this.assertTextPresent("Back to previous view");
        this.logout();
        this.gotoPage(SR_FULL_CONTENT_SUCCESS);
        this.checkNoLoginPageAndClickLink();
        this.loginFromErrorPage(ADMIN_USERNAME_PASSWORD, ADMIN_USERNAME_PASSWORD);
        this.assertTextPresent("HSP-1");
        this.assertTextPresent("Bug 01");
        this.assertTextPresent("Back to previous view");
        this.logout();
        this.gotoPage(SR_XML_SUCCESS);
        TestSearchRequestViewSecurity.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        String responseText = this.getDialog().getResponse().getText();
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        String xpath = "//rss[contains(@version,'0.92')]";
        TestSearchRequestViewSecurity.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        xpath = "//item";
        TestSearchRequestViewSecurity.log("Testing for non-existance of xpath [" + xpath + "]");
        XMLAssert.assertXpathNotExists((String)xpath, (Document)doc);
        this.login(ADMIN_USERNAME_PASSWORD, ADMIN_USERNAME_PASSWORD);
        this.gotoPage(SR_XML_SUCCESS);
        TestSearchRequestViewSecurity.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        responseText = this.getDialog().getResponse().getText();
        doc = XMLUnit.buildControlDocument((String)responseText);
        xpath = "//rss[contains(@version,'0.92')]";
        TestSearchRequestViewSecurity.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        xpath = "//item";
        TestSearchRequestViewSecurity.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        this.logout();
        try {
            this.gotoPageNoLog(SR_RSS_SUCCESS);
            TestSearchRequestViewSecurity.fail((String)"Should have been prompted for authentication");
        }
        catch (RuntimeException re) {
            TestSearchRequestViewSecurity.assertTrue((re.getMessage().indexOf("AuthorizationRequiredException") != -1 ? 1 : 0) != 0);
            TestSearchRequestViewSecurity.log("Received auth challenge!");
        }
        this.gotoPage("/sr/jira.issueviews:searchrequest-rss/10000/SearchRequest-10000.xml?os_username=admin&os_password=admin");
        TestSearchRequestViewSecurity.assertEquals((String)"application/rss+xml", (String)this.getDialog().getResponse().getContentType());
        responseText = this.getDialog().getResponse().getText();
        doc = XMLUnit.buildControlDocument((String)responseText);
        xpath = "//rss[contains(@version,'2.0')]";
        TestSearchRequestViewSecurity.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        xpath = "//item";
        TestSearchRequestViewSecurity.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        this.logout();
        try {
            this.gotoPageNoLog(SR_RSS_COMMENTS_SUCCESS);
            TestSearchRequestViewSecurity.fail((String)"Should have been prompted for authentication");
        }
        catch (RuntimeException re) {
            TestSearchRequestViewSecurity.assertTrue((re.getMessage().indexOf("AuthorizationRequiredException") != -1 ? 1 : 0) != 0);
            TestSearchRequestViewSecurity.log("Received auth challenge!");
        }
        this.gotoPage("/sr/jira.issueviews:searchrequest-comments-rss/10000/SearchRequest-10000.xml?os_username=admin&os_password=admin");
        TestSearchRequestViewSecurity.assertEquals((String)"application/rss+xml", (String)this.getDialog().getResponse().getContentType());
        responseText = this.getDialog().getResponse().getText();
        doc = XMLUnit.buildControlDocument((String)responseText);
        xpath = "//rss[contains(@version,'2.0')]";
        TestSearchRequestViewSecurity.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        xpath = "//item";
        TestSearchRequestViewSecurity.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        this.logout();
        this.gotoPage(SR_WORD_SUCCESS);
        this.checkNoLoginPageAndClickLink();
        this.loginFromErrorPage(ADMIN_USERNAME_PASSWORD, ADMIN_USERNAME_PASSWORD);
        TestSearchRequestViewSecurity.assertEquals((String)"application/vnd.ms-word", (String)this.getDialog().getResponse().getContentType());
        this.logout();
        this.gotoPage(SR_EXCEL_ALL_SUCCESS);
        this.checkNoLoginPageAndClickLink();
        this.loginFromErrorPage(ADMIN_USERNAME_PASSWORD, ADMIN_USERNAME_PASSWORD);
        TestSearchRequestViewSecurity.assertEquals((String)"application/vnd.ms-excel", (String)this.getDialog().getResponse().getContentType());
        this.logout();
        this.gotoPage(SR_EXCEL_CURRENT_SUCCESS);
        this.checkNoLoginPageAndClickLink();
        this.loginFromErrorPage(ADMIN_USERNAME_PASSWORD, ADMIN_USERNAME_PASSWORD);
        TestSearchRequestViewSecurity.assertEquals((String)"application/vnd.ms-excel", (String)this.getDialog().getResponse().getContentType());
    }

    public void testLoginRequiredAndSearchRequestDoesntExist() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        this.checkLoginInvalidSRorPermission(SR_PRINTABLE_FAILED, SR_FULL_CONTENT_FAILED, SR_XML_FAILED, SR_RSS_FAILED, SR_RSS_COMMENTS_FAILED, SR_WORD_FAILED, SR_EXCEL_ALL_FAILED, SR_EXCEL_CURRENT_FAILED, ADMIN_USERNAME_PASSWORD);
    }

    public void testLoginRequiredAndInvalidPermission() throws TransformerException, IOException, ParserConfigurationException, SAXException {
        this.checkLoginInvalidSRorPermission(SR_PRINTABLE_SUCCESS, SR_FULL_CONTENT_SUCCESS, SR_XML_SUCCESS, SR_RSS_SUCCESS, SR_RSS_COMMENTS_SUCCESS, SR_WORD_SUCCESS, SR_EXCEL_ALL_SUCCESS, SR_EXCEL_CURRENT_SUCCESS, FRED_USERNAME_PASSWORD);
    }

    private void loginFromErrorPage(String username, String password) {
        this.setFormElement("os_username", username);
        this.setFormElement("os_password", password);
        this.setWorkingForm("login-form");
        this.submit();
    }

    private void checkNoLoginPageAndClickLink() {
        this.assertTextPresent("You are not logged in.");
        this.assertTextPresent("You cannot view this URL as a guest.");
        this.assertLinkPresentWithText("log in");
        this.clickLinkWithText("log in");
    }

    private void checkErrorProcessingSearchRequest() {
        this.assertTextPresent("Error processing Search Request");
        this.assertTextPresent("The saved filter you are trying to view no longer exists or you do not have access rights to view it.");
    }

    private void checkLoginSearchRequestDoesntExist(String url, String username, String password) {
        this.logout();
        this.gotoPage(url);
        this.checkNoLoginPageAndClickLink();
        this.loginFromErrorPage(username, password);
        this.checkErrorProcessingSearchRequest();
    }

    private void checkLoginInvalidSRorPermission(String printable, String fullContent, String xml, String rss, String rssComments, String word, String excelAll, String excelCurrent, String usernamePassword) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        this.checkLoginSearchRequestDoesntExist(printable, usernamePassword, usernamePassword);
        this.checkLoginSearchRequestDoesntExist(fullContent, usernamePassword, usernamePassword);
        this.logout();
        this.gotoPage(xml);
        TestSearchRequestViewSecurity.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        String responseText = this.getDialog().getResponse().getText();
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        String xpath = "//rss[contains(@version,'0.92')]";
        TestSearchRequestViewSecurity.log("Testing for xpath [" + xpath + "]");
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        xpath = "//item";
        TestSearchRequestViewSecurity.log("Testing for non-existance of xpath [" + xpath + "]");
        XMLAssert.assertXpathNotExists((String)xpath, (Document)doc);
        this.logout();
        try {
            this.gotoPageNoLog(rss);
            TestSearchRequestViewSecurity.fail((String)"Should have been prompted for authentication");
        }
        catch (RuntimeException re) {
            TestSearchRequestViewSecurity.assertTrue((re.getMessage().indexOf("AuthorizationRequiredException") != -1 ? 1 : 0) != 0);
            TestSearchRequestViewSecurity.log("Received auth challenge!");
        }
        try {
            this.gotoPageNoLog(rss + "?os_username=admin&os_password=admin");
        }
        catch (RuntimeException e) {
            TestSearchRequestViewSecurity.assertTrue((e.getMessage().indexOf("Error on HTTP request: 403") != -1 ? 1 : 0) != 0);
            TestSearchRequestViewSecurity.log("recieved 403 error");
        }
        this.logout();
        try {
            this.gotoPageNoLog(rssComments);
            TestSearchRequestViewSecurity.fail((String)"Should have been prompted for authentication");
        }
        catch (RuntimeException re) {
            TestSearchRequestViewSecurity.assertTrue((re.getMessage().indexOf("AuthorizationRequiredException") != -1 ? 1 : 0) != 0);
            TestSearchRequestViewSecurity.log("Received auth challenge!");
        }
        try {
            this.gotoPageNoLog(rssComments + "?os_username=admin&os_password=admin");
        }
        catch (RuntimeException e) {
            TestSearchRequestViewSecurity.assertTrue((e.getMessage().indexOf("Error on HTTP request: 403") != -1 ? 1 : 0) != 0);
            TestSearchRequestViewSecurity.log("recieved 403 error");
        }
        this.checkLoginSearchRequestDoesntExist(word, usernamePassword, usernamePassword);
        this.checkLoginSearchRequestDoesntExist(excelAll, usernamePassword, usernamePassword);
        this.checkLoginSearchRequestDoesntExist(excelCurrent, usernamePassword, usernamePassword);
    }

    private static final class ContentTypes {
        private static final String XML = "text/xml";
        private static final String RSS = "application/rss+xml";
        private static final String WORD = "application/vnd.ms-word";
        private static final String EXCEL = "application/vnd.ms-excel";

        private ContentTypes() {
        }
    }
}

