/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestReturnToSearch
extends JIRAWebTest {
    public TestReturnToSearch(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestReturnToSearch.xml");
    }

    public void testReturnToSearchNotPresentIfSearchRequestInvalid() {
        TestReturnToSearch.log("Testing 'Return to serach' box is not present on view issue if no results returned by previous search");
        this.clickLink("find_link");
        this.setFormElement("query", "TST-999]");
        this.submit("show");
        this.navigation.issue().viewIssue("TST-1");
        this.assertLinkNotPresent("return-to-search");
    }

    public void testReturnToSearchNotPresentIfNoSearchResults() {
        TestReturnToSearch.log("Testing 'Return to serach' box is not present on view issue if no results returned by previous search");
        this.clickLink("find_link");
        this.setFormElement("query", "TST-999");
        this.submit("show");
        this.navigation.issue().viewIssue("TST-1");
        this.assertLinkNotPresent("return-to-search");
    }

    public void testReturnToSearchPresentIfSearchResultsExist() {
        TestReturnToSearch.log("Testing 'Return to serach' box is present on view issue if results returned by previous search exist");
        this.clickLink("find_link");
        this.selectOption("type", "Bug");
        this.submit("show");
        this.navigation.issue().viewIssue("TST-3");
        this.assertLinkNotPresent("return-to-search");
        this.navigation.issue().viewIssue("TST-2");
        this.assertLinkPresent("return-to-search");
    }

    public void testReturnToSearchNavigation() {
        this.clickLink("find_link");
        this.selectOption("type", "Any");
        this.submit("show");
        this.clickLinkWithText("TST-2");
        this.assertLinkPresent("return-to-search");
        this.assertLinkPresent("previous-issue");
        this.assertLinkPresent("next-issue");
        this.clickLink("previous-issue");
        this.assertLinkPresent("return-to-search");
        this.assertLinkNotPresent("previous-issue");
        this.assertLinkPresent("next-issue");
        this.clickLink("next-issue");
        this.clickLink("next-issue");
        this.assertLinkPresent("return-to-search");
        this.assertLinkPresent("previous-issue");
        this.assertLinkNotPresent("next-issue");
    }
}

