/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebResponse;
import net.sourceforge.jwebunit.WebTester;

public class TestSeraphAuthType
extends FuncTestCase {
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
        this.navigation.logout();
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
    }

    public void testBasic() throws Exception {
        this.tester.beginAt("/?os_authType=basic");
        WebResponse response = this.tester.getDialog().getResponse();
        TestSeraphAuthType.assertEquals((int)401, (int)response.getResponseCode());
        TestSeraphAuthType.assertEquals((String)"text/html", (String)response.getContentType());
    }

    public void testCookie() throws Exception {
        WebTester webTester = new WebTester();
        webTester.getTestContext().setBaseUrl(this.environmentData.getBaseUrl().toExternalForm());
        webTester.getTestContext().addCookie("JSESSIONID", "bad-cookie");
        webTester.beginAt("/?os_authType=cookie");
        WebResponse response = webTester.getDialog().getResponse();
        TestSeraphAuthType.assertEquals((int)401, (int)response.getResponseCode());
        TestSeraphAuthType.assertEquals((String)"text/html", (String)response.getContentType());
    }

    public void testAny_fail() throws Exception {
        WebTester webTester = new WebTester();
        webTester.getTestContext().setBaseUrl(this.environmentData.getBaseUrl().toExternalForm());
        webTester.getTestContext().addCookie("JSESSIONID", "bad-cookie");
        webTester.beginAt("/?os_authType=any");
        WebResponse response = webTester.getDialog().getResponse();
        TestSeraphAuthType.assertEquals((int)401, (int)response.getResponseCode());
        TestSeraphAuthType.assertEquals((String)"text/html", (String)response.getContentType());
    }

    public void testAny_anon() throws Exception {
        WebTester webTester = new WebTester();
        webTester.getTestContext().setBaseUrl(this.environmentData.getBaseUrl().toExternalForm());
        webTester.beginAt("/?os_authType=any");
        WebResponse response = webTester.getDialog().getResponse();
        TestSeraphAuthType.assertEquals((int)200, (int)response.getResponseCode());
        TestSeraphAuthType.assertEquals((String)"text/html", (String)response.getContentType());
    }
}

