/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.labels.Labels;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCsvImport
extends JIRAWebTest {
    private static final int REFRESH_DELAY = 2;
    private static final String TRIVIA_REPORTER = "Chai";
    private static final String TRIVIA_KEY = "TRV";
    private static final String TRIVIA_NAME = "Trivia";
    private static final String TRIVIA_TYPE = "Improvement";
    private static final String TRIVIA_SUMMARY = "CSV Import Func Test";
    private static final String TRIVIA_DESCRIPTION = "Write jwebunit functional test for the csv importer";
    private static final String KEY_MOZILLA = "MOZ";
    private static final String LABELS_CF_ID = "customfield_10010";

    public TestCsvImport(String name) {
        super(name);
    }

    @Override
    public void tearDown() {
        this.removeGlobalPermission(33, "jira-users");
        super.tearDown();
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestCsvImport.xml");
    }

    protected void copyFileToCsvImportDirectory(File file) {
        File csvImportDirectory = new File(this.administration.getJiraHomeDirectory(), "import" + File.separator + "csv");
        try {
            FileUtils.copyFileToDirectory((File)file, (File)csvImportDirectory);
        }
        catch (IOException e) {
            e.printStackTrace();
            TestCsvImport.fail((String)("Could not copy file " + file.getAbsolutePath() + " to the csv import directory in jira home " + csvImportDirectory));
        }
    }

    public void testTrivial() {
        this.importFile("trivial.csv", "trivial.properties", 60);
        this.goToProject(TRIVIA_NAME);
        this.assertTextPresent("Project: Trivia");
        this.assertElementPresent("project-avatar");
        this.assertTextPresent("Key:</b> TRV");
        this.displayAllIssues();
        this.assertTextPresent("all 1 issue(s)");
        this.assertTextPresentBeforeText("Unassigned", TRIVIA_REPORTER);
        this.clickLinkWithText("TRV-1");
        this.assertTextPresent(TRIVIA_SUMMARY);
        this.assertTextPresent(TRIVIA_DESCRIPTION);
        this.assertTextPresent(TRIVIA_TYPE);
    }

    public void testTrivialWithEmails() {
        String reporter = "chai@funcmaster.com";
        this.importFile("trivial-with-emails.csv", "trivial.properties", 60);
        this.goToProject(TRIVIA_NAME);
        this.assertTextPresent("Project: Trivia");
        this.assertElementPresent("project-avatar");
        this.assertTextPresent("Key:</b> TRV");
        this.displayAllIssues();
        this.assertTextPresent("all 1 issue(s)");
        this.assertTextPresentBeforeText("Unassigned", "chai@funcmaster.com");
        this.clickLinkWithText("TRV-1");
        this.assertTextPresent(TRIVIA_SUMMARY);
        this.assertTextPresent(TRIVIA_DESCRIPTION);
        this.assertTextPresent(TRIVIA_TYPE);
        this.assertTextNotPresent("chai@funcmaster.com@atlassian.com");
        this.clickLinkWithText("chai@funcmaster.com");
        this.assertTextSequence(new String[]{"Username", "chai@funcmaster.com", "Full Name", "chai@funcmaster.com", "Email", "chai@funcmaster.com"});
        this.assertTextNotPresent("chai@funcmaster.com@atlassian.com");
    }

    public void testTrivialWithEmailsNoSuffix() {
        String reporter = "chai@funcmaster.com";
        this.importFile("trivial-with-emails.csv", "trivial-no-email-suffix.properties", 60);
        this.goToProject(TRIVIA_NAME);
        this.assertTextPresent("Project: Trivia");
        this.assertElementPresent("project-avatar");
        this.assertTextPresent("Key:</b> TRV");
        this.displayAllIssues();
        this.assertTextPresent("all 1 issue(s)");
        this.assertTextPresentBeforeText("Unassigned", "chai@funcmaster.com");
        this.clickLinkWithText("TRV-1");
        this.assertTextPresent(TRIVIA_SUMMARY);
        this.assertTextPresent(TRIVIA_DESCRIPTION);
        this.assertTextPresent(TRIVIA_TYPE);
        this.assertTextNotPresent("chai@funcmaster.com@example.com");
        this.clickLinkWithText("chai@funcmaster.com");
        this.assertTextSequence(new String[]{"Username", "chai@funcmaster.com", "Full Name", "chai@funcmaster.com", "Email", "chai@funcmaster.com"});
        this.assertTextNotPresent("chai@funcmaster.com@example.com");
    }

    public void testTrivialWithTimeTracking() {
        this.importFile("trivial-with-timetracking.csv", "trivial-with-timetracking.properties", 60);
        this.goToProject(TRIVIA_NAME);
        this.assertTextPresent("Project: Trivia");
        this.assertElementPresent("project-avatar");
        this.assertTextPresent("Key:</b> TRV");
        this.displayAllIssues();
        this.assertTextPresentBeforeText("Unassigned", TRIVIA_REPORTER);
        this.clickLinkWithText("TRV-1");
        this.assertTextPresent(TRIVIA_SUMMARY);
        this.assertTextPresent(TRIVIA_DESCRIPTION);
        this.assertTextPresent(TRIVIA_TYPE);
        this.assertTextPresent("10 minutes");
        this.assertTextPresent("5 minutes");
        this.assertTextPresent("2 minutes");
    }

    public void testTrivialWithComments() {
        this.importFile("trivial-with-comments.csv", "trivial-with-comments.properties", 60);
        this.goToProject(TRIVIA_NAME);
        this.assertTextPresent("Project: Trivia");
        this.assertElementPresent("project-avatar");
        this.assertTextPresent("Key:</b> TRV");
        this.displayAllIssues();
        this.assertTextPresent("all 1 issue(s)");
        this.assertTextPresentBeforeText("Unassigned", TRIVIA_REPORTER);
        this.clickLinkWithText("TRV-1");
        this.assertTextPresent(TRIVIA_SUMMARY);
        this.assertTextPresent(TRIVIA_DESCRIPTION);
        this.assertTextPresent(TRIVIA_TYPE);
        this.assertTextSequence(new String[]{"Created", "12/Nov/02 9:00 AM", "Updated", "10/Oct/03 5:44 PM"});
        this.assertCollapsedTextSequence(new String[]{"Administrator", "10/Oct/03 5:44 PM", "Another comment that should not affect the issue updated date"});
        this.assertCollapsedTextSequence(new String[]{"Administrator", "10/Oct/03 5:44 PM", "A comment that should not affect the issue updated date"});
    }

    public void testTrivialWithTimeTrackingSpecifyingEstimateConverter() {
        this.importFile("trivial-with-timetracking.csv", "trivial-with-timetracking-estimate-converter-specified.properties", 60);
        this.goToProject(TRIVIA_NAME);
        this.assertTextPresent("Project: Trivia");
        this.assertElementPresent("project-avatar");
        this.assertTextPresent("Key:</b> TRV");
        this.displayAllIssues();
        this.assertTextPresentBeforeText("Unassigned", TRIVIA_REPORTER);
        this.clickLinkWithText("TRV-1");
        this.assertTextPresent(TRIVIA_SUMMARY);
        this.assertTextPresent(TRIVIA_DESCRIPTION);
        this.assertTextPresent(TRIVIA_TYPE);
        this.assertTextPresent("10 minutes");
        this.assertTextPresent("5 minutes");
        this.assertTextPresent("2 minutes");
    }

    public void testTrivialWithLabels() {
        this.importFile("trivial-with-labels.csv", "trivial-with-labels.properties", 60);
        this.goToProject(TRIVIA_NAME);
        this.assertTextPresent("Project: Trivia");
        this.assertElementPresent("project-avatar");
        this.assertTextPresent("Key:</b> TRV");
        HashSet<String> labelsPresent = new HashSet<String>();
        labelsPresent.add("ComPlex");
        this._assertLabelsForIssue("1", labelsPresent);
        labelsPresent.clear();
        labelsPresent.add("ComPlex");
        labelsPresent.add("a");
        labelsPresent.add("b");
        this._assertLabelsForIssue("2", labelsPresent);
        labelsPresent.clear();
        labelsPresent.add("abc");
        this._assertLabelsForIssue("3", labelsPresent);
        labelsPresent.clear();
        labelsPresent.add("a");
        labelsPresent.add("de");
        labelsPresent.add("b!c");
        this._assertLabelsForIssue("4", labelsPresent);
    }

    private void _assertLabelsForIssue(String issueNumber, Set<String> labelsPresent) {
        this.navigation.issueNavigator().displayAllIssues();
        this.clickLinkWithText("TRV-" + issueNumber);
        this.assertTextInElement("assignee-val", "Unassigned");
        this.assertTextInElement("reporter-val", TRIVIA_REPORTER.toLowerCase());
        this.assertTextPresent(TRIVIA_SUMMARY);
        this.assertTextPresent(TRIVIA_DESCRIPTION);
        this.assertTextPresent(TRIVIA_TYPE);
        String id = String.valueOf(this.parse.issue().parseViewIssuePage().getId());
        Labels expectedLabels = new Labels(true, true, true, labelsPresent);
        this.assertions.getLabelAssertions().assertSystemLabels(id, expectedLabels);
        this.assertions.getLabelAssertions().assertLabels(id, LABELS_CF_ID, expectedLabels);
    }

    public void testImportWizardWithTimetrackingDisabled() {
        this.clickLink("admin_link");
        this.clickLink("timetracking");
        this.submit("Deactivate");
        this.populateForm("trivial-with-timetracking.csv", null, true);
        this.submit("Start Import Wizard");
        this.assertTextPresent("Project Configuration");
        this.checkCheckbox("/bean/selectedProjectOption", "importexistingproject");
        this.submit("nextBtn");
        this.assertOptionNotPresent("field.OriginalEstimate", "Original Estimate (in seconds)");
        this.assertOptionNotPresent("field.OriginalEstimate", "Remaining Estimate (in seconds)");
        this.assertOptionNotPresent("field.OriginalEstimate", "Time Spent (in seconds)");
    }

    public void testImportWizardWithTimetrackingEnabled() {
        this.populateForm("trivial-with-timetracking.csv", null, true);
        this.submit("Start Import Wizard");
        this.assertTextPresent("Project Configuration");
        this.checkCheckbox("/bean/selectedProjectOption", "importexistingproject");
        this.submit("nextBtn");
        this.selectOption("field.OriginalEstimate", "Original Estimate (in seconds)");
        this.selectOption("field.OriginalEstimate", "Remaining Estimate (in seconds)");
        this.selectOption("field.OriginalEstimate", "Time Spent (in seconds)");
    }

    public void testImportTimeTracking() {
        this.populateForm("trivial-with-timetracking-2.csv", null, true);
        this.submit("Start Import Wizard");
        this.assertTextPresent("Project Configuration");
        this.checkCheckbox("/bean/selectedProjectOption", "importexistingproject");
        this.submit("nextBtn");
        this.selectOption("field.Title", "Summary");
        this.selectOption("field.Description", "Description");
        this.selectOption("field.Reporter", "Reporter");
        this.selectOption("field.OriginalEstimate", "Original Estimate (in seconds)");
        this.selectOption("field.RemainingEstimate", "Remaining Estimate (in seconds)");
        this.selectOption("field.TimeSpent", "Time Spent (in seconds)");
        this.submit("nextBtn");
        this.submit("nextBtn");
        this.setFormElement("user.email.suffix", "@atlassian.com");
        this.submit("nextBtn");
        this.assertTextPresent("Step 5 of 5");
        this.submit("submitBtn");
        this.submitImportAwaitCompletion(60);
        this.gotoIssue("HSP-1");
        this.assertTextSequence(new String[]{"Original Estimate", "10 minutes", "Remaining Estimate", "5 minutes", "Time Spent", "2 minutes"});
        this.gotoIssue("HSP-2");
        this.assertTextSequence(new String[]{"Original Estimate", "9 minutes", "Remaining Estimate", "9 minutes", "Time Spent", "Not Specified"});
        this.gotoIssue("HSP-3");
        this.assertTextSequence(new String[]{"Original Estimate", "8 minutes", "Remaining Estimate", "7 minutes", "Time Spent", "Not Specified"});
    }

    public void testImportWizardValidatesSummaryFieldIsMapped() throws SAXException {
        this.populateForm("redundant-field-mappings.csv", "redundant-field-mappings.properties", true);
        this.submit("Start Import Wizard");
        this.assertTextPresent("Project Configuration");
        this.checkCheckbox("/bean/selectedProjectOption", "importexistingproject");
        this.submit("nextBtn");
        this.assertOptionEquals("field.summary", "None");
        this.assertFieldMappings();
        this.submit("nextBtn");
        this.assertTextPresent("For the CSV import to be successful, you must specify a CSV header row that corresponds to the JIRA Summary field.");
        this.assertFieldMappings();
        this.selectOption("field.summary", "Summary");
        this.submit("nextBtn");
        this.assertTextNotPresent("For the CSV import to be successful, you must specify a CSV header row that corresponds to the JIRA Summary field.");
        this.assertTextPresent("CSV Import Wizard: Value Mappings (Step 3 of 5)");
    }

    private void assertFieldMappings() throws SAXException {
        this.assertOptionEquals("field.userNewCF", "New custom field");
        this.assertOptionEquals("field.userNewCFnewCustomFieldtype", "User Field");
        this.assertOptionEquals("field.versionExistingCF", "Existing custom field");
        this.assertOptionEquals("field.versionExistingCFexistingCustomField", "Version Custom Field");
        this.assertTextPresent("The following field mappings are defined in your existing configuration file, however they do not correspond to any of the columns in your CSV file. These mappings will be ignored.");
        WebTable unmappedFieldsTable = this.getDialog().getResponse().getTableWithID("unmappedFields");
        TestCsvImport.assertTrue((boolean)this.tableCellHasText(unmappedFieldsTable, 1, 0, "redundant0"));
        TestCsvImport.assertTrue((boolean)this.tableCellHasText(unmappedFieldsTable, 1, 1, "REDUNDANT0"));
        TestCsvImport.assertTrue((boolean)this.tableCellHasText(unmappedFieldsTable, 2, 0, "redundant1"));
        TestCsvImport.assertTrue((boolean)this.tableCellHasText(unmappedFieldsTable, 2, 1, "summary"));
        TestCsvImport.assertTrue((boolean)this.tableCellHasText(unmappedFieldsTable, 3, 0, "redundant2"));
        TestCsvImport.assertTrue((boolean)this.tableCellHasText(unmappedFieldsTable, 3, 1, "REDUNDANT2"));
        TestCsvImport.assertTrue((boolean)this.tableCellHasText(unmappedFieldsTable, 4, 0, "html"));
        TestCsvImport.assertTrue((boolean)this.tableCellHasText(unmappedFieldsTable, 4, 1, "<input id=\"wrong\"/>"));
        this.assertFormElementNotPresent("wrong");
    }

    public void testPropertiesFileValidation() {
        this.populateForm("mozilla.csv", "trivial-missingprojectkey.properties", false);
        this.submit("Import");
        this.assertTextPresent("The project details in the specified config file are invalid: You must specify a unique project key, at least 2 characters long, containing only uppercase letters.");
        this.populateForm("mozilla.csv", "trivial-invalidprojectlead.properties", false);
        this.submit("Import");
        this.assertTextPresent("The project details in the specified config file are invalid: The user you have specified as project lead does not exist.");
        this.populateForm("mozilla.csv", "trivial-duplicateprojectname.properties", false);
        this.submit("Import");
        this.assertTextPresent("The project details in the specified config file are invalid: A project with that name already exists.");
        this.populateForm("mozilla.csv", "trivial-invalidprojecturl.properties", false);
        this.submit("Import");
        this.assertTextPresent("The project details in the specified config file are invalid: The URL specified is not valid - it must start with http://");
    }

    public void testInvalidFieldNameChars() {
        this.populateForm("invalidfieldnames.csv", null, true);
        this.submit("Start Import Wizard");
        this.assertions.getJiraFormAssertions().assertFormErrMsg("The first header row of the CSV import file contains following errors for the field name 'bug+id' on position 1: 'plus sign'");
        this.assertions.getJiraFormAssertions().assertFormErrMsg("The first header row of the CSV import file contains following errors for the field name 'open(date' on position 2: 'brackets mismatch'");
        this.assertions.getJiraFormAssertions().assertFormErrMsg("The first header row of the CSV import file contains following errors for the field name 'bug[severity' on position 3: 'brackets mismatch'");
        this.assertions.getJiraFormAssertions().assertFormErrMsg("The first header row of the CSV import file contains following errors for the field name '(reporter+real[name' on position 7: 'brackets mismatch', 'plus sign'");
    }

    public void testImportWizardValidation() {
        this.gotoImport();
        this.clickLinkWithText("CSV Import Wizard");
        this.setFormElement("importLocation", "");
        this.submit("Start Import Wizard");
        this.assertTextPresent("You must specify a file to import");
        this.setFormElement("importLocation", "doesnotexist.csv");
        this.submit("Start Import Wizard");
        this.assertTextPresent("CSV file does not exist");
        this.populateForm("oneline.csv", null, true);
        this.submit("Start Import Wizard");
        this.assertTextPresent("Could not parse second line (after header row) of CSV file");
        this.populateForm("empty.csv", null, true);
        this.submit("Start Import Wizard");
        this.assertTextPresent("The CSV import file is empty");
    }

    public void testImportCustomCommentMapper() {
        this.importFile("comment_mapper.csv", "comment_mapper.properties", 60);
        this.displayAllIssues();
        this.clickLinkWithText("Test Issue 1");
        this.assertTextPresent("Has comment by existing user");
        this.assertLinkPresentWithText("Fred Normal");
        this.assertTextPresent("<span class=subText><span class=date>10/Jan/07 5:07 AM</span></span>");
        this.assertTextPresent("comment:fred:01/10/07 05:07:33 AM:This comment is by fred (existing user)");
        this.displayAllIssues();
        this.clickLinkWithText("Test Issue 2");
        this.assertTextPresent("Has comment by non-existing user");
        this.assertLinkPresentWithText("Administrator");
        this.assertTextPresent("<span class=subText><span class=date>10/Jan/07 2:08 PM</span></span>");
        this.assertTextPresent("comment:sam:01/10/07 02:08:33 PM:This comment is by sam (non-existing user)");
    }

    public void testMedium() {
        this.importFile("medium.csv", "medium.properties", 60);
        this.gotoPage("/browse/GDL");
        this.assertTextSequence(new String[]{"Grendel", "import from bugzilla via csv", "Lead:", "Administrator", "Key:", "GDL"});
        this.clickLink("issues-panel-panel");
        this.assertTextSequence(new String[]{"Unresolved: By Priority", "No priority", "8", "30%", "Blocker", "1", "4%", "Critical", "1", "4%", "Major", "3", "11%", "Minor", "13", "48%", "Trivial", "1", "4%", "Unresolved: By Assignee", "Kieran Maclean", "7", "26%", "R.J. Keller", "20", "74%", "Unresolved: By Version", "27", "Unscheduled", "Status Summary", "Open", "38", "46%", "Reopened", "4", "5%", "Resolved", "41", "49%", "Unresolved: By Component", "3", "Preferences", "6", "Protocols", "18", "User Interface"});
        this.gotoAdmin();
        this.clickLink("user_browser");
        this.assertTextSequence(new String[]{"1", "to", "of", "25", "abhinav", "abhinav@atlassian.com", "Abhinav", "adamfelson", "afelson@atlassian.com", "Adam Felson"});
        this.gotoAdmin();
        this.clickLink("view_custom_fields");
        this.assertTextSequence(new String[]{"bug_id", "Text Field", "keywords", "Multi Select", "priority", "Select List"});
    }

    public void testConfigWizard() {
        this.populateForm("mozilla.csv", null, true);
        this.setFormElement("configFileLocation", "");
        this.setFormElement("delimiter", "");
        this.submit("Start Import Wizard");
        this.checkCheckbox("/bean/selectedProjectOption", "importsingleproject");
        this.setFormElement("project.name", "Mozilla");
        this.setFormElement("project.key", KEY_MOZILLA);
        this.setFormElement("project.lead", "admin");
        this.setFormElement("project.description", "that browser");
        this.setFormElement("project.url", "http://www.mozilla.org/");
        this.submit("nextBtn");
        this.selectOption("field.bug_id", "New custom field");
        this.setFormElement("field.bug_idnewCustomField", "bugzilla_id");
        this.selectOption("field.bug_idnewCustomFieldtype", "Text Field");
        this.selectOption("field.opendate", "Date Created");
        this.selectOption("field.bug_severity", "Priority");
        this.selectOption("field.priority", "New custom field");
        this.selectOption("field.prioritynewCustomFieldtype", "Select List");
        this.selectOption("field.rep_platform", "Environment");
        this.selectOption("field.assigned_to_realname", "Assignee");
        this.selectOption("field.reporter_realname", "Reporter");
        this.selectOption("field.bug_status", "Status");
        this.checkCheckbox("bean/mapValues", "bug_status");
        this.checkCheckbox("bean/mapValues", "bug_severity");
        this.selectOption("field.resolution", "Resolution");
        this.checkCheckbox("bean/mapValues", "resolution");
        this.selectOption("field.product", "New custom field");
        this.selectOption("field.component", "Component/s");
        this.selectOption("field.version", "Affects Version/s");
        this.selectOption("field.target_milestone", "New custom field");
        this.selectOption("field.target_milestonenewCustomFieldtype", "Select List");
        this.selectOption("field.status_whiteboard", "New custom field");
        this.selectOption("field.status_whiteboardnewCustomFieldtype", "Text Field");
        this.selectOption("field.keywords", "New custom field");
        this.selectOption("field.short_desc", "Summary");
        this.submit("nextBtn");
        this.selectOption("value.0", "Blocker");
        this.selectOption("value.1", "Trivial");
        this.selectOption("value.2", "Major");
        this.selectOption("value.3", "Minor");
        this.selectOption("value.4", "Minor");
        this.selectOption("value.3", "Major");
        this.selectOption("value.2", "Critical");
        this.selectOption("value.5", "Open");
        this.selectOption("value.6", "Open");
        this.selectOption("value.5", "In Progress");
        this.selectOption("value.7", "Reopened");
        this.submit("nextBtn");
        this.setFormElement("user.email.suffix", "@atlassian.com");
        this.setFormElement("date.import.format", "yyyy-mm-dd hh:mm:ss");
        this.submit("nextBtn");
        this.assertTextPresent("Step 5 of 5");
        this.submit("submitBtn");
        this.tester.assertTextPresent("Import Data");
        this.tester.assertTextPresent("Choose the objects that you wish to be imported automatically into JIRA.");
        this.submitImportAwaitCompletion(60);
        this.gotoProjectBrowse(KEY_MOZILLA);
        this.assertTextSequence(new String[]{"Mozilla", "that browser", "URL:", "http://www.mozilla.org/", "Lead:", "Administrator", "Key:", KEY_MOZILLA});
        this.clickLink("issues-panel-panel");
        this.assertTextSequence(new String[]{"Unresolved: By Priority", "Blocker", "1", "3%", "Critical", "4", "13%", "Major", "2", "7%", "Minor", "15", "50%", "Trivial", "8", "27%", "Unresolved: By Assignee", "Andrew Schultz", "1", "3%", "Christopher Blizzard (not doing reviews)", "5", "17%", "David Baron", "1", "3%", "Doron Rosenberg (IBM)", "1", "3%", "Emil Hesslow", "1", "3%", "jag (Peter Annema)", "1", "3%", "Jean-Francois Ducarroz", "1", "3%", "Jungshik Shin", "1", "3%", "Mike Shaver", "1", "3%", "Mostafa Hosseini", "1", "3%", "neil@parkwaycc.co.uk", "1", "3%", "Nobody&#39;s working on this, feel free to take it", "6", "20%", "Robert Sayre", "1", "3%", "Samir Gehani", "1", "3%", "Sammy Ford", "1", "3%", "Seth Spitzer (not reading bugmail)", "1", "3%", "Simon Montagu", "1", "3%", "Stuart Parmenter", "1", "3%", "Todd Pringle", "1", "3%", "Unassigned", "2", "7%", "Unresolved: By Version", "30", "Unscheduled", "Status Summary", "Open", "24", "80%", "In Progress", "4", "13%", "Reopened", "2", "7%", "Unresolved: By Component", "1", "Base", "2", "Build Config", "1", "DOM: Level 0", "1", "File Handling", "1", "General", "1", "GFX", "1", "GFX: Gtk", "1", "History: Global", "1", "Internationalization", "1", "Layout: Fonts and Text", "2", "MailNews: Backend", "1", "MailNews: Composition", "1", "MailNews: Database", "1", "MailNews: Internationalization", "1", "MailNews: Main Mail Window", "1", "MailNews: Movemail", "1", "Preferences", "1", "RSS", "1", "Search", "1", "Selection", "1", "Sunbird and Calendar-Extension Front End", "1", "Web Services", "1", "Widget: Gtk", "2", "XP Apps", "2", "XP Toolkit/Widgets"});
        this.gotoIssue("MOZ-12");
        this.assertTextPresent("context menu is not context sensitive");
        this.assertTextPresentBeforeText("bugzilla_id:", "282292");
        this.assertTextPresentBeforeText("Reporter:", "Jamie Zawinski");
    }

    public void testUtf8() {
        this.populateForm("simple_utf-8.csv", null, true);
        this.submit("Start Import Wizard");
        this.assertTextPresent("Project Configuration");
        this.importFile("simple_utf-8.csv", "simple_utf-8.csv", 60);
    }

    public void testExistingCustomDateTimeField() {
        this.addCustomField("datetime", "custom-datetime");
        this.importFile("medium.csv", "existingCustomDateTime.properties", 60);
    }

    public void testVersionCustomFieldImport() {
        this.importFile("versioncfimport.csv", "versioncfimport.properties", 60);
        this.displayAllIssues();
        this.assertTextPresent("all 1 issue(s)");
        this.clickLinkWithText("HSP-1");
        this.assertLinkPresentWithText("New Version 5");
        this.assertTextPresent("The description field");
    }

    public void testImportWithExternalUserManagement() {
        this.toggleExternalUserManagement(true);
        this.populateForm("external-user-management.csv", "trivial.properties", false);
        this.submit("Import");
        this.assertTextPresent("Import Data");
        this.submit("Begin Import");
        this.assertTextPresent("users are referenced in the data you are trying to import");
        this.assertTextPresent(TRIVIA_REPORTER);
        this.assertTextNotPresent("fred");
    }

    public void testImportWithImportUsersDisabled() {
        this.populateForm("external-user-management.csv", "trivial.properties", false);
        this.submit("Import");
        this.checkCheckbox("importer/settings/userImportEnabled", "false");
        this.assertTextPresent("Import Data");
        this.submit("Begin Import");
        this.assertTextPresent("users are referenced in the data you are trying to import");
        this.assertTextPresent(TRIVIA_REPORTER);
        this.assertTextNotPresent("fred");
    }

    private void populateForm(String csvFile, String configFile, boolean useImportWizard) {
        File csv = new File(this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/" + csvFile);
        this.copyFileToCsvImportDirectory(csv);
        File config = null;
        if (configFile != null) {
            config = new File(this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/" + configFile);
            this.copyFileToCsvImportDirectory(config);
        }
        this.gotoImport();
        if (useImportWizard) {
            this.clickLinkWithText("CSV Import Wizard");
        }
        this.setFormElement("importLocation", csv.getName());
        if (config != null) {
            this.setFormElement("configFileLocation", config.getName());
        }
    }

    private void importFile(String csvFile, String configFile, int timeout) {
        this.populateForm(csvFile, configFile, false);
        this.submit("Import");
        this.checkCheckbox("importer/settings/userImportEnabled", "true");
        this.assertTextPresent("Import Data");
        this.submitImportAwaitCompletion(timeout);
    }

    private void submitImportAwaitCompletion(int timeout) {
        this.submit("Begin Import");
        int refreshCount = 0;
        int importRetries = (timeout + 1) / 2;
        while (this.getDialog().isTextInResponse("CSV import in progress") && refreshCount++ <= importRetries) {
            TestCsvImport.log("doing import status refresh " + refreshCount + " of " + importRetries);
            this.submit("Refresh");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ignore) {}
        }
        this.assertTextPresent("CSV import successfully completed");
    }

    private void gotoImport() {
        this.gotoPage("secure/admin/views/CsvImporter!default.jspa");
    }

    public void testImportWizardWithTabDelimiter() {
        this.populateForm("sample.tsv.txt", null, true);
        this.setFormElement("delimiter", "\\t");
        this.submit("Start Import Wizard");
        this.assertTextPresent("Project Configuration");
        this.checkCheckbox("/bean/selectedProjectOption", "importexistingproject");
        this.submit("nextBtn");
        this.selectOption("field.Issue type", "Issue Type");
        this.checkCheckbox("bean/mapValues", "Issue type");
        this.selectOption("field.Assigned to", "Assignee");
        this.selectOption("field.Priority", "Priority");
        this.checkCheckbox("bean/mapValues", "Priority");
        this.selectOption("field.Resolution", "Resolution");
        this.checkCheckbox("bean/mapValues", "Resolution");
        this.selectOption("field.Status", "Status");
        this.checkCheckbox("bean/mapValues", "Status");
        this.selectOption("field.Summary", "Summary");
        this.submit("nextBtn");
        this.selectOption("value.0", "Bug");
        this.selectOption("value.1", "Major");
        this.selectOption("value.2", "Fixed");
        this.selectOption("value.3", "Closed");
        this.selectOption("value.4", "Open");
        this.submit("nextBtn");
        this.setFormElement("user.email.suffix", "@atlassian.com");
        this.submit("nextBtn");
        this.setFormElement("configFileLocation", "");
        this.submit("submitBtn");
        this.checkCheckbox("importer/settings/userImportEnabled", "true");
        this.submitImportAwaitCompletion(60);
        this.displayAllIssues();
        this.assertTextPresent("TorqueSQLExec ignores lines starting with");
    }

    public void testImportIntoNewProjectFieldValidation() {
        this.populateForm("mozilla.csv", null, true);
        this.setFormElement("delimiter", "");
        this.submit("Start Import Wizard");
        this.checkCheckbox("/bean/selectedProjectOption", "importsingleproject");
        this.setFormElement("project.name", "");
        this.setFormElement("project.key", "");
        this.setFormElement("project.lead", "");
        this.setFormElement("project.description", "");
        this.setFormElement("project.url", "");
        this.submit("nextBtn");
        this.assertTextPresent("You must specify a valid project name.");
        this.assertTextPresent("You must specify a unique project key, at least 2 characters long, containing only uppercase letters.");
        this.assertTextPresent("You must specify a project lead.");
        this.setFormElement("project.name", "homosapien");
        this.setFormElement("project.key", "HSP");
        this.setFormElement("project.lead", "admin");
        this.setFormElement("project.description", "");
        this.setFormElement("project.url", "");
        this.submit("nextBtn");
        this.assertTextPresent("A project with that name already exists.");
        this.assertTextPresent("A project with that project key already exists.");
        this.setFormElement("project.name", "test project");
        this.setFormElement("project.key", "!");
        this.setFormElement("project.lead", "not a real user");
        this.setFormElement("project.description", "");
        this.setFormElement("project.url", "NOT A VALID URL");
        this.submit("nextBtn");
        this.assertTextPresent("You must specify a unique project key, at least 2 characters long, containing only uppercase letters.");
        this.assertTextPresent("The user you have specified as project lead does not exist.");
        this.assertTextPresent("The URL specified is not valid - it must start with http://");
        this.setFormElement("project.name", "test project");
        this.setFormElement("project.key", "TPT");
        this.setFormElement("project.lead", "admin");
        this.setFormElement("project.description", "Test Description");
        this.setFormElement("project.url", "http://testproject.example.com");
        this.submit("nextBtn");
        this.assertTextPresent("CSV Import Wizard: Issue Field Mappings (Step 2 of 5)");
    }

    public void testTrivialWithPersonalLicense() {
        this.switchToPersonalLicense();
        this.populateForm("trivial.csv", "trivial.properties", false);
        this.submit("Import");
        this.assertTextNotPresent("This will exceed the user limit enforced by your current license.");
        this.gotoAdmin();
        this.addUser("barney");
        this.populateForm("trivial.csv", "trivial.properties", false);
        this.submit("Import");
        this.assertTextPresent("This import will create 1 new user(s). This will exceed the number of users allowed to use JIRA under your license. New users will be created without the 'JIRA Users' permission, and thus will not be allowed to log in to JIRA.");
        this.checkCheckbox("importer/settings/userImportEnabled", "true");
        this.submitImportAwaitCompletion(60);
        this.gotoAdmin();
        this.clickLink("user_browser");
        this.assertTextPresent("chai");
        this.clickLinkWithText("chai");
        this.assertTextPresent("User: Chai");
        this.assertTextNotPresent("jira-users");
        this.clickLink("group_browser");
        this.clickLinkWithText("jira-users");
        this.assertTextPresent("Group: jira-users");
        this.assertTextSequence(new String[]{"Users", "3", "View", "Edit Members"});
    }

    public void testTrivialWithPersonalLicenseNoUnknownUsers() {
        this.restoreData("TestPersonalLicenseGlobalPermissions.xml");
        this.switchToPersonalLicense();
        this.populateForm("trivial-no-unknown-users.csv", "trivial.properties", false);
        this.submit("Import");
        this.assertTextNotPresent("This will exceed the user limit enforced by your current license.");
        this.populateForm("trivial-no-unknown-users.csv", "trivial.properties", false);
        this.submit("Import");
        this.assertTextPresent("This import will create 1 new user(s). This will exceed the number of users allowed to use JIRA under your license. New users will be created without the 'JIRA Users' permission, and thus will not be allowed to log in to JIRA.");
    }

    public void testImportResolutionDate() {
        this.importFile("mozilla_resolution_date.csv", "mozilla_resolution_date.properties", 60);
        this.gotoIssue("HSP-5");
        this.assertTextPresent("No resolution with resolution date");
        this.assertTextNotPresent("Resolved");
        this.gotoIssue("HSP-4");
        this.assertions.getTextAssertions().assertTextPresentHtmlEncoded("Webcam doesn't work");
        this.assertTextSequence(new String[]{"Created", "07/Sep/04 8:21 AM", "Updated", "07/Oct/04 11:45 AM", "Resolved", "07/Oct/04 11:45 AM"});
        this.gotoIssue("HSP-3");
        this.assertTextPresent("Duplicate entries appear in feeds");
        this.assertTextSequence(new String[]{"Created", "08/Sep/04 9:21 AM", "Resolved", "10/Dec/04 10:22 AM"});
        this.gotoIssue("HSP-2");
        this.assertTextPresent("debugging and about: options not implemented !");
        this.assertTextSequence(new String[]{"Created", "30/Apr/00 11:16 PM", "Updated", "05/Jun/01 11:12 PM", "Resolved", "05/Jun/01 11:12 PM"});
        this.gotoIssue("HSP-1");
        this.assertTextPresent("Downloads are stored");
        this.assertTextNotPresent("Resolved");
    }
}

