/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestBasic
extends JIRAWebTest {
    private static final String GERMAN_NEW_FEATURE = "Neue Funktion";

    public TestBasic(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
    }

    public void testI18NDates() {
        this.setLocaleTo("German (Germany)");
        this.createIssueInGermanWithDueDate("25/Dez/05");
        this.assertTextPresent("Es liegen noch keine Kommentare zu diesem Vorgang vor.");
        this.createIssueInGermanWithDueDate("25/Dec/05");
        this.assertTextPresent("Datum eingegeben. Geben Sie das Datum im Format");
    }

    public void testIssueConstantTranslations() {
        this.setLocaleTo("German (Germany)");
        this.updateBugTranslationWith("", "");
        this.browseToCustomFieldAdd();
        this.assertTextPresent("Alle Vorgangstypen");
        this.assertTextPresent("Bug");
        this.assertTextPresent("Verbesserung");
        this.assertTextPresent(GERMAN_NEW_FEATURE);
        this.assertTextPresent("Aufgabe");
        this.updateBugTranslationWith("bugenzee", "bugenzee desc");
        this.browseToCustomFieldAdd();
        this.assertTextPresent("bugenzee");
        this.assertTextNotPresent("Fehler");
    }

    private void updateBugTranslationWith(String name, String desc) {
        this.gotoAdmin();
        this.clickLink("issue_types");
        this.clickLink("translate_link");
        this.setWorkingForm("update");
        this.setFormElement("jira.translation.Vorgangstyp.1.name", name);
        this.setFormElement("jira.translation.Vorgangstyp.1.desc", desc);
        this.submit();
    }

    private void browseToCustomFieldAdd() {
        this.gotoAdmin();
        this.clickLink("view_custom_fields");
        this.clickLink("add_custom_fields");
        this.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:textarea");
        this.submit("nextBtn");
    }

    private void createIssueInGermanWithDueDate(String dueDate) {
        this.clickLink("create_link");
        this.setWorkingForm("issue-create");
        this.selectOption("pid", "homosapien");
        this.selectOption("issuetype", GERMAN_NEW_FEATURE);
        this.submit();
        this.setWorkingForm("issue-create");
        this.setFormElement("duedate", dueDate);
        this.setFormElement("summary", "test issue");
        this.assertFormElementHasValue("issue-create", "issue-create-submit", "Erstellen");
        this.submit("Create");
    }

    private void setLocaleTo(String localeName) {
        this.gotoPage("/secure/UpdateUserPreferences!default.jspa?username=admin");
        this.selectOption("userLocale", localeName);
        this.setWorkingForm("update-user-preferences");
        this.submit();
    }

    private void resetLocaleToEnglishFromGerman() {
        this.clickLinkWithText("Profil");
        this.clickLinkWithText("Bearbeiten der Einstellungen");
        this.selectMultiOptionByValue("userLocale", "-1");
        this.submit("Aktualisieren");
    }
}

