/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.security;

import com.atlassian.jira.functest.framework.FuncTestCase;
import net.sourceforge.jwebunit.ExpectedRow;
import net.sourceforge.jwebunit.ExpectedTable;

public class TestIssueSecurityLevel
extends FuncTestCase {
    protected void setUpTest() {
        this.administration.restoreData("TestIssueSecurityLevel.xml");
    }

    public void testIssueNavigatorVisibility() {
        this.navigation.login("bill");
        this.navigation.issueNavigator().hideActionsColumn();
        this.navigation.issueNavigator().displayAllIssues();
        ExpectedTable expectedTable = new ExpectedTable();
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"T", "Key", "Summary", "Assignee", "Reporter", "P", "Status", "Resolution", "Created", "Updated", "Due"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"COW-47", "COW-47", "Cowboys and Admins", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", ""}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"COW-46", "COW-46", "Any User (project role)", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", ""}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"COW-44", "COW-44", "Friendly Users - Bill included", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", ""}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"COW-41", "COW-41", "Friendly Group - Cowboy Group", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", ""}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"COW-40", "COW-40", "Security Level Project Lead", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", ""}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"COW-39", "COW-39", "Security Level Bill User", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", ""}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"COW-37", "COW-37", "Issue Assigned to Bill", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", ""}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"COW-36", "COW-36", "Issue added by Bill.", "Henry Ford", "Wild Bill Hickock", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", ""}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"COW-35", "COW-35", "Milk the jersey", "Henry Ford", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", ""}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"COW-34", "COW-34", "Get along little doggy", "Henry Ford", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", ""}));
        this.tester.assertTableEquals("issuetable", expectedTable);
        this.tester.assertTextNotPresent("COW-38");
        this.tester.assertTextNotPresent("Issue not assigned to Bill");
        this.tester.assertTextNotPresent("COW-42");
        this.tester.assertTextNotPresent("Friendly Group - No Group");
        this.tester.assertTextNotPresent("COW-43");
        this.tester.assertTextNotPresent("Friendly Group - jira-developers Group");
        this.tester.assertTextNotPresent("COW-45");
        this.tester.assertTextNotPresent("Friendly Users - Bill not included");
        this.tester.assertTextNotPresent("COW-48");
        this.tester.assertTextNotPresent("Reporters and Developers - not reported by Bill");
    }

    public void testBrowseIssueVisibility() {
        this.navigation.login("bill");
        this.navigation.issue().viewIssue("COW-34");
        this.tester.assertTextNotPresent("Permission Violation");
        this.navigation.issue().viewIssue("COW-35");
        this.tester.assertTextNotPresent("Permission Violation");
        this.navigation.issue().viewIssue("COW-36");
        this.tester.assertTextNotPresent("Permission Violation");
        this.navigation.issue().viewIssue("COW-37");
        this.tester.assertTextNotPresent("Permission Violation");
        this.navigation.issue().viewIssue("COW-39");
        this.tester.assertTextNotPresent("Permission Violation");
        this.navigation.issue().viewIssue("COW-40");
        this.tester.assertTextNotPresent("Permission Violation");
        this.navigation.issue().viewIssue("COW-41");
        this.tester.assertTextNotPresent("Permission Violation");
        this.navigation.issue().viewIssue("COW-44");
        this.tester.assertTextNotPresent("Permission Violation");
        this.navigation.issue().viewIssue("COW-46");
        this.tester.assertTextNotPresent("Permission Violation");
        this.navigation.issue().viewIssue("COW-47");
        this.tester.assertTextNotPresent("Permission Violation");
        this.navigation.issue().viewIssue("COW-38");
        this.tester.assertTextPresent("Permission Violation");
        this.navigation.issue().viewIssue("COW-42");
        this.tester.assertTextPresent("Permission Violation");
        this.navigation.issue().viewIssue("COW-43");
        this.tester.assertTextPresent("Permission Violation");
        this.navigation.issue().viewIssue("COW-45");
        this.tester.assertTextPresent("Permission Violation");
        this.navigation.issue().viewIssue("COW-48");
        this.tester.assertTextPresent("Permission Violation");
    }

    public void testIssueNavigatorVisibility_User_Gandhi() {
        this.navigation.login("gandhi");
        this.navigation.issueNavigator().hideActionsColumn();
        this.navigation.issueNavigator().displayAllIssues();
        ExpectedTable expectedTable = new ExpectedTable();
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"T", "Key", "Summary", "Assignee", "Reporter", "P", "Status", "Resolution", "Created", "Updated", "Due"}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"COW-48", "COW-48", "Reporters and Developers - not reported by Bill", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", ""}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"COW-46", "COW-46", "Any User (project role)", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", ""}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"COW-45", "COW-45", "Friendly Users - Bill not included", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", ""}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"COW-44", "COW-44", "Friendly Users - Bill included", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", ""}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"COW-43", "COW-43", "Friendly Group - jira-developers Group", "Wild Bill Hickock", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", ""}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"COW-36", "COW-36", "Issue added by Bill.", "Henry Ford", "Wild Bill Hickock", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", ""}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"COW-35", "COW-35", "Milk the jersey", "Henry Ford", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", ""}));
        expectedTable.appendRow(new ExpectedRow((Object[])new String[]{"COW-34", "COW-34", "Get along little doggy", "Henry Ford", "Mark", "", "Open", "Unresolved", "08/Jul/08", "08/Jul/08", ""}));
        this.tester.assertTableEquals("issuetable", expectedTable);
        this.tester.assertTextNotPresent("COW-37");
        this.tester.assertTextNotPresent("Issue assigned to Bill");
        this.tester.assertTextNotPresent("COW-38");
        this.tester.assertTextNotPresent("Issue not assigned to Bill");
        this.tester.assertTextNotPresent("COW-39");
        this.tester.assertTextNotPresent("Security Level Bill User");
        this.tester.assertTextNotPresent("COW-40");
        this.tester.assertTextNotPresent("Security Level Project Leadl");
        this.tester.assertTextNotPresent("COW-41");
        this.tester.assertTextNotPresent("Friendly Group - Cowboy Group");
        this.tester.assertTextNotPresent("COW-42");
        this.tester.assertTextNotPresent("Friendly Group - No Group");
        this.tester.assertTextNotPresent("COW-47");
        this.tester.assertTextNotPresent("Cowboys and Admins");
    }

    public void testSecurityLevelCache() {
    }
}

