/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.core.util.FileUtils;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpException;
import com.meterware.httpunit.WebRequest;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.IXPath;
import electric.xml.ParseException;
import electric.xml.XPath;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TestXmlCustomIssueView
extends JIRAWebTest {
    public TestXmlCustomIssueView(String name) {
        super(name);
    }

    public void testNodeFilter() throws IOException, ParseException {
        this.restoreData("TestXMLIssueCustomView.xml");
        this.checkNodeFilter("field=title", "title");
        this.checkNodeFilter("field=link", "link");
        this.checkNodeFilter("field=project", "project");
        this.checkNodeFilter("field=summary", "summary");
        this.checkNodeFilter("field=description", "description");
        this.checkNodeFilter("field=environment", "environment");
        this.checkNodeFilter("field=issuetype", "type");
        this.checkNodeFilter("field=priority", "priority");
        this.checkNodeFilter("field=status", "status");
        this.checkNodeFilter("field=resolution", "resolution");
        this.checkNodeFilter("field=security", "security");
        this.checkNodeFilter("field=assignee", "assignee");
        this.checkNodeFilter("field=reporter", "reporter");
        this.checkNodeFilter("field=created", "created");
        this.checkNodeFilter("field=updated", "updated");
        this.checkNodeFilter("field=resolutiondate", "resolved");
        this.checkNodeFilter("field=version", "version");
        this.checkNodeFilter("field=fixVersions", "fixVersion");
        this.checkNodeFilter("field=component", "component");
        this.checkNodeFilter("field=due", "due");
        this.checkNodeFilter("field=votes", "votes");
        this.checkNodeFilter("field=comments", "comments");
        this.checkNodeFilter("field=attachment", "attachments");
        this.checkNodeFilter("field=subtasks", "subtasks");
        this.checkNodeFilter("field=issuelinks", "issuelinks");
        this.checkNodeFilter("field=timespent", "timespent");
        this.checkNodeFilter("field=timeestimate", "timeestimate");
        this.checkNodeFilter("field=timeoriginalestimate", "timeoriginalestimate");
        this.checkNodeFilter("field=aggregatetimeoriginalestimate", "aggregatetimeoriginalestimate");
        this.checkNodeFilter("field=aggregatetimeestimate", "aggregatetimereaminingestimate");
        this.checkNodeFilter("field=aggregatetimespent", "aggregatetimespent");
    }

    public void testProjectFieldFilter() throws IOException, ParseException {
        this.restoreData("TestXMLIssueCustomView.xml");
        String fieldParam = "field=project";
        String issueKey = "HSP-1";
        this.gotoPage(this.getHSP1ViewPage(fieldParam));
        TestXmlCustomIssueView.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", issueKey, null);
        this.assertElementExists(doc, "//item/project");
        this.assertElementExists(doc, "//item/project[@id='10000']");
        this.assertElementExists(doc, "//item/project[@key='HSP']");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
    }

    public void testCustomFieldFilter() throws IOException, ParseException {
        this.restoreData("TestXMLIssueCustomView.xml");
        String fieldParam = "field=allcustom";
        String issueKey = "HSP-1";
        this.gotoPage(this.getHSP1ViewPage(fieldParam));
        TestXmlCustomIssueView.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", issueKey, null);
        this.assertElementExists(doc, "//item/customfields");
        this.assertElementExists(doc, "//item/customfields/customfield");
        this.assertElementExists(doc, "//item/customfields/customfield[@id='customfield_10000']");
        this.assertElementExists(doc, "//item/customfields/customfield[@id='customfield_10001']");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
        fieldParam = "field=allcustom";
        issueKey = "HSP-2";
        this.gotoPage(this.getHSP2ViewPage(fieldParam));
        TestXmlCustomIssueView.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", issueKey, null);
        this.assertElementExists(doc, "//item/customfields");
        this.assertElementNotExists(doc, "//item/customfields/customfield");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
        fieldParam = "field=customfield_10000";
        issueKey = "HSP-1";
        this.gotoPage(this.getHSP1ViewPage(fieldParam));
        TestXmlCustomIssueView.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", issueKey, null);
        this.assertElementExists(doc, "//item/customfields");
        this.assertElementExists(doc, "//item/customfields/customfield");
        this.assertElementExists(doc, "//item/customfields/customfield[@id='customfield_10000']");
        this.assertElementNotExists(doc, "//item/customfields/customfield[@id='customfield_10001']");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
        fieldParam = "field=customfield_10001";
        issueKey = "HSP-1";
        this.gotoPage(this.getHSP1ViewPage(fieldParam));
        TestXmlCustomIssueView.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", issueKey, null);
        this.assertElementExists(doc, "//item/customfields");
        this.assertElementExists(doc, "//item/customfields/customfield");
        this.assertElementExists(doc, "//item/customfields/customfield[@id='customfield_10001']");
        this.assertElementNotExists(doc, "//item/customfields/customfield[@id='customfield_10000']");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
        fieldParam = "field=customfield_10000";
        issueKey = "HSP-2";
        this.gotoPage(this.getHSP2ViewPage(fieldParam));
        TestXmlCustomIssueView.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", issueKey, null);
        this.assertElementExists(doc, "//item/customfields");
        this.assertXpathElementNotPresent(doc, "//item/customfields/customfield");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
        fieldParam = "field=customfield_10001";
        issueKey = "HSP-2";
        this.gotoPage(this.getHSP2ViewPage(fieldParam));
        TestXmlCustomIssueView.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", issueKey, null);
        this.assertElementExists(doc, "//item/customfields");
        this.assertXpathElementNotPresent(doc, "//item/customfields/customfield");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
    }

    public void testMultipleNodeFilter() throws IOException, ParseException {
        this.restoreData("TestXMLIssueCustomView.xml");
        String fieldParam = "field=title&field=link&field=project&field=summary&field=description&field=environment&field=issuetype&field=priority&field=status&field=resolution&field=security&field=assignee&field=reporter&field=created&field=updated&field=resolutiondate&field=version&field=fixVersions&field=component&field=due&field=votes&field=comments&field=attachments&field=subtasks&field=issuelinks&field=timespent&field=timeestimate&field=timeoriginalestimate&field=aggregatetimeoriginalestimate&field=aggregatetimeestimate&field=aggregatetimespent";
        String issueKey = "HSP-1";
        this.gotoPage(this.getHSP1ViewPage("field=title&field=link&field=project&field=summary&field=description&field=environment&field=issuetype&field=priority&field=status&field=resolution&field=security&field=assignee&field=reporter&field=created&field=updated&field=resolutiondate&field=version&field=fixVersions&field=component&field=due&field=votes&field=comments&field=attachments&field=subtasks&field=issuelinks&field=timespent&field=timeestimate&field=timeoriginalestimate&field=aggregatetimeoriginalestimate&field=aggregatetimeestimate&field=aggregatetimespent"));
        TestXmlCustomIssueView.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", issueKey, null);
        this.assertElementExists(doc, "//item/title");
        this.assertElementExists(doc, "//item/link");
        this.assertElementExists(doc, "//item/project");
        this.assertElementExists(doc, "//item/project[@key]");
        this.assertElementExists(doc, "//item/summary");
        this.assertElementExists(doc, "//item/description");
        this.assertElementExists(doc, "//item/environment");
        this.assertElementExists(doc, "//item/summary");
        this.assertElementExists(doc, "//item/type");
        this.assertElementExists(doc, "//item/priority");
        this.assertElementExists(doc, "//item/status");
        this.assertElementExists(doc, "//item/resolution");
        this.assertElementExists(doc, "//item/security");
        this.assertElementExists(doc, "//item/assignee");
        this.assertElementExists(doc, "//item/reporter");
        this.assertElementExists(doc, "//item/created");
        this.assertElementExists(doc, "//item/updated");
        this.assertElementExists(doc, "//item/resolved");
        this.assertElementExists(doc, "//item/version");
        this.assertElementExists(doc, "//item/fixVersion");
        this.assertElementExists(doc, "//item/component");
        this.assertElementExists(doc, "//item/due");
        this.assertElementExists(doc, "//item/votes");
        this.assertElementExists(doc, "//item/comments");
        this.assertElementExists(doc, "//item/attachments");
        this.assertElementExists(doc, "//item/subtasks");
        this.assertElementExists(doc, "//item/issuelinks");
        this.assertElementExists(doc, "//item/timespent");
        this.assertElementExists(doc, "//item/timeoriginalestimate");
        this.assertElementExists(doc, "//item/timeestimate");
        this.assertElementExists(doc, "//item/aggregatetimeoriginalestimate");
        this.assertElementExists(doc, "//item/aggregatetimeremainingestimate");
        this.assertElementExists(doc, "//item/aggregatetimespent");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
    }

    public void testParentNodeFilter() throws IOException, ParseException {
        this.restoreData("TestXMLIssueCustomView.xml");
        String fieldParam = "field=parent";
        String issueKey = "HSP-3";
        this.gotoPage(this.getHSP3ViewPage("field=parent"));
        TestXmlCustomIssueView.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", issueKey, null);
        this.assertElementExists(doc, "//item/parent");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
    }

    public void testNodeFilterMapping() throws IOException, ParseException {
        this.restoreData("TestXMLIssueCustomView.xml");
        this.checkNodeFilter("field=pid", "project");
        this.checkNodeFilter("field=comment", "comments");
        this.checkNodeFilter("field=components", "component");
        this.checkNodeFilter("field=duedate", "due");
        this.checkNodeFilter("field=type", "type");
        this.checkNodeFilter("field=versions", "version");
        this.checkNodeFilter("field=fixfor", "fixVersion");
        this.checkNodeFilter("field=attachments", "attachments");
        this.checkNodeFilter("field=resolved", "resolved");
        this.checkNodeFilter("field=aggregatetimeremainingestimate", "aggregatetimeremainingestimate");
    }

    public void testInvalidFieldDefined() {
        this.restoreData("TestXMLIssueCustomView.xml");
        boolean isWebSphere = new EnvironmentUtils(this.tester, this.getEnvironmentData(), this.navigation).isWebSphere();
        if (!isWebSphere) {
            this.checkFieldDefinitionError("field");
        }
        this.checkFieldDefinitionError("field=");
        this.checkFieldDefinitionError("field=nonExisting");
        this.checkFieldDefinitionError("field=nonExistin1&field=nonExisting2");
    }

    public void testValidAndInvalidFieldDefined() throws IOException, ParseException {
        this.restoreData("TestXMLIssueCustomView.xml");
        this.checkNodeFilter("field=project&field=nonExisting2", "project");
    }

    public void testTimetrackingField() throws IOException, ParseException {
        this.restoreData("TestXMLIssueCustomView.xml");
        String fieldParam = "field=timetracking";
        String issueKey = "HSP-1";
        this.gotoPage(this.getHSP1ViewPage("field=timetracking"));
        TestXmlCustomIssueView.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", issueKey, null);
        this.assertElementExists(doc, "//item/timespent");
        this.assertElementExists(doc, "//item/timeoriginalestimate");
        this.assertElementExists(doc, "//item/timeestimate");
        this.assertElementExists(doc, "//item/aggregatetimeoriginalestimate");
        this.assertElementExists(doc, "//item/aggregatetimeremainingestimate");
        this.assertElementExists(doc, "//item/aggregatetimespent");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
        this.setHiddenFields("Time Tracking");
        this.gotoPage(this.getHSP1ViewPage("field=timetracking"));
        TestXmlCustomIssueView.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", issueKey, null);
        this.assertElementNotExists(doc, "//item/timespent");
        this.assertElementNotExists(doc, "//item/timeoriginalestimate");
        this.assertElementNotExists(doc, "//item/timeestimate");
        this.assertElementNotExists(doc, "//item/aggregatetimeoriginalestimate");
        this.assertElementNotExists(doc, "//item/aggregatetimeremainingestimate");
        this.assertElementNotExists(doc, "//item/aggregatetimespent");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
        this.deactivateTimeTracking();
        this.checkDisabledTimetracking(issueKey, "field=timetracking");
        this.checkDisabledTimetracking(issueKey, "field=timespent");
        this.checkDisabledTimetracking(issueKey, "field=timeoriginalestimate");
        this.checkDisabledTimetracking(issueKey, "field=timeestimate");
        this.checkDisabledTimetracking(issueKey, "field=aggregatetimeoriginalestimate");
        this.checkDisabledTimetracking(issueKey, "field=aggregatetimeremainingestimate");
        this.checkDisabledTimetracking(issueKey, "field=aggregatetimespent");
    }

    protected void checkDisabledTimetracking(String issueKey, String fieldParam) throws IOException, ParseException {
        this.gotoPage(this.getHSP1ViewPage(fieldParam));
        TestXmlCustomIssueView.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", issueKey, null);
        this.assertElementNotExists(doc, "//item/timespent");
        this.assertElementNotExists(doc, "//item/timeoriginalestimate");
        this.assertElementNotExists(doc, "//item/timeestimate");
        this.assertElementNotExists(doc, "//item/aggregatetimeoriginalestimate");
        this.assertElementNotExists(doc, "//item/aggregatetimeremainingestimate");
        this.assertElementNotExists(doc, "//item/aggregatetimespent");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
    }

    protected void checkFieldDefinitionError(String fieldParam) {
        String issueKey = "HSP-1";
        String issueUrl = this.getEnvironmentData().getBaseUrl().toString() + "/si/jira.issueviews:issue-xml/" + issueKey + "/" + issueKey + ".xml?" + fieldParam;
        GetMethodWebRequest request = new GetMethodWebRequest(issueUrl);
        try {
            this.getTester().getTestContext().getWebClient().sendRequest((WebRequest)request);
            TestXmlCustomIssueView.fail((String)"Invalid field param passed validation");
        }
        catch (HttpException e) {
            TestXmlCustomIssueView.assertEquals((int)400, (int)e.getResponseCode());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getHSP1ViewPage(String fieldParam) {
        return "/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml?" + fieldParam;
    }

    protected String getHSP2ViewPage(String fieldParam) {
        return "/si/jira.issueviews:issue-xml/HSP-2/HSP-2.xml?" + fieldParam;
    }

    protected String getHSP3ViewPage(String fieldParam) {
        return "/si/jira.issueviews:issue-xml/HSP-3/HSP-3.xml?" + fieldParam;
    }

    private void assertCommentDoesNotHaveDetailsOnRestrictingFields(Document doc) {
        TestXmlCustomIssueView.log("Checking the contents of the XML comment of the XML resulsts");
        Node commentNode = doc.getFirstChild();
        TestXmlCustomIssueView.assertNotNull((Object)commentNode);
        TestXmlCustomIssueView.assertEquals((short)8, (short)commentNode.getNodeType());
        String commentText = commentNode.getNodeValue();
        TestXmlCustomIssueView.assertNotNull((Object)commentText);
        TestXmlCustomIssueView.assertTrue((commentText.indexOf("RSS generated by JIRA") > -1 ? 1 : 0) != 0);
        TestXmlCustomIssueView.assertEquals((int)-1, (int)commentText.indexOf("It is possible to restrict the fields"));
    }

    protected void checkNodeFilter(String fieldParam, String expectedField) throws IOException, ParseException {
        String issueKey = "HSP-1";
        this.gotoPage(this.getHSP1ViewPage(fieldParam));
        TestXmlCustomIssueView.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", issueKey, null);
        this.assertElementForCustomView(doc, "//item/project", expectedField);
        this.assertElementForCustomView(doc, "//item/title", expectedField);
        this.assertElementForCustomView(doc, "//item/description", expectedField);
        this.assertElementForCustomView(doc, "//item/environment", expectedField);
        this.assertElementForCustomView(doc, "//item/summary", expectedField);
        this.assertElementForCustomView(doc, "//item/type", expectedField);
        this.assertElementForCustomView(doc, "//item/priority", expectedField);
        this.assertElementForCustomView(doc, "//item/status", expectedField);
        this.assertElementForCustomView(doc, "//item/resolution", expectedField);
        this.assertElementForCustomView(doc, "//item/security", expectedField);
        this.assertElementForCustomView(doc, "//item/assignee", expectedField);
        this.assertElementForCustomView(doc, "//item/reporter", expectedField);
        this.assertElementForCustomView(doc, "//item/created", expectedField);
        this.assertElementForCustomView(doc, "//item/updated", expectedField);
        this.assertElementForCustomView(doc, "//item/version", expectedField);
        this.assertElementForCustomView(doc, "//item/fixVersion", expectedField);
        this.assertElementForCustomView(doc, "//item/component", expectedField);
        this.assertElementForCustomView(doc, "//item/due", expectedField);
        this.assertElementForCustomView(doc, "//item/votes", expectedField);
        this.assertElementForCustomView(doc, "//item/comments", expectedField);
        this.assertElementForCustomView(doc, "//item/attachments", expectedField);
        this.assertElementForCustomView(doc, "//item/subtasks", expectedField);
        this.assertElementForCustomView(doc, "//item/issuelinks", expectedField);
        this.assertElementForCustomView(doc, "//item/timespent", expectedField);
        this.assertElementForCustomView(doc, "//item/timeoriginalestimate", expectedField);
        this.assertElementForCustomView(doc, "//item/timeestimate", expectedField);
        this.assertElementForCustomView(doc, "//item/aggregatetimeoriginalestimate", expectedField);
        this.assertElementForCustomView(doc, "//item/aggregatetimeestimate", expectedField);
        this.assertElementForCustomView(doc, "//item/aggregatetimespent", expectedField);
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
    }

    protected void assertElementForCustomView(Document doc, String xPathExpression, String expectedField) {
        String field = "/" + expectedField;
        if (xPathExpression.endsWith(field)) {
            this.assertElementExists(doc, xPathExpression);
        } else {
            this.assertElementNotExists(doc, xPathExpression);
        }
    }

    protected void assertElementExists(Document doc, String xPathExpression) {
        XPath xPath = new XPath(xPathExpression);
        Element element = doc.getElement((IXPath)xPath);
        TestXmlCustomIssueView.assertNotNull((String)("Element at xpath '" + xPathExpression + "' should not be null"), (Object)element);
    }

    protected void assertElementNotExists(Document doc, String xPathExpression) {
        XPath xPath = new XPath(xPathExpression);
        Element element = doc.getElement((IXPath)xPath);
        TestXmlCustomIssueView.assertNull((String)("Element at xpath '" + xPathExpression + "' should not be present"), (Object)element);
    }

    private void assertXpathElementNotPresent(Document doc, String xpathExpression) {
        XPath xPath = new XPath(xpathExpression);
        Element element = doc.getElement((IXPath)xPath);
        if (element != null) {
            TestXmlCustomIssueView.fail((String)("XML document contains element on path: " + xpathExpression));
        }
    }

    public void assertExpectedXpathValue(Document doc, String xPathExpression, String expectedValue, String attribute) {
        XPath xPath = new XPath(xPathExpression);
        Element element = doc.getElement((IXPath)xPath);
        String actualValue = attribute == null ? element.getText().toString() : element.getAttribute(attribute);
        TestXmlCustomIssueView.assertEquals((String)expectedValue, (String)actualValue);
        this.gotoPage("/secure/project/ViewProjects.jspa");
    }

    protected Document getDocument() throws IOException, ParseException {
        InputStream inputStream = this.getDialog().getResponse().getInputStream();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        FileUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        return new Document(outputStream.toByteArray());
    }
}

