/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class TestVoters
extends FuncTestCase {
    private static final Issue ISSUE_WITH_VOTE = new Issue("HSP-1", 10010L);
    private static final Issue ISSUE_WITHOUT_VOTE = new Issue("HSP-2", 10020L);
    private static final Issue ISSUE_RESOLVED_WITHOUT_VOTE = new Issue("HSP-3", 10030L);
    private static final Issue ISSUE_RESOLVED_WITH_VOTE = new Issue("HSP-4", 10040L);
    private static final Issue ISSUE_ADMIN_CAN_VOTE = new Issue("HSP-5", 10050L);
    private static final String ID_VOTE_LINK = "vote-toggle";
    private static final String ID_VOTE_SPAN = "vote-label";
    private static final String ID_VOTE_COUNT = "vote-data";
    private static final String ID_VOTE_COUNT_LINK = "view-voter-list";
    private static final String ID_VOTERS_ACTION = "view-voters";
    private static final String ID_VOTE_ACTION = "toggle-vote-issue";
    private static final String XPATH_VOTE_SPAN_TITLE = String.format("//span[@id='%s']/@title", "vote-label");
    private static final String XPATH_VOTE_LINK_TITLE = String.format("//a[@id='%s']/@title", "vote-toggle");
    private static final String XPATH_VIEW_VOTERS_LINK = "//a[@id='view-voter-list']";
    private static final String XPATH_VIEW_VOTERS_SPAN = "//span[@id='vote-data']";
    private static final String MSG_CANT_VOTE_ANON = "You have to be logged in to vote for an issue.";
    private static final String MSG_CANT_VOTE_REPORTER = "You cannot vote for an issue you have reported.";
    private static final String MSG_CANT_VOTE_RESOLVED = "You cannot vote or change your vote on resolved issues.";
    private static final String MSG_CANT_REMOVE_VOTE = "Cannot remove a vote for an issue that the user has not already voted for.";
    private static final String MSG_CANT_ADD_VOTE = "Cannot add a vote for an issue that the user has already voted for";
    private static final String MSG_CANT_VOTE_ANON_ERROR = "Login Required";
    private static final String MSG_CANT_VOTE_REPORTER_ERROR = "You cannot vote for an issue you have reported.";
    private static final String USER_ADMIN = "admin";
    private static final String USER_FRED = "fred";

    protected void setUpTest() {
        this.administration.restoreData("TestVoters.xml");
    }

    public void testAnonmousCannotVote() {
        this.navigation.logout();
        this.gotoIssue(ISSUE_WITH_VOTE);
        this.assertCantVote(ISSUE_WITH_VOTE, MSG_CANT_VOTE_ANON, MSG_CANT_VOTE_ANON_ERROR, 1);
        this.navigation.login(USER_ADMIN);
    }

    public void testReporterCannotVote() {
        this.gotoIssue(ISSUE_WITH_VOTE);
        this.assertCantVote(ISSUE_WITH_VOTE, "You cannot vote for an issue you have reported.", "You cannot vote for an issue you have reported.", 1);
    }

    public void testUserVoting() {
        this.navigation.login(USER_FRED);
        this.gotoIssue(ISSUE_WITH_VOTE);
        this.assertUserVoted();
        TestVoters.assertEquals((int)1, (int)this.getVoteCount());
        this.voteDirectlyForIssue(ISSUE_WITH_VOTE);
        this.tester.assertTextPresent(MSG_CANT_ADD_VOTE);
        this.gotoIssue(ISSUE_WITH_VOTE);
        this.assertUserVoted();
        TestVoters.assertEquals((int)1, (int)this.getVoteCount());
        this.tester.clickLink(ID_VOTE_LINK);
        this.assertUserNotVoted();
        TestVoters.assertEquals((int)0, (int)this.getVoteCount());
        this.unVoteDirectlyForIssue(ISSUE_WITH_VOTE);
        this.tester.assertTextPresent(MSG_CANT_REMOVE_VOTE);
        this.gotoIssue(ISSUE_WITH_VOTE);
        this.assertUserNotVoted();
        TestVoters.assertEquals((int)0, (int)this.getVoteCount());
        this.tester.clickLink(ID_VOTE_LINK);
        this.assertUserVoted();
        TestVoters.assertEquals((int)1, (int)this.getVoteCount());
        this.navigation.login(USER_ADMIN);
    }

    private void assertVotingLinks(boolean voted) {
        this.tester.assertLinkPresent(ID_VOTE_LINK);
        this.tester.assertLinkPresent(ID_VOTE_ACTION);
        if (voted) {
            this.tester.assertTextInElement(ID_VOTE_ACTION, "Remove Vote");
        } else {
            this.tester.assertTextInElement(ID_VOTE_ACTION, "Add Vote");
        }
    }

    public void testCannotVoteOnResolved() {
        this.navigation.login(USER_FRED);
        this.assertCantVote(ISSUE_RESOLVED_WITHOUT_VOTE, MSG_CANT_VOTE_RESOLVED, MSG_CANT_VOTE_RESOLVED, 0);
        this.unVoteDirectlyForIssue(ISSUE_RESOLVED_WITH_VOTE);
        this.tester.assertTextPresent(MSG_CANT_VOTE_RESOLVED);
        this.gotoIssue(ISSUE_RESOLVED_WITH_VOTE);
        TestVoters.assertEquals((int)1, (int)this.getVoteCount());
    }

    public void testViewVotersWithPermission() throws Exception {
        this.gotoIssue(ISSUE_WITH_VOTE);
        this.assertCanViewVoters();
        this.tester.assertLinkPresent("voter_link_fred");
        this.gotoIssue(ISSUE_ADMIN_CAN_VOTE);
        this.assertCanViewVoters();
        this.tester.assertTextPresent("There are no voters for this issue");
        this.gotoIssue(ISSUE_RESOLVED_WITH_VOTE);
        this.assertCanViewVoters();
        this.tester.assertLinkPresent("voter_link_fred");
    }

    public void testViewVotersWithoutPermission() throws Exception {
        this.navigation.login(USER_FRED);
        this.assertCannotViewVoters(ISSUE_WITH_VOTE);
        this.assertCannotViewVoters(ISSUE_RESOLVED_WITH_VOTE);
        this.navigation.logout();
        this.assertCannotViewVoters(ISSUE_WITH_VOTE);
        this.assertCannotViewVoters(ISSUE_RESOLVED_WITH_VOTE);
    }

    public void testVoteNoViewPermission() throws Exception {
        this.navigation.login(USER_FRED);
        this.gotoIssue(ISSUE_WITHOUT_VOTE);
        TestVoters.assertEquals((int)0, (int)this.getVoteCount());
        this.tester.clickLink(ID_VOTE_LINK);
        TestVoters.assertEquals((int)1, (int)this.getVoteCount());
    }

    private void assertCanViewVoters() {
        this.assertions.assertNodeExists(XPATH_VIEW_VOTERS_LINK);
        this.tester.assertLinkPresent(ID_VOTERS_ACTION);
        this.assertions.assertNodeExists(XPATH_VIEW_VOTERS_SPAN);
        this.tester.clickLink(ID_VOTE_COUNT_LINK);
        this.tester.assertTextPresent("Voters");
    }

    private void assertCannotViewVoters(Issue issue) {
        this.gotoIssue(issue);
        this.assertions.assertNodeDoesNotExist(XPATH_VIEW_VOTERS_LINK);
        this.tester.assertLinkNotPresent(ID_VOTERS_ACTION);
        this.assertions.assertNodeExists(XPATH_VIEW_VOTERS_SPAN);
        this.gotoViewVotersDirectly(issue);
        this.tester.assertTextPresent("Access Denied");
    }

    private void assertUserVoted() {
        this.assertVotingLinks(true);
        TestVoters.assertEquals((String)"Remove vote for this issue", (String)this.getXpathText(XPATH_VOTE_LINK_TITLE));
        this.assertTextPresentInElement(ID_VOTE_LINK, "Voted");
    }

    private void assertUserNotVoted() {
        this.assertVotingLinks(false);
        TestVoters.assertEquals((String)"Vote for this issue", (String)this.getXpathText(XPATH_VOTE_LINK_TITLE));
        this.assertTextPresentInElement(ID_VOTE_LINK, "Vote");
    }

    private void assertCantVote(Issue issue, String cantVoteTitle, String cantVoteError, int votes) {
        this.gotoIssue(issue);
        this.tester.assertLinkNotPresent(ID_VOTE_LINK);
        this.tester.assertLinkNotPresent(ID_VOTE_ACTION);
        this.assertTextPresentInElement(ID_VOTE_SPAN, "Vote");
        TestVoters.assertEquals((String)cantVoteTitle, (String)this.getXpathText(XPATH_VOTE_SPAN_TITLE));
        TestVoters.assertEquals((int)votes, (int)this.getVoteCount());
        this.voteDirectlyForIssue(issue);
        this.assertions.getTextAssertions().assertTextPresent(new WebPageLocator(this.tester), cantVoteError);
        this.gotoIssue(issue);
        TestVoters.assertEquals((int)votes, (int)this.getVoteCount());
    }

    private void assertTextPresentInElement(String elementId, String expectedText) {
        this.assertions.getTextAssertions().assertTextPresent(new IdLocator(this.tester, elementId), expectedText);
    }

    private void gotoIssue(Issue issue) {
        this.navigation.issue().gotoIssue(issue.getKey());
    }

    private void voteDirectlyForIssue(Issue issue) {
        this.navigation.gotoPage(this.page.addXsrfToken(String.format("/secure/VoteOrWatchIssue.jspa?id=%d&vote=vote", issue.getId())));
    }

    private void unVoteDirectlyForIssue(Issue issue) {
        this.navigation.gotoPage(this.page.addXsrfToken(String.format("/secure/VoteOrWatchIssue.jspa?id=%d&vote=unvote", issue.getId())));
    }

    private void gotoViewVotersDirectly(Issue issue) {
        this.navigation.gotoPage(String.format("secure/ViewVoters!default.jspa?id=%d", issue.getId()));
    }

    private int getVoteCount() {
        String s = StringUtils.trimToNull((String)new IdLocator(this.tester, ID_VOTE_COUNT).getText());
        if (s != null) {
            return Integer.parseInt(s);
        }
        TestVoters.fail((String)"Unable to find voting count.");
        return Integer.MIN_VALUE;
    }

    private String getXpathText(String xpath) {
        return StringUtils.trimToNull((String)new XPathLocator(this.tester, xpath).getText());
    }

    private static class Issue {
        private final String key;
        private final long id;

        private Issue(String key, long id) {
            this.key = key;
            this.id = id;
        }

        public String getKey() {
            return this.key;
        }

        public long getId() {
            return this.id;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

