/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.assertions.LabelAssertions;
import com.atlassian.jira.functest.framework.labels.Labels;
import com.atlassian.jira.util.collect.CollectionBuilder;
import java.util.Set;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestLabelsFormats
extends FuncTestCase {
    private static final String HSP1_ID = "10000";
    private static final String HSP2_ID = "10001";
    private static final String LABELS_FIELD = "labels";
    private static final String EPIC_FIELD = "customfield_10000";
    private static final Set<String> EMPTY_LABELS = CollectionBuilder.newBuilder().asHashSet();
    private static final Set<String> EXPECTED_LABELS = CollectionBuilder.newBuilder("1111", "2222", "333,333", "444").asHashSet();
    private static final Set<String> EXPECTED_EPICS = CollectionBuilder.newBuilder("aaa", "bbbb", "cccc,ccc", "dddd").asHashSet();
    private static final String NEW = "new_";
    private static final String OLD = "old_";

    public void testViewIssue() {
        this.administration.restoreData("TestLabelsFormat.xml");
        this.navigation.issue().viewIssue("HSP-1");
        LabelAssertions labelAssertions = this.assertions.getLabelAssertions();
        Labels expectedLabels = new Labels(true, true, true, EXPECTED_LABELS);
        Labels expectedEpic = new Labels(true, true, true, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP1_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabels(HSP1_ID, EPIC_FIELD, expectedEpic);
        this.navigation.issue().viewPrintable("HSP-1");
        expectedLabels = new Labels(false, false, false, EXPECTED_LABELS);
        expectedEpic = new Labels(false, false, false, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP1_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabels(HSP1_ID, EPIC_FIELD, expectedEpic);
        this.navigation.issue().viewIssue("HSP-2");
        expectedLabels = new Labels(true, false, false, EMPTY_LABELS);
        labelAssertions.assertLabels(HSP2_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabelsDontExist(HSP2_ID, EPIC_FIELD);
        this.navigation.issue().viewPrintable("HSP-2");
        expectedLabels = new Labels(false, false, false, EMPTY_LABELS);
        labelAssertions.assertLabels(HSP2_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabelsDontExist(HSP2_ID, EPIC_FIELD);
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.clickLink("move-issue");
        this.tester.selectOption("issuetype", "New Feature");
        this.tester.clickButton("next_submit");
        this.navigation.gotoPage("/secure/MoveIssueUpdateFields.jspa?id=10001&" + this.createUrlString(LABELS_FIELD, EXPECTED_LABELS) + "&" + this.createUrlString(EPIC_FIELD, EXPECTED_EPICS));
        expectedLabels = new Labels(false, false, true, EXPECTED_LABELS);
        expectedEpic = new Labels(false, false, true, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP2_ID, "new_labels", expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, "new_customfield_10000", expectedEpic);
        expectedLabels = new Labels(false, false, false, EMPTY_LABELS);
        expectedEpic = new Labels(false, false, false, EMPTY_LABELS);
        labelAssertions.assertLabels(HSP2_ID, "old_labels", expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, "old_customfield_10000", expectedEpic);
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.clickLink("issue-to-subtask");
        this.tester.setFormElement("parentIssueKey", "HSP-1");
        this.tester.clickButton("next_submit");
        Element guid = this.tester.getDialog().getElement("guid");
        String guidStr = guid.getAttribute("value");
        this.navigation.gotoPage("/secure/ConvertIssueUpdateFields.jspa?id=10001&guid=" + guidStr + "&" + this.createUrlString(LABELS_FIELD, EXPECTED_LABELS) + "&" + this.createUrlString(EPIC_FIELD, EXPECTED_EPICS));
        expectedLabels = new Labels(false, false, true, EXPECTED_LABELS);
        expectedEpic = new Labels(false, false, true, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP2_ID, "new_labels", expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, "new_customfield_10000", expectedEpic);
        expectedLabels = new Labels(false, false, false, EMPTY_LABELS);
        expectedEpic = new Labels(false, false, false, EMPTY_LABELS);
        labelAssertions.assertLabels(HSP2_ID, "old_labels", expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, "old_customfield_10000", expectedEpic);
    }

    public void testIssueNav() {
        this.administration.restoreData("TestLabelsFormat.xml");
        this.navigation.issueNavigator().displayAllIssues();
        LabelAssertions labelAssertions = this.assertions.getLabelAssertions();
        Labels expectedLabels = new Labels(false, true, true, EXPECTED_LABELS);
        Labels expectedEpic = new Labels(false, true, true, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP1_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabels(HSP1_ID, EPIC_FIELD, expectedEpic);
        expectedLabels = new Labels(false, false, false, EMPTY_LABELS);
        expectedEpic = new Labels(false, false, false, EMPTY_LABELS);
        labelAssertions.assertLabels(HSP2_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, EPIC_FIELD, expectedEpic);
        this.tester.clickLink("printable");
        expectedLabels = new Labels(false, true, true, EXPECTED_LABELS);
        expectedEpic = new Labels(false, true, true, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP1_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabels(HSP1_ID, EPIC_FIELD, expectedEpic);
        expectedLabels = new Labels(false, false, false, EMPTY_LABELS);
        expectedEpic = new Labels(false, false, false, EMPTY_LABELS);
        labelAssertions.assertLabels(HSP2_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, EPIC_FIELD, expectedEpic);
        this.navigation.gotoPage("");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("fullContent");
        expectedLabels = new Labels(false, false, false, EXPECTED_LABELS);
        expectedEpic = new Labels(false, false, false, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP1_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabels(HSP1_ID, EPIC_FIELD, expectedEpic);
        expectedLabels = new Labels(false, false, false, EMPTY_LABELS);
        labelAssertions.assertLabels(HSP2_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabelsDontExist(HSP2_ID, EPIC_FIELD);
        this.navigation.gotoPage("");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("configure-cols");
        expectedLabels = new Labels(false, false, true, EXPECTED_LABELS);
        expectedEpic = new Labels(false, false, true, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP1_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabels(HSP1_ID, EPIC_FIELD, expectedEpic);
        expectedLabels = new Labels(false, false, false, EMPTY_LABELS);
        expectedEpic = new Labels(false, false, false, EMPTY_LABELS);
        labelAssertions.assertLabels(HSP2_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, EPIC_FIELD, expectedEpic);
    }

    public void testBulkOperations() {
        this.administration.restoreData("TestLabelsFormat.xml");
        LabelAssertions labelAssertions = this.assertions.getLabelAssertions();
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("bulkedit_all");
        Labels expectedLabels = new Labels(false, true, true, EXPECTED_LABELS);
        Labels expectedEpic = new Labels(false, true, true, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP1_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabels(HSP1_ID, EPIC_FIELD, expectedEpic);
        expectedLabels = new Labels(false, false, false, EMPTY_LABELS);
        expectedEpic = new Labels(false, false, false, EMPTY_LABELS);
        labelAssertions.assertLabels(HSP2_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, EPIC_FIELD, expectedEpic);
        this.tester.checkCheckbox("bulkedit_10001");
        this.tester.clickButton("Next");
        this.tester.setFormElement("operation", "bulk.edit.operation.name");
        this.tester.clickButton("Next");
        this.navigation.gotoPage("/secure/BulkEditDetailsValidation.jspa?actions=labels&actions=customfield_10000&" + this.createUrlString(LABELS_FIELD, EXPECTED_LABELS) + "&" + this.createUrlString(EPIC_FIELD, EXPECTED_EPICS));
        expectedLabels = new Labels(false, false, true, EXPECTED_LABELS);
        expectedEpic = new Labels(false, false, true, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP2_ID, "new_labels", expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, "new_customfield_10000", expectedEpic);
        expectedLabels = new Labels(false, false, false, EMPTY_LABELS);
        expectedEpic = new Labels(false, false, false, EMPTY_LABELS);
        labelAssertions.assertLabels(HSP2_ID, LABELS_FIELD, expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, EPIC_FIELD, expectedEpic);
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("bulkedit_all");
        this.tester.checkCheckbox("bulkedit_10001");
        this.tester.clickButton("Next");
        this.tester.setFormElement("operation", "bulk.move.operation.name");
        this.tester.clickButton("Next");
        this.tester.selectOption("10000_1_issuetype", "New Feature");
        this.tester.clickButton("Next");
        this.navigation.gotoPage("/secure/BulkMigrateSetFields.jspa?" + this.createUrlString(LABELS_FIELD, EXPECTED_LABELS) + "&" + this.createUrlString(EPIC_FIELD, EXPECTED_EPICS));
        expectedLabels = new Labels(false, false, true, EXPECTED_LABELS);
        expectedEpic = new Labels(false, false, true, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP2_ID, "10000_1_labels", expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, "10000_1_customfield_10000", expectedEpic);
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("bulkedit_all");
        this.tester.checkCheckbox("bulkedit_10001");
        this.tester.clickButton("Next");
        this.tester.setFormElement("operation", "bulk.workflowtransition.operation.name");
        this.tester.clickButton("Next");
        this.tester.setFormElement("wftransition", "jira_5_5");
        this.tester.clickButton("Next");
        this.navigation.gotoPage("/secure/BulkWorkflowTransitionEditValidation.jspa?actions=resolution&resolution=1&forcedResolution=resolution&actions=labels&actions=customfield_10000&" + this.createUrlString(LABELS_FIELD, EXPECTED_LABELS) + "&" + this.createUrlString(EPIC_FIELD, EXPECTED_EPICS));
        expectedLabels = new Labels(false, false, true, EXPECTED_LABELS);
        expectedEpic = new Labels(false, false, true, EXPECTED_EPICS);
        labelAssertions.assertLabels(HSP2_ID, "new_labels", expectedLabels);
        labelAssertions.assertLabels(HSP2_ID, "new_customfield_10000", expectedEpic);
    }

    private String createUrlString(String field, Set<String> labels) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String label : labels) {
            stringBuilder.append(field).append("=").append(label).append("&");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }
}

