/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.fields;

import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.JIRAWebTest;
import java.io.IOException;

public class TestFieldScreens
extends JIRAWebTest {
    String issueKey;
    String issueKey2;
    String customFieldId;
    String customFieldId2;
    private static final String ADDED_SCREEN_NAME = "Test Add Screen";
    private static final String COPIED_SCREEN_NAME = "Test Copy Screen";
    private static final String ADDED_SCREEN_SCHEME_NAME = "Test Add Screen Scheme";
    private static final String COPIED_SCREEN_SCHEME_NAME = "Test Copy Screen Scheme";
    private static final String ADDED_ISSUE_TYPE_SCREEN_SCHEME_NAME = "Test Add Issue Type Screen Scheme";
    private static final String COPIED_ISSUE_TYPE_SCREEN_SCHEME_NAME = "Test Copy Issue Tyep Screen Scheme";
    private static final String CUSTOM_FIELD_NAME = "Animal";
    private static final String CUSTOM_FIELD_NAME_TWO = "Approval Rating";
    private static final String TAB_NAME = "Tab for Testing";
    private static final String DEFAULT_TAB_NAME = "Field Tab";

    public TestFieldScreens(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.login("admin");
        this.restoreBlankInstance();
        this.resetSettings();
        this.customFieldId = this.addCustomField("textfield", "global", CUSTOM_FIELD_NAME, "custom field 1", null, null, null);
        this.customFieldId2 = this.addCustomField("textfield", "global", CUSTOM_FIELD_NAME_TWO, "custom field 2", null, null, null);
        this.issueKey = this.addIssue("homosapien", "HSP", "Bug", "test field screen", "Minor", null, null, null, "Administrator", "priority is added to assign issue screen", "test description for field screens", null, null, null);
        this.createIssueWithCustomField();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() {
        try {
            this.deleteAllIssuesInAllPages();
            this.removeAllCustomFields();
            super.tearDown();
        }
        catch (Throwable t) {
            TestFieldScreens.log("Some problem in tear down of " + this.getClass().getName(), t);
        }
        finally {
            this.customFieldId = null;
            this.customFieldId2 = null;
            this.issueKey = null;
        }
    }

    public void testFieldScreens() {
        this.fieldScreensAddFieldToFieldScreen();
        this.fieldScreensAddFieldToFieldScreenWithInvalidPosition();
        this.fieldScreensSetFieldInWorkflow();
        this.fieldScreensRemoveFieldFromFieldScreen();
        this.fieldScreensAddScreen();
        this.fieldScreensAddScreenWithDuplicateName();
        this.fieldScreensAddScreenWithInvalidName();
        this.fieldScreensStandardScreens();
        this.fieldScreensAddScreenScheme();
        this.fieldScreensAddScreenSchemeWithDuplicateName();
        this.fieldScreensAddScreenSchemeWithInvalidName();
        this.fieldScreensAddIssueTypeScreenScheme();
        this.fieldScreensAddIssueTypeScreenSchemeWithDuplicateName();
        this.fieldScreensAddIssueTypeScreenSchemeWithInvalidName();
        this.fieldScreensAddIssueTypeToScreenAssociation();
        this.fieldScreensProjectScreenSchemes();
        this.fieldScreensIssueTypeScreenSchemes();
        this.fieldScreensAddTab();
        this.fieldScreensAddTabWithDuplicateName();
        this.fieldScreensAddTabWithInvalidName();
        this.fieldScreensAddFieldToTab();
        this.fieldScreensTabViews();
        this.fieldScreensRemoveFieldFromTab();
        this.fieldScreensDeleteTab();
        this.fieldScreensCopyIssueTypeScreenSchemes();
        this.fieldScreensDeleteIssueTypeScreenSchemes();
        this.fieldScreensCopyScreenScheme();
        this.fieldScreensDeleteScreenScheme();
        this.fieldScreensCopyScreen();
        this.fieldScreensDeleteScreen();
    }

    public void testFieldScreensOrdering() {
        TestFieldScreens.log("Testing Ordering of options for fields in field screens");
        String[] optionValue = new String[]{"null", "Summary", "Issue Type", "Description", "Priority", "Reporter"};
        String[] optionId = new String[]{"null", "summary", "issuetype", "description", "priority", "reporter"};
        this.resetInAscendingOrdering(optionId, "Field");
        this.checkOrderingUsingArrows(optionValue, optionId);
        this.checkOrderingUsingMoveToPos(optionValue, optionId, "Field");
        this.removeAllFieldScreens();
    }

    private void fieldScreensAddFieldToFieldScreen() {
        String expectedRow = "1";
        this.addFieldToFieldScreen(this.ASSIGN_FIELD_SCREEN_NAME, CUSTOM_FIELD_NAME);
        if (this.findRowWithName("field_table", 1, CUSTOM_FIELD_NAME) == null) {
            TestFieldScreens.fail((String)"Field Animal was not added");
        }
        this.addFieldToFieldScreen(this.ASSIGN_FIELD_SCREEN_NAME, "Issue Type", "2");
        String issueTypeRow = this.findRowWithName("field_table", 1, "Issue Type");
        TestFieldScreens.assertTrue((boolean)issueTypeRow.equals(expectedRow));
    }

    private void fieldScreensAddFieldToFieldScreenWithInvalidPosition() {
        this.addFieldToFieldScreen(this.ASSIGN_FIELD_SCREEN_NAME, "Affects Version/s", "0");
        this.assertTextPresent("Invalid field position.");
    }

    private void fieldScreensSetFieldInWorkflow() {
        this.gotoIssue(this.issueKey);
        this.clickLinkWithText("Close Issue");
        this.assertFormElementNotPresent("customfield_" + this.customFieldId);
        this.setWorkingForm("issue-workflow-transition");
        this.submit("Transition");
        this.clickLinkWithText("Reopen Issue");
        this.setFormElement("customfield_" + this.customFieldId, "Polar Bear");
        this.setWorkingForm("issue-workflow-transition");
        this.submit("Transition");
    }

    private void fieldScreensRemoveFieldFromFieldScreen() {
        String[] fieldNames = new String[]{CUSTOM_FIELD_NAME, "Issue Type"};
        this.removeFieldFromFieldScreen(this.ASSIGN_FIELD_SCREEN_NAME, fieldNames);
        for (int i = 0; i < fieldNames.length; ++i) {
            if (this.findRowWithName("field_table", 1, fieldNames[i]) == null) continue;
            TestFieldScreens.fail((String)("Field " + fieldNames[i] + " was not removed"));
        }
    }

    private void fieldScreensAddScreen() {
        this.addScreen(ADDED_SCREEN_NAME, "");
        this.assertLinkPresent("delete_fieldscreen_Test Add Screen");
    }

    private void fieldScreensAddScreenWithDuplicateName() {
        this.addScreen(ADDED_SCREEN_NAME, "");
        this.assertTextPresent("A Screen with this name already exists.");
    }

    private void fieldScreensAddScreenWithInvalidName() {
        this.addScreen("", "");
        this.assertTextPresent("You must enter a valid name.");
    }

    private void fieldScreensDeleteScreen() {
        this.deleteScreen(ADDED_SCREEN_NAME);
        this.assertLinkNotPresent("delete_fieldscreen_Test Add Screen");
        this.deleteScreen(COPIED_SCREEN_NAME);
        this.assertLinkNotPresent("delete_fieldscreen_Test Copy Screen");
    }

    private void fieldScreensCopyScreen() {
        this.copyScreen(this.ASSIGN_FIELD_SCREEN_NAME, COPIED_SCREEN_NAME, "");
        this.clickLink("configure_fieldscreen_" + this.ASSIGN_FIELD_SCREEN_NAME);
        if (this.findRowWithName("field_table", 1, "Assignee") != null) {
            this.assertFormElementNotPresent("removeField_1");
        } else {
            TestFieldScreens.fail((String)"Fields not copied");
        }
    }

    private void fieldScreensAddScreenScheme() {
        this.addFieldScreenScheme(ADDED_SCREEN_SCHEME_NAME, "", this.DEFAULT_FIELD_SCREEN_NAME);
        this.assertLinkPresent("delete_fieldscreenscheme_Test Add Screen Scheme");
    }

    private void fieldScreensAddScreenSchemeWithDuplicateName() {
        this.addFieldScreenScheme(ADDED_SCREEN_SCHEME_NAME, "", this.DEFAULT_FIELD_SCREEN_NAME);
        this.assertTextPresent("A screen scheme with this name already exists.");
    }

    private void fieldScreensAddScreenSchemeWithInvalidName() {
        this.addFieldScreenScheme("", "", this.DEFAULT_FIELD_SCREEN_NAME);
        this.assertTextPresent("You must enter a valid name.");
    }

    private void fieldScreensCopyScreenScheme() {
        this.copyFieldScreenScheme(ADDED_SCREEN_SCHEME_NAME, COPIED_SCREEN_SCHEME_NAME, "");
        this.clickLink("configure_fieldscreenscheme_Test Copy Screen Scheme");
        this.assertLinkPresent("edit_fieldscreenscheme_" + this.DEFAULT_OPERATION_SCREEN);
    }

    private void fieldScreensDeleteScreenScheme() {
        this.deleteFieldScreenScheme(COPIED_SCREEN_SCHEME_NAME);
        this.assertLinkNotPresent("delete_fieldscreenscheme_Test Copy Screen Scheme");
        this.deleteFieldScreenScheme(ADDED_SCREEN_SCHEME_NAME);
        this.assertLinkNotPresent("delete_fieldscreenscheme_Test Add Screen Scheme");
    }

    private void fieldScreensAddIssueTypeScreenScheme() {
        this.addIssueTypeFieldScreenScheme(ADDED_ISSUE_TYPE_SCREEN_SCHEME_NAME, "", this.DEFAULT_SCREEN_SCHEME);
        this.assertLinkPresent("delete_issuetypescreenscheme_Test Add Issue Type Screen Scheme");
    }

    private void fieldScreensAddIssueTypeScreenSchemeWithDuplicateName() {
        this.addIssueTypeFieldScreenScheme(ADDED_ISSUE_TYPE_SCREEN_SCHEME_NAME, "", this.DEFAULT_SCREEN_SCHEME);
        this.assertTextPresent("A scheme with this name already exists.");
    }

    private void fieldScreensAddIssueTypeScreenSchemeWithInvalidName() {
        this.addIssueTypeFieldScreenScheme("", "", this.DEFAULT_SCREEN_SCHEME);
        this.assertTextPresent("You must enter a valid name.");
    }

    private void fieldScreensAddIssueTypeToScreenAssociation() {
        this.addIssueTypeToScreenAssociation(ADDED_ISSUE_TYPE_SCREEN_SCHEME_NAME, "Bug", ADDED_SCREEN_SCHEME_NAME);
        this.assertLinkPresent("delete_issuetypescreenschemeentity_Bug");
    }

    private void fieldScreensCopyIssueTypeScreenSchemes() {
        this.copyIssueTypeFieldScreenSchemeName(ADDED_ISSUE_TYPE_SCREEN_SCHEME_NAME, COPIED_ISSUE_TYPE_SCREEN_SCHEME_NAME, "");
        this.clickLink("configure_issuetypescreenscheme_Test Copy Issue Tyep Screen Scheme");
        this.assertLinkPresent("edit_issuetypescreenschemeentity_default");
        this.assertLinkPresent("edit_issuetypescreenschemeentity_Bug");
    }

    private void fieldScreensDeleteIssueTypeScreenSchemes() {
        this.deleteIssueTypeFieldScreenScheme(COPIED_ISSUE_TYPE_SCREEN_SCHEME_NAME);
        this.assertLinkNotPresent("delete_issuetypescreenscheme_Test Copy Issue Tyep Screen Scheme");
        this.associateIssueTypeScreenSchemeToProject("neanderthal", this.DEFAULT_ISSUE_TYPE_SCREEN_SCHEME);
        this.deleteIssueTypeFieldScreenScheme(ADDED_ISSUE_TYPE_SCREEN_SCHEME_NAME);
        this.assertLinkNotPresent("delete_issuetypescreenscheme_Test Add Issue Type Screen Scheme");
    }

    private void fieldScreensAddTab() {
        TestFieldScreens.log("Adding tabs");
        this.addTabToScreen(ADDED_SCREEN_NAME, TAB_NAME);
        this.assertTextPresent(TAB_NAME);
        this.assertLinkPresentWithText(DEFAULT_TAB_NAME);
    }

    private void fieldScreensDeleteTab() {
        TestFieldScreens.log("Deleting tabs");
        this.deleteTabFromScreen(ADDED_SCREEN_NAME, TAB_NAME);
        this.assertLinkNotPresentWithText(TAB_NAME);
    }

    private void fieldScreensAddFieldToTab() {
        this.addFieldToFieldScreenTab(ADDED_SCREEN_NAME, TAB_NAME, CUSTOM_FIELD_NAME, "");
        if (this.findRowWithName("field_table", 1, CUSTOM_FIELD_NAME) == null) {
            TestFieldScreens.fail((String)"Field was not added to tab");
        }
        this.addFieldToFieldScreenTab(ADDED_SCREEN_NAME, DEFAULT_TAB_NAME, CUSTOM_FIELD_NAME_TWO, "");
        this.addFieldToFieldScreenTab(ADDED_SCREEN_NAME, DEFAULT_TAB_NAME, "Summary", "");
    }

    private void fieldScreensAddTabWithDuplicateName() {
        this.addTabToScreen(ADDED_SCREEN_NAME, TAB_NAME);
        this.assertTextPresent("Field Tab with this name already exists.");
    }

    private void fieldScreensAddTabWithInvalidName() {
        this.addTabToScreen(ADDED_SCREEN_NAME, "");
        this.assertTextPresent("You must enter a valid name.");
    }

    private void fieldScreensRemoveFieldFromTab() {
        this.removeFieldFromFieldScreenTab(ADDED_SCREEN_NAME, TAB_NAME, new String[]{CUSTOM_FIELD_NAME});
        if (this.findRowWithName("field_table", 1, CUSTOM_FIELD_NAME) != null) {
            TestFieldScreens.fail((String)"Fields not deleted.");
        }
        this.removeFieldFromFieldScreenTab(ADDED_SCREEN_NAME, DEFAULT_TAB_NAME, new String[]{"Summary", CUSTOM_FIELD_NAME_TWO});
        if (this.findRowWithName("field_table", 1, CUSTOM_FIELD_NAME_TWO) != null) {
            TestFieldScreens.fail((String)"Fields not deleted.");
        }
    }

    private void fieldScreensIssueTypeScreenSchemes() {
        TestFieldScreens.log("Check schemes using issue type based schemes");
        this.associateIssueTypeScreenSchemeToProject("neanderthal", ADDED_ISSUE_TYPE_SCREEN_SCHEME_NAME);
        this.addFieldToFieldScreen(ADDED_SCREEN_NAME, "Summary");
        this.addFieldToFieldScreen(ADDED_SCREEN_NAME, CUSTOM_FIELD_NAME);
        String issueKeyCustomField = this.checkCreateIssueScreenScheme(ADDED_SCREEN_SCHEME_NAME, "neanderthal", "NDT", "Bug");
        this.checkViewIssueScreenScheme(ADDED_SCREEN_SCHEME_NAME, "neanderthal", "Bug", issueKeyCustomField);
        this.checkEditIssueScreenScheme(ADDED_SCREEN_SCHEME_NAME, "neanderthal", "Bug", issueKeyCustomField);
        this.addIssueOperationToScreenAssociation(ADDED_SCREEN_SCHEME_NAME, this.CREATE_ISSUE_OPERATION_SCREEN, ADDED_SCREEN_NAME);
        this.addIssueOperationToScreenAssociation(ADDED_SCREEN_SCHEME_NAME, this.VIEW_ISSUE_OPERATION_SCREEN, ADDED_SCREEN_NAME);
        this.addIssueOperationToScreenAssociation(ADDED_SCREEN_SCHEME_NAME, this.EDIT_ISSUE_OPERATION_SCREEN, ADDED_SCREEN_NAME);
        this.checkNoScreenScheme("neanderthal", "Improvement", this.issueKey2);
        this.deleteIssueOperationFromScreenAssociation(ADDED_SCREEN_SCHEME_NAME, this.CREATE_ISSUE_OPERATION_SCREEN);
        this.deleteIssueOperationFromScreenAssociation(ADDED_SCREEN_SCHEME_NAME, this.VIEW_ISSUE_OPERATION_SCREEN);
        this.deleteIssueOperationFromScreenAssociation(ADDED_SCREEN_SCHEME_NAME, this.EDIT_ISSUE_OPERATION_SCREEN);
        this.checkNoScreenScheme("neanderthal", "Bug", issueKeyCustomField);
        this.removeFieldFromFieldScreen(ADDED_SCREEN_NAME, new String[]{"Summary", CUSTOM_FIELD_NAME});
        this.associateIssueTypeScreenSchemeToProject("neanderthal", this.DEFAULT_ISSUE_TYPE_SCREEN_SCHEME);
    }

    private void fieldScreensProjectScreenSchemes() {
        TestFieldScreens.log("Check screens using project based schemes");
        this.associateIssueTypeScreenSchemeToProject("homosapien", ADDED_ISSUE_TYPE_SCREEN_SCHEME_NAME);
        this.addFieldToFieldScreen(ADDED_SCREEN_NAME, "Summary");
        this.addFieldToFieldScreen(ADDED_SCREEN_NAME, CUSTOM_FIELD_NAME);
        String issueKeyCustomField = this.checkCreateIssueScreenScheme(ADDED_SCREEN_SCHEME_NAME, "homosapien", "HSP", "Bug");
        this.checkViewIssueScreenScheme(ADDED_SCREEN_SCHEME_NAME, "homosapien", "Bug", issueKeyCustomField);
        this.checkEditIssueScreenScheme(ADDED_SCREEN_SCHEME_NAME, "homosapien", "Bug", issueKeyCustomField);
        this.addIssueOperationToScreenAssociation(ADDED_SCREEN_SCHEME_NAME, this.CREATE_ISSUE_OPERATION_SCREEN, ADDED_SCREEN_NAME);
        this.addIssueOperationToScreenAssociation(ADDED_SCREEN_SCHEME_NAME, this.VIEW_ISSUE_OPERATION_SCREEN, ADDED_SCREEN_NAME);
        this.addIssueOperationToScreenAssociation(ADDED_SCREEN_SCHEME_NAME, this.EDIT_ISSUE_OPERATION_SCREEN, ADDED_SCREEN_NAME);
        this.checkNoScreenScheme("neanderthal", "Bug", this.issueKey2);
        this.deleteIssueOperationFromScreenAssociation(ADDED_SCREEN_SCHEME_NAME, this.CREATE_ISSUE_OPERATION_SCREEN);
        this.deleteIssueOperationFromScreenAssociation(ADDED_SCREEN_SCHEME_NAME, this.VIEW_ISSUE_OPERATION_SCREEN);
        this.deleteIssueOperationFromScreenAssociation(ADDED_SCREEN_SCHEME_NAME, this.EDIT_ISSUE_OPERATION_SCREEN);
        this.removeFieldFromFieldScreen(ADDED_SCREEN_NAME, new String[]{"Summary", CUSTOM_FIELD_NAME});
        this.checkNoScreenScheme("homosapien", "Bug", issueKeyCustomField);
        this.associateIssueTypeScreenSchemeToProject("homosapien", this.DEFAULT_ISSUE_TYPE_SCREEN_SCHEME);
    }

    private void fieldScreensStandardScreens() {
        TestFieldScreens.log("Check screens for standard settings");
        this.addFieldToFieldScreen(ADDED_SCREEN_NAME, "Summary");
        this.addFieldToFieldScreen(ADDED_SCREEN_NAME, CUSTOM_FIELD_NAME);
        String issueKeyCustomField = this.checkCreateIssueScreenScheme(this.DEFAULT_SCREEN_SCHEME, "homosapien", "HSP", "Bug");
        this.checkViewIssueScreenScheme(this.DEFAULT_SCREEN_SCHEME, "homosapien", "Bug", issueKeyCustomField);
        this.checkEditIssueScreenScheme(this.DEFAULT_SCREEN_SCHEME, "homosapien", "Bug", issueKeyCustomField);
        this.removeFieldFromFieldScreen(ADDED_SCREEN_NAME, new String[]{"Summary", CUSTOM_FIELD_NAME});
        this.checkNoScreenScheme("homosapien", "Bug", issueKeyCustomField);
    }

    protected void fieldScreensTabViews() {
        this.addIssueOperationToScreenAssociation(this.DEFAULT_SCREEN_SCHEME, this.CREATE_ISSUE_OPERATION_SCREEN, ADDED_SCREEN_NAME);
        this.addIssueOperationToScreenAssociation(this.DEFAULT_SCREEN_SCHEME, this.VIEW_ISSUE_OPERATION_SCREEN, ADDED_SCREEN_NAME);
        this.addIssueOperationToScreenAssociation(this.DEFAULT_SCREEN_SCHEME, this.EDIT_ISSUE_OPERATION_SCREEN, ADDED_SCREEN_NAME);
        this.createIssueStep1();
        this.setFormElement("customfield_" + this.customFieldId2, "High");
        this.setFormElement("summary", "This is a test issue");
        this.setFormElement("customfield_" + this.customFieldId, "Rhino");
        this.submit("Create");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//ul[@id=\"tabCellPane1\"]/li[1]//strong"), CUSTOM_FIELD_NAME_TWO);
        this.text.assertTextPresent(new XPathLocator(this.tester, "//ul[@id=\"tabCellPane1\"]/li[1]//div[@class='wrap']/div"), "High");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//ul[@id=\"tabCellPane2\"]/li[1]//strong"), CUSTOM_FIELD_NAME);
        this.text.assertTextPresent(new XPathLocator(this.tester, "//ul[@id=\"tabCellPane2\"]/li[1]//div[@class='wrap']/div"), "Rhino");
        this.clickLink("editIssue");
        this.setFormElement("customfield_" + this.customFieldId2, "Low");
        this.setFormElement("customfield_" + this.customFieldId, "Tiger");
        this.submit("Update");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//ul[@id=\"tabCellPane1\"]/li[1]//strong"), CUSTOM_FIELD_NAME_TWO);
        this.text.assertTextPresent(new XPathLocator(this.tester, "//ul[@id=\"tabCellPane1\"]/li[1]//div[@class='wrap']/div"), "Low");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//ul[@id=\"tabCellPane2\"]/li[1]//strong"), CUSTOM_FIELD_NAME);
        this.text.assertTextPresent(new XPathLocator(this.tester, "//ul[@id=\"tabCellPane2\"]/li[1]//div[@class='wrap']/div"), "Tiger");
        this.deleteIssueOperationFromScreenAssociation(this.DEFAULT_SCREEN_SCHEME, this.CREATE_ISSUE_OPERATION_SCREEN);
        this.deleteIssueOperationFromScreenAssociation(this.DEFAULT_SCREEN_SCHEME, this.VIEW_ISSUE_OPERATION_SCREEN);
        this.deleteIssueOperationFromScreenAssociation(this.DEFAULT_SCREEN_SCHEME, this.EDIT_ISSUE_OPERATION_SCREEN);
    }

    private void fieldScreensWithRequiredFields() {
        this.setRequiredField(CUSTOM_FIELD_NAME);
        this.removeFieldFromFieldScreen(this.DEFAULT_FIELD_SCREEN_NAME, new String[]{"summary", CUSTOM_FIELD_NAME});
        this.createIssueStep1();
        this.submit();
        this.assertTextPresent("Summary: You must specify a summary of the issue.");
        this.addFieldToFieldScreen(this.DEFAULT_FIELD_SCREEN_NAME, "summary", "1");
        this.setRequiredField(CUSTOM_FIELD_NAME);
    }

    private void resetSettings() {
        if (this.projectExists("homosapien")) {
            TestFieldScreens.log("Project homosapien exists");
        } else {
            this.addProject("homosapien", "HSP", "", "admin", "project for homosapiens");
        }
        if (this.projectExists("neanderthal")) {
            TestFieldScreens.log("Project: neanderthal exists");
        } else {
            this.addProject("neanderthal", "NDT", "", "admin", "project for neanderthals.");
        }
        this.associateIssueTypeScreenSchemeToProject("homosapien", this.DEFAULT_ISSUE_TYPE_SCREEN_SCHEME);
        this.associateIssueTypeScreenSchemeToProject("neanderthal", this.DEFAULT_ISSUE_TYPE_SCREEN_SCHEME);
        this.removeAllIssueTypeScreenSchemes();
        this.removeFieldFromFieldScreen(this.ASSIGN_FIELD_SCREEN_NAME, new String[]{CUSTOM_FIELD_NAME, "Issue Type"});
        this.removeAllCustomFields();
        this.removeAllScreenAssociationsFromDefault();
        this.removeAllFieldScreenSchemes();
        this.removeAllFieldScreens();
    }

    private void createIssueWithCustomField() {
        this.addFieldToFieldScreen(this.DEFAULT_FIELD_SCREEN_NAME, CUSTOM_FIELD_NAME);
        this.createIssueStep1("neanderthal", "Improvement");
        this.setFormElement("summary", "This is an issue in project 2 with a custom field");
        this.setFormElement("customfield_" + this.customFieldId, "Elephant");
        this.submit();
        this.issueKey2 = this.getIssueKey("NDT");
        this.removeFieldFromFieldScreen(this.DEFAULT_FIELD_SCREEN_NAME, new String[]{CUSTOM_FIELD_NAME});
    }

    private String getIssueKey(String projectKey) {
        try {
            String text = this.getDialog().getResponse().getText();
            int projectIdLocation = text.indexOf(projectKey);
            int endOfIssueKey = text.indexOf("]", projectIdLocation);
            String issueKeyCustomField = text.substring(projectIdLocation, endOfIssueKey);
            return issueKeyCustomField;
        }
        catch (IOException e) {
            TestFieldScreens.fail((String)("Unable to retrieve issue key" + e.getMessage()));
            return null;
        }
    }

    private void checkNoScreenScheme(String project, String issueType, String issueKeyCustomField) {
        TestFieldScreens.log("Checking scheme association for with no scheme selected");
        this.createIssueStep1(project, issueType);
        this.assertFormElementNotPresent("customfield_" + this.customFieldId);
        this.submit();
        this.gotoIssue(issueKeyCustomField);
        this.assertTextNotPresent(CUSTOM_FIELD_NAME);
        this.clickLink("editIssue");
        this.assertFormElementNotPresent("customfield_" + this.customFieldId);
    }

    private String checkCreateIssueScreenScheme(String screenScheme, String project, String project_key, String issueType) {
        TestFieldScreens.log("Checking scheme association for Create");
        this.addIssueOperationToScreenAssociation(screenScheme, this.CREATE_ISSUE_OPERATION_SCREEN, ADDED_SCREEN_NAME);
        this.createIssueStep1(project, issueType);
        this.setFormElement("summary", "This is a test to see if field is shown");
        this.setFormElement("customfield_" + this.customFieldId, "Elephant");
        this.submit();
        this.assertTextNotPresent("Elephant");
        this.assertTextNotPresent(CUSTOM_FIELD_NAME);
        String issueKeyCustomField = this.getIssueKey(project_key);
        this.clickLink("editIssue");
        this.assertFormElementNotPresent("customfield_" + this.customFieldId);
        this.deleteIssueOperationFromScreenAssociation(screenScheme, this.CREATE_ISSUE_OPERATION_SCREEN);
        return issueKeyCustomField;
    }

    private void checkViewIssueScreenScheme(String screenScheme, String project, String issueType, String issueKeyCustomField) {
        TestFieldScreens.log("Checking scheme association for View");
        this.addIssueOperationToScreenAssociation(screenScheme, this.VIEW_ISSUE_OPERATION_SCREEN, ADDED_SCREEN_NAME);
        this.createIssueStep1(project, issueType);
        this.assertFormElementNotPresent("customfield_" + this.customFieldId);
        this.gotoIssue(issueKeyCustomField);
        this.assertTextPresent("Elephant");
        this.assertTextPresent(CUSTOM_FIELD_NAME);
        this.clickLink("editIssue");
        this.assertFormElementNotPresent("customfield_" + this.customFieldId);
        this.deleteIssueOperationFromScreenAssociation(screenScheme, this.VIEW_ISSUE_OPERATION_SCREEN);
    }

    private void checkEditIssueScreenScheme(String screenScheme, String project, String issueType, String issueKeyCustomField) {
        TestFieldScreens.log("Checking scheme association for Edit");
        this.addIssueOperationToScreenAssociation(screenScheme, this.EDIT_ISSUE_OPERATION_SCREEN, ADDED_SCREEN_NAME);
        this.createIssueStep1(project, issueType);
        this.assertFormElementNotPresent("customfield_" + this.customFieldId);
        this.gotoIssue(issueKeyCustomField);
        this.clickLink("editIssue");
        this.setFormElement("customfield_" + this.customFieldId, "Whale");
        this.submit();
        this.assertTextNotPresent("Whale");
        this.assertTextNotPresent(CUSTOM_FIELD_NAME);
        this.deleteIssueOperationFromScreenAssociation(screenScheme, this.EDIT_ISSUE_OPERATION_SCREEN);
    }
}

